/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJob;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

class SQLSource
extends Source {
    private final SQLSourceType sourceType;
    private final String connectionDisplayName;
    private String privateConnectionName;
    private final LinkedList<Connection> connectionPool;
    private final Map<String, SQLJob> jobMap;

    SQLSource(SQLSourceType sQLSourceType, String string) {
        super(sQLSourceType, string);
        this.sourceType = sQLSourceType;
        this.connectionDisplayName = Connections.getDisplayName(string);
        this.connectionPool = new LinkedList();
        this.jobMap = new HashMap<String, SQLJob>();
        for (SQLJobType sQLJobType : sQLSourceType.jobTypeMap().values()) {
            SQLJob sQLJob = new SQLJob(sQLJobType, this);
            this.jobMap.put(sQLJobType.getJobPath(), sQLJob);
        }
    }

    @Override
    public SQLSourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    protected String getConnectionDisplayName() {
        return this.connectionDisplayName;
    }

    protected Map<String, SQLJob> jobMap() {
        return this.jobMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(int n) {
        Class<SQLSource> clazz = SQLSource.class;
        synchronized (SQLSource.class) {
            Connection connection = null;
            try {
                if (this.privateConnectionName == null) {
                    this.privateConnectionName = Connections.getInstance().createPrivateConnection(this.getConnectionName());
                }
                connection = Connections.getInstance().getConnection(this.privateConnectionName);
            }
            catch (DBException | ConnectionException throwable) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 == null) {
                    throwable2 = throwable;
                }
                throw new DXException(throwable2);
            }
            try {
                int n2;
                this.initializeConnection(connection);
                this.connectionPool.add(connection);
                for (n2 = 1; n2 < n; ++n2) {
                    Connection connection2 = Connections.getInstance().cloneConnection(connection);
                    this.initializeConnection(connection2);
                    this.connectionPool.add(connection2);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    this.connectionPool.get(n2).setAutoCommit(true);
                }
            }
            catch (Exception exception) {
                this.closeAll();
                this.connectionPool.clear();
                throw new DXException(exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() {
        Class<SQLSource> clazz = SQLSource.class;
        synchronized (SQLSource.class) {
            if (this.connectionPool.size() == 0) {
                throw new DXException("connection not available");
            }
            boolean bl = false;
            if (this.privateConnectionName != null) {
                try {
                    Database database = Connections.getInstance().getDatabase(this.privateConnectionName);
                    if (database != null) {
                        bl = database.isConnectionAlive();
                    } else {
                        logger.log(Level.WARNING, "Database object not found, assume connection died: {0}", this.getConnectionName());
                    }
                }
                catch (DBException dBException) {
                    logger.log(Level.WARNING, "Database object not found, assume connection died: " + this.getConnectionName(), dBException);
                }
            }
            if (!bl) {
                this.closeAll();
                this.connectionPool.clear();
                throw new DXException("connection has died");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnect() {
        Class<SQLSource> clazz = SQLSource.class;
        synchronized (SQLSource.class) {
            if (this.connectionPool.size() > 0) {
                this.closeAll();
                this.connectionPool.clear();
            }
            if (this.privateConnectionName != null) {
                try {
                    String string = Connections.getDisplayName(this.privateConnectionName);
                    DatabaseConnections databaseConnections = Connections.getInstance().getTemporaryConnectionStore();
                    databaseConnections.removeConnection(string);
                }
                catch (RuntimeException | ConnectionException throwable) {
                    logger.log(Level.WARNING, "Unable to close connection: " + this.getConnectionName(), throwable);
                }
                this.privateConnectionName = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected boolean cancelConnect() {
        return false;
    }

    @Override
    protected boolean cancelCheck() {
        return false;
    }

    @Override
    protected boolean cancelDisconnect() {
        return false;
    }

    synchronized Connection acquireJDBCConnection() {
        return this.connectionPool.removeFirst();
    }

    synchronized void releaseJDBCConnection(Connection connection) {
        this.connectionPool.addLast(connection);
    }

    private void initializeConnection(Connection connection) throws SQLException {
        try (CallableStatement callableStatement = connection.prepareCall("{call DBMS_APPLICATION_INFO.SET_CLIENT_INFO('Metrics Engine') }");){
            callableStatement.execute();
            connection.commit();
        }
    }

    private void closeAll() {
        try {
            Connections.getInstance().closeConnection(this.privateConnectionName);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error in closing primary connection: " + this.getConnectionName(), exception);
        }
        for (Connection connection : this.connectionPool) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error in closing pooled connection: : " + this.getConnectionName(), exception);
            }
        }
    }
}

