/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.InputEventImplementation;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.engine.PropertyService;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.StateMachine;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXSourceAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;

public abstract class Source {
    private Engine engine;
    private URI sourceId;
    private int pinnedJobCount;
    private int activeJobCount;
    private int jobRunningCount;
    private Deque<Job> jobQueue;
    private String connectionName;
    private Map<String, Item> itemMap;
    private Future<?> connectTimerFuture;
    private volatile boolean taskCancelled;
    private EnumMap<State, StateActions> stateActionsMap;
    private final StateMachine<State, StateActions> stateMachine;
    private long minimumInterval;
    private int connectionCount;
    protected static final Logger logger = Logger.getLogger(Source.class.getName());

    protected Source(SourceType sourceType, String string) {
        this.connectionName = string;
        this.sourceId = DXIds.newId(sourceType.getSourceTypeId(), string, sourceType.getSourcePath());
        this.jobQueue = new LinkedList<Job>();
        this.minimumInterval = sourceType.getMinimumInterval(this);
        this.stateActionsMap = new EnumMap(State.class);
        this.stateActionsMap.put(State.NO_JOBS_PINNED, new NoJobsPinnedActions());
        this.stateActionsMap.put(State.JOBS_PINNED, new JobsPinnedActions());
        this.stateActionsMap.put(State.CONNECTED, new ConnectedActions());
        this.stateActionsMap.put(State.UNCONNECTED, new UnconnectedActions());
        this.stateActionsMap.put(State.JOB_RUNNING, new JobRunningActions());
        this.stateActionsMap.put(State.JOB_RUNNING_NO_JOBS_ACTIVE, new JobRunningNoJobsActiveActions());
        this.stateActionsMap.put(State.JOB_RUNNING_NO_JOBS_PINNED, new JobRunningNoJobsPinnedActions());
        this.stateActionsMap.put(State.CONNECTING, new ConnectingActions());
        this.stateActionsMap.put(State.CONNECTING_NO_JOBS_ACTIVE, new ConnectingNoJobsActiveActions());
        this.stateActionsMap.put(State.CONNECTING_NO_JOBS_PINNED, new ConnectingNoJobsPinnedActions());
        this.stateActionsMap.put(State.CHECKING, new CheckingActions());
        this.stateActionsMap.put(State.CHECKING_NO_JOBS_ACTIVE, new CheckingNoJobsActiveActions());
        this.stateActionsMap.put(State.CHECKING_NO_JOBS_PINNED, new CheckingNoJobsPinnedActions());
        this.stateActionsMap.put(State.DISCONNECTING, new DisconnectingActions());
        this.stateActionsMap.put(State.DISCONNECTING_NO_JOBS_ACTIVE, new DisconnectingNoJobsActiveActions());
        this.stateActionsMap.put(State.DISCONNECTING_NO_JOBS_PINNED, new DisconnectingNoJobsPinnedActions());
        this.stateActionsMap.put(State.REMOVED, new RemovedActions());
        this.stateMachine = new StateMachine<State, StateActions>(this.stateActionsMap, State.NO_JOBS_PINNED){

            @Override
            URI getId() {
                return Source.this.sourceId;
            }

            @Override
            Engine getEngine() {
                return Source.this.engine;
            }
        };
    }

    public abstract SourceType getSourceType();

    public URI getSourceId() {
        return this.sourceId;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    protected abstract String getConnectionDisplayName();

    protected abstract Map<String, ? extends Job> jobMap();

    protected abstract void connect(int var1);

    protected abstract void check();

    protected abstract void disconnect();

    protected abstract boolean cancelConnect();

    protected abstract boolean cancelCheck();

    protected abstract boolean cancelDisconnect();

    protected boolean isTaskCancelled() {
        return this.taskCancelled;
    }

    void attach(Engine engine) {
        assert (Engine.isMetricsThread());
        this.engine = engine;
        PropertyService propertyService = engine.getPropertyService();
        this.connectionCount = (int)propertyService.get(this.sourceId, "connectionCount", -1L);
        if (this.connectionCount < 0) {
            this.connectionCount = (int)propertyService.get(this.getSourceType().getSourceTypeId(), "connectionCount", 1L);
        }
        if (this.connectionCount > 5) {
            this.connectionCount = 5;
        } else if (this.connectionCount < 1) {
            this.connectionCount = 1;
        }
        logger.log(Level.INFO, "source ''{0}'' opened with pool size {1}", new Object[]{this.sourceId, this.connectionCount});
        for (Job job : this.jobMap().values()) {
            job.attach(engine);
        }
        engine.addNotification(new EngineNotification<DXSourceAdd>(engine){

            @Override
            DXSourceAdd createEvent() {
                return this.createSourceAddEvent(DXEvent.Type.SOURCE_ADD, Source.this);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXSourceAdd dXSourceAdd) {
                dXEngineListener.onAdd(dXSourceAdd);
            }
        });
    }

    Engine getEngine() {
        return this.engine;
    }

    State getState() {
        return this.stateMachine.getState();
    }

    Map<String, Item> itemMap() {
        assert (Engine.isMetricsThread());
        if (this.itemMap == null) {
            this.itemMap = new HashMap<String, Item>();
            for (Job job : this.jobMap().values()) {
                for (Item item : job.itemMap().values()) {
                    this.itemMap.put(item.getItemType().getItemPath(), item);
                }
            }
        }
        return this.itemMap;
    }

    long getMinimumInterval() {
        return this.minimumInterval;
    }

    void setMinimumInterval(long l) {
        this.minimumInterval = l;
    }

    InputEvent createJobPinned() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.jobPinned();
            }

            @Override
            String getName() {
                return "jobPinned";
            }
        };
    }

    InputEvent createJobUnpinned() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.jobUnpinned();
            }

            @Override
            String getName() {
                return "jobUnpinned";
            }
        };
    }

    InputEvent createJobActivated() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.jobActivated();
            }

            @Override
            String getName() {
                return "jobActivated";
            }
        };
    }

    InputEvent createJobInactivated() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.jobInactivated();
            }

            @Override
            String getName() {
                return "jobInactivated";
            }
        };
    }

    InputEvent createQueueJob(final Job job) {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.queueJob(job);
            }

            @Override
            String getName() {
                return "queueJob";
            }
        };
    }

    InputEvent createCancelQueueJob(final Job job) {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.cancelQueueJob(job);
            }

            @Override
            String getName() {
                return "cancelQueueJob";
            }
        };
    }

    InputEvent createJobRunCompleted(final DXException dXException) {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.jobRunCompleted(dXException);
            }

            @Override
            String getName() {
                return "jobRunCompleted";
            }
        };
    }

    InputEvent createConnectTimerExpired() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.connectTimerExpired();
            }

            @Override
            String getName() {
                return "connectTimerExpired";
            }
        };
    }

    InputEvent createConnectCompleted(final DXException dXException) {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.connectCompleted(dXException);
            }

            @Override
            String getName() {
                return "connectCompleted";
            }
        };
    }

    InputEvent createCheckCompleted(final DXException dXException) {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.checkCompleted(dXException);
            }

            @Override
            String getName() {
                return "checkCompleted";
            }
        };
    }

    InputEvent createDisconnectCompleted() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.disconnectCompleted();
            }

            @Override
            String getName() {
                return "disconnectCompleted";
            }
        };
    }

    InputEvent createRemoveSource() {
        return new SourceInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.removeSource();
            }

            @Override
            String getName() {
                return "removeSource";
            }
        };
    }

    private class RemovedActions
    extends StateActions {
        private RemovedActions() {
        }

        @Override
        State jobPinned() {
            return State.REMOVED;
        }

        @Override
        State jobUnpinned() {
            return State.REMOVED;
        }

        @Override
        State jobActivated() {
            return State.REMOVED;
        }

        @Override
        State jobInactivated() {
            return State.REMOVED;
        }

        @Override
        State queueJob(Job job) {
            return State.REMOVED;
        }

        @Override
        State cancelQueueJob(Job job) {
            return State.REMOVED;
        }

        @Override
        State jobRunCompleted(DXException dXException) {
            return State.REMOVED;
        }

        @Override
        State connectTimerExpired() {
            return State.REMOVED;
        }

        @Override
        State connectCompleted(DXException dXException) {
            return State.REMOVED;
        }

        @Override
        State checkCompleted(DXException dXException) {
            return State.REMOVED;
        }

        @Override
        State disconnectCompleted() {
            return State.REMOVED;
        }

        @Override
        State removeSource() {
            return State.REMOVED;
        }
    }

    private class DisconnectingNoJobsPinnedActions
    extends AbstractNoJobsPinnedActions {
        private DisconnectingNoJobsPinnedActions() {
        }

        @Override
        State onPinnedJobs() {
            return State.DISCONNECTING_NO_JOBS_ACTIVE;
        }

        @Override
        State disconnectCompleted() {
            return this.remove();
        }
    }

    private class DisconnectingNoJobsActiveActions
    extends AbstractNoJobsActiveActions {
        private DisconnectingNoJobsActiveActions() {
        }

        @Override
        State onNoPinnedJobs() {
            return State.DISCONNECTING_NO_JOBS_PINNED;
        }

        @Override
        State onActiveJobs() {
            return State.DISCONNECTING;
        }

        @Override
        State disconnectCompleted() {
            return State.JOBS_PINNED;
        }
    }

    private class DisconnectingActions
    extends AbstractJobsActiveActions {
        private DisconnectingActions() {
        }

        @Override
        State onNoActiveJobs() {
            return State.DISCONNECTING_NO_JOBS_ACTIVE;
        }

        @Override
        State disconnectCompleted() {
            this.submitConnectTask();
            return State.CONNECTING;
        }
    }

    private class CheckingNoJobsPinnedActions
    extends AbstractNoJobsPinnedActions {
        private CheckingNoJobsPinnedActions() {
        }

        @Override
        State onPinnedJobs() {
            return State.CHECKING_NO_JOBS_ACTIVE;
        }

        @Override
        State checkCompleted(DXException dXException) {
            State state;
            if (dXException == null) {
                this.submitDisconnectTask();
                state = State.DISCONNECTING_NO_JOBS_PINNED;
            } else {
                state = this.remove();
            }
            this.notifyDisconnect(dXException);
            return state;
        }
    }

    private class CheckingNoJobsActiveActions
    extends AbstractNoJobsActiveActions {
        private CheckingNoJobsActiveActions() {
        }

        @Override
        State onNoPinnedJobs() {
            return State.CHECKING_NO_JOBS_PINNED;
        }

        @Override
        State onActiveJobs() {
            return State.CHECKING;
        }

        @Override
        State checkCompleted(DXException dXException) {
            State state;
            if (dXException == null) {
                this.submitDisconnectTask();
                state = State.DISCONNECTING_NO_JOBS_ACTIVE;
            } else {
                state = State.JOBS_PINNED;
            }
            this.notifyDisconnect(dXException);
            return state;
        }
    }

    private class CheckingActions
    extends AbstractJobsActiveActions {
        private CheckingActions() {
        }

        @Override
        State onNoActiveJobs() {
            return State.CHECKING_NO_JOBS_ACTIVE;
        }

        @Override
        State checkCompleted(DXException dXException) {
            State state = this.onConnectionTaskCompleted(dXException);
            if (state == State.UNCONNECTED) {
                this.notifyDisconnect(dXException);
            }
            return state;
        }
    }

    private class ConnectingNoJobsPinnedActions
    extends AbstractNoJobsPinnedActions {
        private ConnectingNoJobsPinnedActions() {
        }

        @Override
        State onPinnedJobs() {
            return State.CONNECTING_NO_JOBS_ACTIVE;
        }

        @Override
        State connectCompleted(DXException dXException) {
            State state;
            if (dXException == null) {
                this.submitDisconnectTask();
                state = State.DISCONNECTING_NO_JOBS_PINNED;
            } else {
                state = this.remove();
            }
            return state;
        }
    }

    private class ConnectingNoJobsActiveActions
    extends AbstractNoJobsActiveActions {
        private ConnectingNoJobsActiveActions() {
        }

        @Override
        State onNoPinnedJobs() {
            return State.CONNECTING_NO_JOBS_PINNED;
        }

        @Override
        State onActiveJobs() {
            return State.CONNECTING;
        }

        @Override
        State connectCompleted(DXException dXException) {
            State state;
            if (dXException == null) {
                this.submitDisconnectTask();
                state = State.DISCONNECTING_NO_JOBS_ACTIVE;
            } else {
                state = State.JOBS_PINNED;
            }
            return state;
        }
    }

    private class ConnectingActions
    extends AbstractJobsActiveActions {
        private ConnectingActions() {
        }

        @Override
        State onNoActiveJobs() {
            return State.CONNECTING_NO_JOBS_ACTIVE;
        }

        @Override
        State connectCompleted(DXException dXException) {
            State state = this.onConnectionTaskCompleted(dXException);
            if (state != State.UNCONNECTED) {
                this.notifyConnect();
            }
            return state;
        }
    }

    private class JobRunningNoJobsPinnedActions
    extends AbstractNoJobsPinnedActions {
        private JobRunningNoJobsPinnedActions() {
        }

        @Override
        State onPinnedJobs() {
            return State.JOB_RUNNING_NO_JOBS_ACTIVE;
        }

        @Override
        State jobRunCompleted(DXException dXException) {
            State state;
            Source.this.jobRunningCount = Source.this.jobRunningCount - 1;
            if (Source.this.jobRunningCount == 0) {
                this.submitDisconnectTask();
                this.notifyDisconnect(dXException);
                state = State.DISCONNECTING_NO_JOBS_PINNED;
            } else {
                state = Source.this.getState();
            }
            return state;
        }
    }

    private class JobRunningNoJobsActiveActions
    extends AbstractNoJobsActiveActions {
        private JobRunningNoJobsActiveActions() {
        }

        @Override
        State onNoPinnedJobs() {
            return State.JOB_RUNNING_NO_JOBS_PINNED;
        }

        @Override
        State onActiveJobs() {
            return State.JOB_RUNNING;
        }

        @Override
        State jobRunCompleted(DXException dXException) {
            State state;
            Source.this.jobRunningCount = Source.this.jobRunningCount - 1;
            if (Source.this.jobRunningCount == 0) {
                this.submitDisconnectTask();
                this.notifyDisconnect(dXException);
                state = State.DISCONNECTING_NO_JOBS_ACTIVE;
            } else {
                state = Source.this.getState();
            }
            return state;
        }
    }

    private class JobRunningActions
    extends AbstractJobsActiveActions {
        private JobRunningActions() {
        }

        @Override
        State onNoActiveJobs() {
            return State.JOB_RUNNING_NO_JOBS_ACTIVE;
        }

        @Override
        State queueJob(Job job) {
            if (Source.this.jobRunningCount < Source.this.connectionCount) {
                Source.this.jobRunningCount = Source.this.jobRunningCount + 1;
                Source.this.engine.addEvent(job.createStartRun());
            } else {
                Source.this.jobQueue.addLast(job);
            }
            return Source.this.getState();
        }

        @Override
        State jobRunCompleted(DXException dXException) {
            State state;
            if (dXException == null) {
                Job job = this.removeFirstQueuedJob();
                if (job != null) {
                    Source.this.engine.addEvent(job.createStartRun());
                    state = State.JOB_RUNNING;
                } else {
                    Source.this.jobRunningCount = Source.this.jobRunningCount - 1;
                    state = Source.this.jobRunningCount == 0 ? State.CONNECTED : State.JOB_RUNNING;
                }
            } else {
                Source.this.jobRunningCount = Source.this.jobRunningCount - 1;
                if (Source.this.jobRunningCount == 0) {
                    this.submitCheckTask();
                    state = State.CHECKING;
                } else {
                    state = State.JOB_RUNNING;
                }
            }
            return state;
        }
    }

    private class UnconnectedActions
    extends AbstractJobsActiveActions {
        private UnconnectedActions() {
        }

        @Override
        State onNoActiveJobs() {
            this.cancelConnectTimer();
            return State.JOBS_PINNED;
        }

        @Override
        State connectTimerExpired() {
            this.submitConnectTask();
            return State.CONNECTING;
        }

        private void cancelConnectTimer() {
            Source.this.connectTimerFuture.cancel(false);
            Source.this.connectTimerFuture = null;
        }
    }

    private class ConnectedActions
    extends AbstractJobsActiveActions {
        private ConnectedActions() {
        }

        @Override
        State onNoActiveJobs() {
            this.submitDisconnectTask();
            this.notifyDisconnect(null);
            return State.DISCONNECTING_NO_JOBS_ACTIVE;
        }

        @Override
        State queueJob(Job job) {
            Source.this.engine.addEvent(job.createStartRun());
            Source.this.jobRunningCount = Source.this.jobRunningCount + 1;
            return State.JOB_RUNNING;
        }
    }

    private class JobsPinnedActions
    extends AbstractNoJobsActiveActions {
        private JobsPinnedActions() {
        }

        @Override
        State onNoPinnedJobs() {
            return this.remove();
        }

        @Override
        State onActiveJobs() {
            this.submitConnectTask();
            return State.CONNECTING;
        }
    }

    private class NoJobsPinnedActions
    extends AbstractNoJobsPinnedActions {
        private NoJobsPinnedActions() {
        }

        @Override
        State onPinnedJobs() {
            return State.JOBS_PINNED;
        }

        @Override
        State removeSource() {
            this.notifyRemove();
            Source.this.engine.removeSource(Source.this);
            logger.log(Level.INFO, "source ''{0}'' closed", new Object[]{Source.this.sourceId});
            return State.REMOVED;
        }
    }

    private abstract class AbstractJobsActiveActions
    extends StateActions {
        private AbstractJobsActiveActions() {
        }

        @Override
        State jobPinned() {
            Source.this.pinnedJobCount = Source.this.pinnedJobCount + 1;
            return Source.this.getState();
        }

        @Override
        State jobUnpinned() {
            if (Source.this.pinnedJobCount > 1) {
                Source.this.pinnedJobCount = Source.this.pinnedJobCount - 1;
            } else {
                logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            }
            return Source.this.getState();
        }

        @Override
        State jobActivated() {
            Source.this.activeJobCount = Source.this.activeJobCount + 1;
            return Source.this.getState();
        }

        @Override
        State jobInactivated() {
            Source.this.activeJobCount = Source.this.activeJobCount - 1;
            State state = Source.this.activeJobCount == 0 ? this.onNoActiveJobs() : Source.this.getState();
            return state;
        }

        @Override
        State queueJob(Job job) {
            if (Source.this.jobQueue.contains(job)) {
                logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            }
            Source.this.jobQueue.addLast(job);
            return Source.this.getState();
        }

        @Override
        State cancelQueueJob(Job job) {
            if (!Source.this.jobQueue.remove(job)) {
                logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            }
            return Source.this.getState();
        }

        State onConnectionTaskCompleted(DXException dXException) {
            State state;
            if (Source.this.jobRunningCount != 0) {
                logger.log(Level.SEVERE, "unexpected condition in state ''{0}'' for source ''{1}'' = job running count > 0", new Object[]{Source.this.getState(), Source.this.sourceId});
            }
            if (dXException == null) {
                Job job = this.removeFirstQueuedJob();
                if (job != null) {
                    Source.this.jobRunningCount = 1;
                    Source.this.engine.addEvent(job.createStartRun());
                    while (Source.this.jobRunningCount < Source.this.connectionCount && (job = this.removeFirstQueuedJob()) != null) {
                        Source.this.jobRunningCount = Source.this.jobRunningCount + 1;
                        Source.this.engine.addEvent(job.createStartRun());
                    }
                    state = State.JOB_RUNNING;
                } else {
                    state = State.CONNECTED;
                }
            } else {
                Source.this.connectTimerFuture = Source.this.engine.scheduleCommand(Source.this.minimumInterval, new Command(){

                    @Override
                    void execute() {
                        Source.this.engine.addEvent(Source.this.createConnectTimerExpired());
                    }

                    @Override
                    URI getId() {
                        return Source.this.sourceId;
                    }

                    @Override
                    String getName() {
                        return "connectTimerExpired";
                    }
                });
                state = State.UNCONNECTED;
            }
            return state;
        }

        Job removeFirstQueuedJob() {
            Job job = null;
            if (Source.this.jobQueue.size() > 0) {
                job = (Job)Source.this.jobQueue.removeFirst();
            }
            return job;
        }

        abstract State onNoActiveJobs();
    }

    private abstract class AbstractNoJobsActiveActions
    extends StateActions {
        private AbstractNoJobsActiveActions() {
        }

        @Override
        State jobPinned() {
            Source.this.pinnedJobCount = Source.this.pinnedJobCount + 1;
            return Source.this.getState();
        }

        @Override
        State jobUnpinned() {
            Source.this.pinnedJobCount = Source.this.pinnedJobCount - 1;
            State state = Source.this.pinnedJobCount == 0 ? this.onNoPinnedJobs() : Source.this.getState();
            return state;
        }

        @Override
        State jobActivated() {
            Source.this.activeJobCount = Source.this.activeJobCount + 1;
            return this.onActiveJobs();
        }

        @Override
        State jobInactivated() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        abstract State onNoPinnedJobs();

        abstract State onActiveJobs();
    }

    private abstract class AbstractNoJobsPinnedActions
    extends StateActions {
        private AbstractNoJobsPinnedActions() {
        }

        @Override
        State jobPinned() {
            Source.this.pinnedJobCount = Source.this.pinnedJobCount + 1;
            return this.onPinnedJobs();
        }

        @Override
        State jobUnpinned() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        @Override
        State jobActivated() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        @Override
        State jobInactivated() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        abstract State onPinnedJobs();
    }

    private abstract class StateActions {
        private StateActions() {
        }

        abstract State jobPinned();

        abstract State jobUnpinned();

        abstract State jobActivated();

        abstract State jobInactivated();

        State queueJob(Job job) {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State cancelQueueJob(Job job) {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State jobRunCompleted(DXException dXException) {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State connectTimerExpired() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State connectCompleted(DXException dXException) {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State checkCompleted(DXException dXException) {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State disconnectCompleted() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State removeSource() {
            logger.log(Level.SEVERE, "unexpected state machine event whilst in state ''{0}'' for source ''{1}''", new Object[]{Source.this.getState(), Source.this.sourceId});
            return Source.this.getState();
        }

        State remove() {
            for (Job job : Source.this.jobMap().values()) {
                Source.this.engine.addEvent(job.createRemoveJob());
            }
            Source.this.engine.addEvent(Source.this.createRemoveSource());
            return State.NO_JOBS_PINNED;
        }

        void submitConnectTask() {
            Source.this.engine.submitTask(new Task(){

                @Override
                void execute() {
                    StateActions.this.callConnect();
                }

                @Override
                boolean cancel() {
                    Source.this.taskCancelled = Source.this.cancelConnect();
                    return Source.this.taskCancelled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_CONNECTING_SOURCE", Source.this.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "connect";
                }
            });
        }

        void submitCheckTask() {
            Source.this.engine.submitTask(new Task(){

                @Override
                void execute() {
                    StateActions.this.callCheck();
                }

                @Override
                boolean cancel() {
                    Source.this.taskCancelled = Source.this.cancelCheck();
                    return Source.this.taskCancelled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_CHECKING_SOURCE", Source.this.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "check";
                }
            });
        }

        void submitDisconnectTask() {
            Source.this.engine.submitTask(new Task(){

                @Override
                void execute() {
                    StateActions.this.callDisconnect();
                }

                @Override
                boolean cancel() {
                    Source.this.taskCancelled = Source.this.cancelDisconnect();
                    return Source.this.taskCancelled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_DISCONNECTING_SOURCE", Source.this.getConnectionDisplayName());
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "disconnect";
                }
            });
        }

        void callConnect() {
            assert (!Engine.isMetricsThread());
            DXException dXException = null;
            try {
                Source.this.connect(Source.this.connectionCount);
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final DXException dXException3 = dXException;
            Source.this.engine.enqueueCommand(new Command(){

                @Override
                void execute() {
                    Source.this.engine.addEvent(Source.this.createConnectCompleted(dXException3));
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "connectCompleted";
                }
            });
        }

        void callCheck() {
            assert (!Engine.isMetricsThread());
            DXException dXException = null;
            try {
                Source.this.check();
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final DXException dXException3 = dXException;
            Source.this.engine.enqueueCommand(new Command(){

                @Override
                void execute() {
                    Source.this.engine.addEvent(Source.this.createCheckCompleted(dXException3));
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "checkCompleted";
                }
            });
        }

        void callDisconnect() {
            assert (!Engine.isMetricsThread());
            DXException dXException = null;
            try {
                Source.this.disconnect();
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            if (dXException != null) {
                logger.log(Level.WARNING, "Error attempting to close metrics source connection", dXException);
            }
            Source.this.engine.enqueueCommand(new Command(){

                @Override
                void execute() {
                    Source.this.engine.addEvent(Source.this.createDisconnectCompleted());
                }

                @Override
                URI getId() {
                    return Source.this.sourceId;
                }

                @Override
                String getName() {
                    return "disconnectCompleted";
                }
            });
        }

        void notifyConnect() {
            Source.this.engine.addNotification(new EngineNotification<DXSourceUpdate>(Source.this.engine){

                @Override
                DXSourceUpdate createEvent() {
                    return this.createSourceUpdateEvent(DXEvent.Type.SOURCE_CONNECT, Source.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXSourceUpdate dXSourceUpdate) {
                    dXEngineListener.onConnect(dXSourceUpdate);
                }
            });
        }

        void notifyDisconnect(final DXException dXException) {
            Source.this.engine.addNotification(new EngineNotification<DXSourceUpdate>(Source.this.engine){

                @Override
                DXSourceUpdate createEvent() {
                    return this.createSourceUpdateEvent(DXEvent.Type.SOURCE_DISCONNECT, Source.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXSourceUpdate dXSourceUpdate) {
                    dXEngineListener.onDisconnect(dXSourceUpdate, dXException);
                }
            });
        }

        void notifyRemove() {
            Source.this.engine.addNotification(new EngineNotification<DXSourceUpdate>(Source.this.engine){

                @Override
                DXSourceUpdate createEvent() {
                    return this.createSourceUpdateEvent(DXEvent.Type.SOURCE_REMOVE, Source.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXSourceUpdate dXSourceUpdate) {
                    dXEngineListener.onRemove(dXSourceUpdate);
                }
            });
        }
    }

    private abstract class SourceInputEvent
    extends InputEventImplementation<State, StateActions> {
        private SourceInputEvent() {
        }

        @Override
        void dispatch() {
            Source.this.stateMachine.dispatch(this);
        }
    }

    static enum State {
        NO_JOBS_PINNED,
        JOBS_PINNED,
        CONNECTED,
        UNCONNECTED,
        JOB_RUNNING,
        JOB_RUNNING_NO_JOBS_ACTIVE,
        JOB_RUNNING_NO_JOBS_PINNED,
        CONNECTING,
        CONNECTING_NO_JOBS_ACTIVE,
        CONNECTING_NO_JOBS_PINNED,
        CHECKING,
        CHECKING_NO_JOBS_ACTIVE,
        CHECKING_NO_JOBS_PINNED,
        DISCONNECTING,
        DISCONNECTING_NO_JOBS_ACTIVE,
        DISCONNECTING_NO_JOBS_PINNED,
        REMOVED;


        boolean connected() {
            boolean bl = false;
            switch (this) {
                case CONNECTED: 
                case JOB_RUNNING: 
                case JOB_RUNNING_NO_JOBS_ACTIVE: 
                case JOB_RUNNING_NO_JOBS_PINNED: 
                case CHECKING: 
                case CHECKING_NO_JOBS_ACTIVE: 
                case CHECKING_NO_JOBS_PINNED: {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

