/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.LoaderHelper;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.xml.parser.v2.XMLElement;

class MetricsLoader {
    static List<SourceType> loadXML(MetaURLReference metaURLReference) {
        MetricsLoader metricsLoader = new MetricsLoader();
        return metricsLoader.load(metaURLReference);
    }

    private MetricsLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SourceType> load(MetaURLReference metaURLReference) {
        List<SourceType> list = null;
        try {
            InputStream inputStream = metaURLReference.openInputStream();
            try {
                list = this.load(metaURLReference.getURL().toString(), inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new DXException(iOException);
                }
            }
        }
        catch (IOException | DXException exception) {
            throw new DXException(exception);
        }
        return list;
    }

    private List<SourceType> load(String string, InputStream inputStream) {
        ArrayList<SourceType> arrayList = new ArrayList<SourceType>();
        LoaderHelper loaderHelper = new LoaderHelper(string, inputStream);
        XMLElement xMLElement = loaderHelper.load();
        for (XMLElement xMLElement2 : loaderHelper.getChildElements(xMLElement)) {
            if (xMLElement2.getTagName().equals("import")) continue;
            SourceType sourceType = loaderHelper.instantiateTypeObject(SourceType.class, xMLElement2.getTagName());
            sourceType.load(loaderHelper, xMLElement2);
            arrayList.add(sourceType);
        }
        return arrayList;
    }
}

