/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXCancelled;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.InputEventImplementation;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.engine.StateMachine;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;

public abstract class Job {
    private Engine engine;
    private URI jobId;
    private int pinnedItemCount;
    private Map<String, Item> itemMap;
    private String jobLabel;
    private Future<?> intervalTimerFuture;
    private volatile boolean taskCancelled;
    private EnumMap<State, StateActions> stateActionsMap;
    private final StateMachine<State, StateActions> stateMachine;
    private boolean runAtLeastOnce;
    private long minimumInterval;
    protected static final Logger logger = Logger.getLogger(Job.class.getName());

    protected Job(JobType jobType, Source source) {
        this.jobId = DXIds.newId(source.getSourceId(), jobType.getJobPath());
        this.jobLabel = source.getConnectionDisplayName() + "/" + jobType.getJobPath();
        this.minimumInterval = jobType.getMinimumInterval(this);
        this.itemMap = new HashMap<String, Item>();
        for (ItemType itemType : jobType.itemTypeMap().values()) {
            this.itemMap.put(itemType.getItemPath(), itemType.createItem(this));
        }
        this.stateActionsMap = new EnumMap(State.class);
        this.stateActionsMap.put(State.UNPINNED, new UnpinnedActions());
        this.stateActionsMap.put(State.PINNED, new PinnedActions());
        this.stateActionsMap.put(State.UNPINNED_DISABLED, new UnpinnedDisabledActions());
        this.stateActionsMap.put(State.PINNED_DISABLED, new PinnedDisabledActions());
        this.stateActionsMap.put(State.QUEUED, new QueuedActions());
        this.stateActionsMap.put(State.RUNNING_UNPINNED, new RunningUnpinnedActions());
        this.stateActionsMap.put(State.RUNNING_PINNED, new RunningPinnedActions());
        this.stateActionsMap.put(State.RUNNING_UNPINNED_DISABLED, new RunningUnpinnedDisabledActions());
        this.stateActionsMap.put(State.RUNNING_PINNED_DISABLED, new RunningPinnedDisabledActions());
        this.stateActionsMap.put(State.REMOVED, new RemovedActions());
        this.stateMachine = new StateMachine<State, StateActions>(this.stateActionsMap, jobType.isDisabled(this) ? State.UNPINNED_DISABLED : State.UNPINNED){

            @Override
            URI getId() {
                return Job.this.jobId;
            }

            @Override
            Engine getEngine() {
                return Job.this.engine;
            }
        };
    }

    public abstract JobType getJobType();

    public URI getJobId() {
        return this.jobId;
    }

    public abstract Source getSource();

    protected Map<String, Item> itemMap() {
        assert (Engine.isMetricsThread());
        return this.itemMap;
    }

    void attach(Engine engine) {
        assert (Engine.isMetricsThread());
        this.engine = engine;
    }

    Engine getEngine() {
        return this.engine;
    }

    State getState() {
        return this.stateMachine.getState();
    }

    boolean hasRunAtLeastOnce() {
        return this.runAtLeastOnce;
    }

    long getMinimumInterval() {
        return this.minimumInterval;
    }

    void setMinimumInterval(long l) {
        this.minimumInterval = l;
    }

    protected abstract Map<String, List<?>> load();

    protected abstract boolean cancelLoad();

    protected boolean isTaskCancelled() {
        return this.taskCancelled;
    }

    InputEvent createItemPinned() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.itemPinned();
            }

            @Override
            String getName() {
                return "itemPinned";
            }
        };
    }

    InputEvent createItemUnpinned() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.itemUnpinned();
            }

            @Override
            String getName() {
                return "itemUnpinned";
            }
        };
    }

    InputEvent createEnable() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.enable();
            }

            @Override
            String getName() {
                return "enable";
            }
        };
    }

    InputEvent createDisable() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.disable();
            }

            @Override
            String getName() {
                return "disable";
            }
        };
    }

    InputEvent createIntervalTimerExpired() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.intervalTimerExpired();
            }

            @Override
            String getName() {
                return "intervalTimerExpired";
            }
        };
    }

    InputEvent createStartRun() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.startRun();
            }

            @Override
            String getName() {
                return "startRun";
            }
        };
    }

    InputEvent createRunCompleted(final Map<String, List<?>> map, final long l, final long l2, final DXException dXException) {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.runCompleted(map, l, l2, dXException);
            }

            @Override
            String getName() {
                return "runCompleted";
            }
        };
    }

    InputEvent createRemoveJob() {
        return new JobInputEvent(){

            @Override
            State callResponse(StateActions stateActions) {
                return stateActions.removeJob();
            }

            @Override
            String getName() {
                return "removeJob";
            }
        };
    }

    private class RemovedActions
    extends StateActions {
        private RemovedActions() {
        }

        @Override
        State itemPinned() {
            return State.REMOVED;
        }

        @Override
        State itemUnpinned() {
            return State.REMOVED;
        }

        @Override
        State enable() {
            return State.REMOVED;
        }

        @Override
        State disable() {
            return State.REMOVED;
        }

        @Override
        State intervalTimerExpired() {
            return State.REMOVED;
        }

        @Override
        State startRun() {
            return State.REMOVED;
        }

        @Override
        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            return State.REMOVED;
        }

        @Override
        State removeJob() {
            return State.REMOVED;
        }
    }

    private class RunningPinnedDisabledActions
    extends AbstractPinnedActions {
        private RunningPinnedDisabledActions() {
        }

        @Override
        State enable() {
            Job.this.engine.addEvent(Job.this.getSource().createJobActivated());
            this.notifyEnable();
            return State.RUNNING_PINNED;
        }

        @Override
        State onJobUnpinned() {
            Job.this.engine.addEvent(Job.this.getSource().createJobUnpinned());
            this.notifyUnpin();
            return State.RUNNING_UNPINNED_DISABLED;
        }

        @Override
        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            this.updateFollowingLoad(map, l, l2, dXException);
            return State.PINNED_DISABLED;
        }
    }

    private class RunningUnpinnedDisabledActions
    extends AbstractUnpinnedActions {
        private RunningUnpinnedDisabledActions() {
        }

        @Override
        State enable() {
            this.notifyEnable();
            return State.RUNNING_UNPINNED;
        }

        @Override
        State onJobPinned() {
            Job.this.engine.addEvent(Job.this.getSource().createJobPinned());
            this.notifyPin();
            return State.RUNNING_PINNED_DISABLED;
        }

        @Override
        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            this.updateFollowingLoad(map, l, l2, dXException);
            return State.UNPINNED_DISABLED;
        }
    }

    private class RunningPinnedActions
    extends AbstractPinnedActions {
        private RunningPinnedActions() {
        }

        @Override
        State disable() {
            Job.this.engine.addEvent(Job.this.getSource().createJobInactivated());
            this.notifyDisable();
            return State.RUNNING_PINNED_DISABLED;
        }

        @Override
        State onJobUnpinned() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createJobInactivated());
            Job.this.engine.addEvent(source.createJobUnpinned());
            this.notifyUnpin();
            return State.RUNNING_UNPINNED;
        }

        @Override
        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            this.updateFollowingLoad(map, l, l2, dXException);
            Job.this.intervalTimerFuture = Job.this.engine.scheduleCommand(Job.this.minimumInterval, new Command(){

                @Override
                void execute() {
                    Job.this.engine.addEvent(Job.this.createIntervalTimerExpired());
                }

                @Override
                URI getId() {
                    return Job.this.jobId;
                }

                @Override
                String getName() {
                    return "intervalTimerExpired";
                }
            });
            return State.PINNED;
        }
    }

    private class RunningUnpinnedActions
    extends AbstractUnpinnedActions {
        private RunningUnpinnedActions() {
        }

        @Override
        State disable() {
            this.notifyDisable();
            return State.RUNNING_UNPINNED_DISABLED;
        }

        @Override
        State onJobPinned() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createJobPinned());
            Job.this.engine.addEvent(source.createJobActivated());
            this.notifyPin();
            return State.RUNNING_PINNED;
        }

        @Override
        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            this.updateFollowingLoad(map, l, l2, dXException);
            return State.UNPINNED;
        }
    }

    private class QueuedActions
    extends AbstractPinnedActions {
        private QueuedActions() {
        }

        @Override
        State disable() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createCancelQueueJob(Job.this));
            Job.this.engine.addEvent(source.createJobInactivated());
            this.notifyDisable();
            return State.PINNED_DISABLED;
        }

        @Override
        State onJobUnpinned() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createCancelQueueJob(Job.this));
            Job.this.engine.addEvent(source.createJobInactivated());
            Job.this.engine.addEvent(source.createJobUnpinned());
            this.notifyUnpin();
            return State.UNPINNED;
        }

        @Override
        State startRun() {
            logger.log(Level.INFO, "job run submit ''{0}''", new Object[]{Job.this.jobId});
            this.notifyRunStart();
            this.submitTask();
            return State.RUNNING_PINNED;
        }

        private void submitTask() {
            Job.this.engine.submitTask(new Task(){

                @Override
                void execute() {
                    QueuedActions.this.callLoad();
                }

                @Override
                boolean cancel() {
                    Job.this.taskCancelled = Job.this.cancelLoad();
                    return Job.this.taskCancelled;
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_RUNNING_JOB", Job.this.jobLabel);
                }

                @Override
                URI getId() {
                    return Job.this.jobId;
                }

                @Override
                String getName() {
                    return "load";
                }
            });
        }

        private void callLoad() {
            assert (!Engine.isMetricsThread());
            Map<String, List<?>> map = null;
            DXException dXException = null;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            long l = threadMXBean.getCurrentThreadCpuTime();
            long l2 = System.nanoTime();
            try {
                map = Job.this.load();
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final Map<String, List<?>> map2 = map;
            final long l3 = System.nanoTime() - l2;
            final long l4 = l >= 0L ? threadMXBean.getCurrentThreadCpuTime() - l : -1L;
            final DXException dXException3 = dXException;
            Job.this.engine.enqueueCommand(new Command(){

                @Override
                void execute() {
                    Job.this.engine.addEvent(Job.this.createRunCompleted(map2, l3, l4, dXException3));
                }

                @Override
                URI getId() {
                    return Job.this.jobId;
                }

                @Override
                String getName() {
                    return "runCompleted";
                }
            });
        }
    }

    private class PinnedDisabledActions
    extends AbstractPinnedActions {
        private PinnedDisabledActions() {
        }

        @Override
        State enable() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createJobActivated());
            Job.this.engine.addEvent(source.createQueueJob(Job.this));
            this.notifyEnable();
            return State.QUEUED;
        }

        @Override
        State onJobUnpinned() {
            Job.this.engine.addEvent(Job.this.getSource().createJobUnpinned());
            this.notifyUnpin();
            return State.UNPINNED_DISABLED;
        }
    }

    private class UnpinnedDisabledActions
    extends AbstractUnpinnedActions {
        private UnpinnedDisabledActions() {
        }

        @Override
        State enable() {
            this.notifyEnable();
            return State.UNPINNED;
        }

        @Override
        State onJobPinned() {
            Job.this.engine.addEvent(Job.this.getSource().createJobPinned());
            this.notifyPin();
            return State.PINNED_DISABLED;
        }

        @Override
        State removeJob() {
            return State.REMOVED;
        }
    }

    private class PinnedActions
    extends AbstractPinnedActions {
        private PinnedActions() {
        }

        @Override
        State disable() {
            this.cancelIntervalTimer();
            Job.this.engine.addEvent(Job.this.getSource().createJobInactivated());
            this.notifyDisable();
            return State.PINNED_DISABLED;
        }

        @Override
        State onJobUnpinned() {
            this.cancelIntervalTimer();
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createJobInactivated());
            Job.this.engine.addEvent(source.createJobUnpinned());
            this.notifyUnpin();
            return State.UNPINNED;
        }

        @Override
        State intervalTimerExpired() {
            Job.this.engine.addEvent(Job.this.getSource().createQueueJob(Job.this));
            return State.QUEUED;
        }

        private void cancelIntervalTimer() {
            Job.this.intervalTimerFuture.cancel(false);
            Job.this.intervalTimerFuture = null;
        }
    }

    private class UnpinnedActions
    extends AbstractUnpinnedActions {
        private UnpinnedActions() {
        }

        @Override
        State disable() {
            this.notifyDisable();
            return State.UNPINNED_DISABLED;
        }

        @Override
        State onJobPinned() {
            Source source = Job.this.getSource();
            Job.this.engine.addEvent(source.createJobPinned());
            Job.this.engine.addEvent(source.createJobActivated());
            Job.this.engine.addEvent(source.createQueueJob(Job.this));
            this.notifyPin();
            return State.QUEUED;
        }

        @Override
        State removeJob() {
            return State.REMOVED;
        }
    }

    private abstract class AbstractUnpinnedActions
    extends StateActions {
        private AbstractUnpinnedActions() {
        }

        @Override
        State itemPinned() {
            Job.this.pinnedItemCount = Job.this.pinnedItemCount + 1;
            return this.onJobPinned();
        }

        @Override
        State itemUnpinned() {
            logger.log(Level.SEVERE, "unexpected state machine event ''{0}''", Job.this.jobId);
            return Job.this.getState();
        }

        abstract State onJobPinned();
    }

    private abstract class AbstractPinnedActions
    extends StateActions {
        private AbstractPinnedActions() {
        }

        @Override
        State itemPinned() {
            Job.this.pinnedItemCount = Job.this.pinnedItemCount + 1;
            return Job.this.getState();
        }

        @Override
        State itemUnpinned() {
            Job.this.pinnedItemCount = Job.this.pinnedItemCount - 1;
            State state = Job.this.pinnedItemCount == 0 ? this.onJobUnpinned() : Job.this.getState();
            return state;
        }

        abstract State onJobUnpinned();
    }

    private abstract class StateActions {
        private StateActions() {
        }

        abstract State itemPinned();

        abstract State itemUnpinned();

        State enable() {
            return Job.this.getState();
        }

        State disable() {
            return Job.this.getState();
        }

        State intervalTimerExpired() {
            logger.log(Level.SEVERE, "unexpected state machine event ''{0}''", Job.this.jobId);
            return Job.this.getState();
        }

        State startRun() {
            logger.log(Level.SEVERE, "unexpected state machine event ''{0}''", Job.this.jobId);
            return Job.this.getState();
        }

        State runCompleted(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            logger.log(Level.SEVERE, "unexpected state machine event ''{0}''", Job.this.jobId);
            return Job.this.getState();
        }

        State removeJob() {
            logger.log(Level.SEVERE, "unexpected state machine event ''{0}''", Job.this.jobId);
            return Job.this.getState();
        }

        void updateItems(Map<String, List<?>> map) {
            assert (Engine.isMetricsThread());
            for (Item item : Job.this.itemMap.values()) {
                try {
                    item.update(map);
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
                }
            }
            Job.this.engine.addNotification(new Notification(){

                @Override
                void execute() {
                    for (Item item : Job.this.itemMap.values()) {
                        item.notifyChange();
                    }
                }
            });
            Job.this.runAtLeastOnce = true;
        }

        void updateFollowingLoad(Map<String, List<?>> map, long l, long l2, DXException dXException) {
            Job.this.engine.addEvent(Job.this.getSource().createJobRunCompleted(dXException));
            if (map != null && dXException == null) {
                logger.log(Level.INFO, "job run complete ''{0}'' in {1} seconds", new Object[]{Job.this.jobId, (double)l / 1.0E9});
                this.notifyRunFinish(l, l2, null);
                this.updateItems(map);
            } else if (dXException != null) {
                logger.log(Level.WARNING, "job run failure for '" + Job.this.jobId + "'", dXException);
                this.notifyRunFinish(l, l2, dXException);
            } else {
                logger.log(Level.WARNING, "job run cancelled for ''{0}''", Job.this.jobId);
                this.notifyRunFinish(l, l2, new DXCancelled());
                Job.this.engine.enqueueCommand(Job.this.engine.createJobDisableCommand(Job.this.jobId, false, null));
            }
        }

        void notifyPin() {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_PIN, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onPin(dXJobUpdate);
                }
            });
        }

        void notifyUnpin() {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_UNPIN, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onUnpin(dXJobUpdate);
                }
            });
        }

        void notifyEnable() {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_ENABLE, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onEnable(dXJobUpdate);
                }
            });
        }

        void notifyDisable() {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_DISABLE, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onDisable(dXJobUpdate);
                }
            });
        }

        void notifyRunStart() {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_RUN_START, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onRunStart(dXJobUpdate);
                }
            });
        }

        void notifyRunFinish(final long l, final long l2, final DXException dXException) {
            Job.this.engine.addNotification(new EngineNotification<DXJobUpdate>(Job.this.engine){

                @Override
                DXJobUpdate createEvent() {
                    return this.createJobUpdateEvent(DXEvent.Type.JOB_RUN_FINISH, Job.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                    dXEngineListener.onRunFinish(dXJobUpdate, l, l2, dXException);
                }
            });
        }
    }

    private abstract class JobInputEvent
    extends InputEventImplementation<State, StateActions> {
        private JobInputEvent() {
        }

        @Override
        void dispatch() {
            Job.this.stateMachine.dispatch(this);
        }
    }

    static enum State {
        UNPINNED,
        PINNED,
        UNPINNED_DISABLED,
        PINNED_DISABLED,
        QUEUED,
        RUNNING_UNPINNED,
        RUNNING_PINNED,
        RUNNING_UNPINNED_DISABLED,
        RUNNING_PINNED_DISABLED,
        REMOVED;


        boolean disabled() {
            boolean bl = true;
            switch (this) {
                case UNPINNED: 
                case PINNED: 
                case QUEUED: 
                case RUNNING_UNPINNED: 
                case RUNNING_PINNED: {
                    bl = false;
                }
            }
            return bl;
        }

        boolean pinned() {
            boolean bl = false;
            switch (this) {
                case PINNED: 
                case QUEUED: 
                case RUNNING_PINNED: 
                case PINNED_DISABLED: 
                case RUNNING_PINNED_DISABLED: {
                    bl = true;
                }
            }
            return bl;
        }

        boolean running() {
            boolean bl = false;
            switch (this) {
                case RUNNING_UNPINNED: 
                case RUNNING_PINNED: 
                case RUNNING_PINNED_DISABLED: 
                case RUNNING_UNPINNED_DISABLED: {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

