/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.ListenerEntry;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.PropertyService;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.engine.Worker;
import oracle.dbtools.raptor.metrics.engine.WorkerService;
import oracle.dbtools.raptor.metrics.listener.DXChangeEvent;
import oracle.dbtools.raptor.metrics.listener.DXEngineBind;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXItemBind;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeMerge;
import oracle.dbtools.raptor.metrics.listener.DXUnbind;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

class Engine {
    private static final Engine theInstance;
    private final Map<URI, String> sourcePathMap;
    private final Map<URI, SourceType> sourceTypeMap;
    private final Map<URI, Source> sourceMap;
    private final Map<URI, Source> removedSourceMap;
    private final Set<DXEngineListener> engineListeners;
    private final ScheduledExecutorService executorService;
    private final List<InputEvent> events;
    private final List<Notification> notifications;
    private WorkerService workerService;
    private PropertyService propertyService;
    private static final Logger traceLogger;
    static final Logger logger;
    private static volatile Thread metricsThread;

    static Engine getInstance() {
        return theInstance;
    }

    private Engine() {
        logger.log(Level.INFO, "metrics engine started");
        this.sourcePathMap = new HashMap<URI, String>();
        this.sourceTypeMap = new HashMap<URI, SourceType>();
        this.sourceMap = new HashMap<URI, Source>();
        this.removedSourceMap = new HashMap<URI, Source>();
        this.engineListeners = new HashSet<DXEngineListener>();
        this.executorService = Executors.newSingleThreadScheduledExecutor(this.createThreadFactory());
        this.events = new ArrayList<InputEvent>();
        this.notifications = new ArrayList<Notification>();
    }

    Map<URI, SourceType> sourceTypeMap() {
        return this.sourceTypeMap;
    }

    Map<URI, Source> sourceMap() {
        assert (Engine.isMetricsThread());
        return this.sourceMap;
    }

    Set<DXEngineListener> engineListeners() {
        assert (Engine.isMetricsThread());
        return this.engineListeners;
    }

    PropertyService getPropertyService() {
        assert (Engine.isMetricsThread());
        if (this.propertyService == null) {
            this.propertyService = new EnginePropertyService();
        }
        return this.propertyService;
    }

    ListenerEntry createItemListenerEntry(final URI uRI, final Class<?> clazz, final DXItemListener<?> dXItemListener) {
        return new ListenerEntry(){

            @Override
            void addListener() {
                Engine.this.addItemListener(uRI, clazz, dXItemListener);
            }

            @Override
            void removeListener() {
                Engine.this.removeItemListener(uRI, dXItemListener);
            }
        };
    }

    ListenerEntry createEngineListenerEntry(final DXEngineListener dXEngineListener) {
        return new ListenerEntry(){

            @Override
            void addListener() {
                Engine.this.addEngineListener(dXEngineListener);
            }

            @Override
            void removeListener() {
                Engine.this.removeEngineListener(dXEngineListener);
            }
        };
    }

    Command createRegisterListenersCommand(final List<ListenerEntry> list) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.registerListeners(list);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "registerListeners";
            }
        };
    }

    Command createUnregisterListenersCommand(final List<ListenerEntry> list) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.unregisterListeners(list);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "unregisterListeners";
            }
        };
    }

    Command createMergeSourceTypesCommand(final List<SourceType> list, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.mergeSourceTypes(list);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "mergeSourceTypes";
            }
        };
    }

    Command createJobEnableCommand(final URI uRI, final boolean bl, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.setJobDisabled(uRI, false, bl);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "enableJob";
            }
        };
    }

    Command createJobDisableCommand(final URI uRI, final boolean bl, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.setJobDisabled(uRI, true, bl);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "disableJob";
            }
        };
    }

    Command createSetSourceIntervalCommand(final URI uRI, final long l, final boolean bl, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.setSourceInterval(uRI, l, bl);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "setSourceTypeInterval";
            }
        };
    }

    Command createSetJobIntervalCommand(final URI uRI, final long l, final boolean bl, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.setJobInterval(uRI, l, bl);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "setJobTypeInterval";
            }
        };
    }

    void enqueueCommand(Command command) {
        this.executorService.execute(() -> {
            if (this.isTracingEnabled()) {
                this.traceCommand(command.getId(), command.getName());
            }
            try {
                boolean bl = this.sourceMap.size() > 0;
                command.execute();
                this.callEvents();
                this.removedSourceMap.clear();
                if (bl && this.sourceMap.isEmpty() && this.isTracingEnabled()) {
                    this.traceEngineEvent("onEngineDeactivated");
                }
                this.callNotifications();
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
            }
            catch (Error error) {
                logger.log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                throw error;
            }
        });
    }

    Future<?> scheduleCommand(long l, Command command) {
        assert (Engine.isMetricsThread());
        return this.executorService.schedule(() -> {
            if (this.isTracingEnabled()) {
                this.traceCommand(command.getId(), command.getName());
            }
            try {
                command.execute();
                this.callEvents();
                this.callNotifications();
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
            }
            catch (Error error) {
                logger.log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                throw error;
            }
        }, l, TimeUnit.MILLISECONDS);
    }

    void submitTask(final Task task) {
        assert (Engine.isMetricsThread());
        this.getWorkerService().submit(new Worker(){

            @Override
            public void call() {
                if (Engine.this.isTracingEnabled()) {
                    Engine.this.traceTask(task.getId(), task.getName());
                }
                try {
                    task.execute();
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
                }
                catch (Error error) {
                    logger.log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                    throw error;
                }
            }

            @Override
            public boolean cancelCall() {
                boolean bl = false;
                try {
                    bl = task.cancel();
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
                }
                catch (Error error) {
                    logger.log(Level.SEVERE, error.getStackTrace()[0].toString(), error);
                    throw error;
                }
                return bl;
            }

            @Override
            public String getDisplayName() {
                return task.getLabel();
            }
        });
    }

    void removeSource(Source source) {
        assert (Engine.isMetricsThread());
        URI uRI = source.getSourceId();
        if (this.sourceMap.remove(uRI) != null) {
            this.removedSourceMap.put(uRI, source);
        } else {
            logger.log(Level.WARNING, "Source not known: {0}", uRI);
        }
    }

    void addEvent(InputEvent inputEvent) {
        this.events.add(inputEvent);
    }

    void callEvents() {
        assert (Engine.isMetricsThread());
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.get(i).dispatch();
        }
        this.events.clear();
    }

    void addNotification(Notification notification) {
        assert (Engine.isMetricsThread());
        this.notifications.add(notification);
    }

    private void callNotifications() {
        assert (Engine.isMetricsThread());
        for (Notification notification : this.notifications) {
            notification.execute();
        }
        this.notifications.clear();
    }

    private WorkerService getWorkerService() {
        if (this.workerService == null) {
            this.workerService = new EngineWorkerService();
        }
        return this.workerService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setJobDisabled(URI uRI, boolean bl, boolean bl2) {
        assert (Engine.isMetricsThread());
        JobType jobType = this.getJobType(uRI);
        if (jobType == null) throw new DXException("unable to set disabled state for '" + uRI + "' because job type does not exist");
        if (DXIds.isTypeId(uRI)) {
            jobType.setDefaultDisabled(bl, bl2);
            return;
        } else {
            Job job = this.getJob(uRI);
            if (job == null) throw new DXException("unable to set disabled state for '" + uRI + "' because job does not exist");
            jobType.setDisabled(job, bl, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSourceInterval(URI uRI, long l, boolean bl) {
        assert (Engine.isMetricsThread());
        SourceType sourceType = this.getSourceType(uRI);
        if (sourceType == null) throw new DXException("unable to set source type interval for '" + uRI + "' because source type does not exist");
        if (DXIds.isTypeId(uRI)) {
            sourceType.setDefaultMinimumInterval(l, bl);
            return;
        } else {
            Source source = this.getSource(uRI);
            if (source == null) throw new DXException("unable to set disabled state for '" + sourceType + "' because job does not exist");
            sourceType.setMinimumInterval(source, l, bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setJobInterval(URI uRI, long l, boolean bl) {
        assert (Engine.isMetricsThread());
        JobType jobType = this.getJobType(uRI);
        if (jobType == null) throw new DXException("unable to set disabled state for '" + uRI + "' because job type does not exist");
        if (DXIds.isTypeId(uRI)) {
            jobType.setDefaultMinimumInterval(l, bl);
            return;
        } else {
            Job job = this.getJob(uRI);
            if (job == null) throw new DXException("unable to set disabled state for '" + uRI + "' because job does not exist");
            jobType.setMinimumInterval(job, l, bl);
        }
    }

    private void mergeSourceTypes(List<SourceType> list) {
        for (final SourceType sourceType : list) {
            URI uRI = sourceType.getSourceTypeId();
            SourceType sourceType2 = this.sourceTypeMap.get(uRI);
            HashSet<Object> hashSet = new HashSet<Object>();
            HashSet<URI> hashSet2 = new HashSet<URI>();
            if (sourceType2 == null) {
                this.verifyObjectID(hashSet2, uRI);
                hashSet.add(uRI);
            } else {
                if (sourceType.getClass() != sourceType2.getClass()) {
                    throw new IllegalArgumentException("Merge type conflict: " + uRI);
                }
                hashSet2.add(uRI);
                for (JobType jobType : sourceType2.jobTypeMap().values()) {
                    hashSet2.add(jobType.getJobTypeId());
                    for (ItemType itemType : jobType.itemTypeMap().values()) {
                        hashSet2.add(itemType.getItemTypeId());
                    }
                }
            }
            for (JobType jobType : sourceType.jobTypeMap().values()) {
                jobType.attach(this);
                Object object = jobType.getJobTypeId();
                this.verifyObjectID(hashSet2, (URI)object);
                hashSet.add(object);
                for (ItemType itemType : jobType.itemTypeMap().values()) {
                    URI uRI2 = itemType.getItemTypeId();
                    this.verifyObjectID(hashSet2, uRI2);
                    hashSet.add(uRI2);
                }
            }
            String string = sourceType.getSourcePath();
            for (Object object : hashSet) {
                this.sourcePathMap.put((URI)object, string);
            }
            if (sourceType2 == null) {
                sourceType.attach(this);
                this.sourceTypeMap.put(uRI, sourceType);
                this.addNotification(new EngineNotification<DXSourceTypeAdd>(this){

                    @Override
                    DXSourceTypeAdd createEvent() {
                        return this.createSourceTypeAddEvent(DXEvent.Type.SOURCE_TYPE_ADD, sourceType);
                    }

                    @Override
                    void callListener(DXEngineListener dXEngineListener, DXSourceTypeAdd dXSourceTypeAdd) {
                        dXEngineListener.onAdd(dXSourceTypeAdd);
                    }
                });
                continue;
            }
            sourceType2.mergeJobTypes(sourceType);
            this.addNotification(new EngineNotification<DXSourceTypeMerge>(this){

                @Override
                DXSourceTypeMerge createEvent() {
                    return this.createSourceTypeMergeEvent(DXEvent.Type.SOURCE_TYPE_MERGE, sourceType);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXSourceTypeMerge dXSourceTypeMerge) {
                    dXEngineListener.onMerge(dXSourceTypeMerge);
                }
            });
        }
    }

    private void verifyObjectID(Set<URI> set, URI uRI) {
        String string = DXIds.getPath(uRI);
        if (!string.matches("([A-Za-z][A-Za-z0-9]*)(/[A-Za-z][A-Za-z0-9]*)*")) {
            throw new IllegalArgumentException("Invalid path name '" + string + "': names must match '([A-Za-z][A-Za-z0-9]*)(/[A-Za-z][A-Za-z0-9]*)*'");
        }
        if (!set.add(uRI) || this.sourcePathMap.containsKey(uRI)) {
            throw new IllegalArgumentException("Duplicate ID: " + uRI);
        }
    }

    private void registerListeners(List<ListenerEntry> list) {
        assert (Engine.isMetricsThread());
        for (ListenerEntry listenerEntry : list) {
            listenerEntry.addListener();
        }
    }

    private void unregisterListeners(List<ListenerEntry> list) {
        assert (Engine.isMetricsThread());
        for (ListenerEntry listenerEntry : list) {
            listenerEntry.removeListener();
        }
    }

    private void addItemListener(final URI uRI, Class<?> clazz, final DXItemListener<?> dXItemListener) {
        Object object;
        assert (Engine.isMetricsThread());
        final Item item = this.getItem(uRI, true);
        String string = null;
        if (item == null) {
            string = "item ID not found '" + uRI + "'";
        } else {
            object = item.getItemType();
            if (!clazz.isAssignableFrom(((ItemType)object).getChangeClass())) {
                string = "incorrect change class specified for '" + uRI + "': expected '" + clazz.getName() + "' actual '" + ((ItemType)object).getChangeClass() + "'";
            }
        }
        if (string == null) {
            final boolean bl = item.addItemListener(this, dXItemListener);
            this.addNotification(new Notification(){

                @Override
                void execute() {
                    DXItemBind dXItemBind = new DXItemBind(DXEvent.Type.ITEM_BIND, uRI);
                    dXItemListener.onBind(dXItemBind);
                    if (bl) {
                        DXChangeEvent<Object> dXChangeEvent = new DXChangeEvent<Object>(DXEvent.Type.VALUE_CHANGE, uRI, item.getChangeObject());
                        dXItemListener.onChange(dXChangeEvent);
                    }
                }
            });
        } else {
            object = new DXException(string);
            this.addNotification(new Notification((DXException)object, dXItemListener){
                final /* synthetic */ DXException val$exception;
                final /* synthetic */ DXItemListener val$itemListener;
                {
                    this.val$exception = dXException;
                    this.val$itemListener = dXItemListener;
                }

                @Override
                void execute() {
                    DXError dXError = new DXError(DXEvent.Type.BIND_ERROR, uRI, this.val$exception);
                    this.val$itemListener.onBindError(dXError);
                }
            });
        }
    }

    private void removeItemListener(final URI uRI, final DXItemListener<?> dXItemListener) {
        assert (Engine.isMetricsThread());
        Item item = this.getItem(uRI, false);
        if (item != null) {
            if (item.removeItemListener(this, dXItemListener)) {
                this.addNotification(new Notification(){

                    @Override
                    void execute() {
                        DXUnbind dXUnbind = new DXUnbind(DXEvent.Type.UNBIND, uRI);
                        dXItemListener.onUnbind(dXUnbind);
                    }
                });
            } else {
                logger.log(Level.SEVERE, "Listener cannot be removed because listener has not been added: {0}", uRI);
            }
        } else {
            logger.log(Level.SEVERE, "Listener cannot be removed because item is not known: {0}", uRI);
        }
    }

    private void addEngineListener(final DXEngineListener dXEngineListener) {
        assert (Engine.isMetricsThread());
        this.engineListeners.add(dXEngineListener);
        this.addNotification(new EngineNotification<DXEngineBind>(this){

            @Override
            DXEngineBind createEvent() {
                return this.createEngineBindEvent(DXEvent.Type.ENGINE_BIND, Engine.this);
            }

            @Override
            void callListeners(DXEngineBind dXEngineBind) {
                this.callListener(dXEngineListener, dXEngineBind);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener2, DXEngineBind dXEngineBind) {
                dXEngineListener2.onBind(dXEngineBind);
            }
        });
    }

    private void removeEngineListener(final DXEngineListener dXEngineListener) {
        assert (Engine.isMetricsThread());
        if (this.engineListeners.remove(dXEngineListener)) {
            this.addNotification(new EngineNotification<DXUnbind>(this){

                @Override
                DXUnbind createEvent() {
                    return this.createUnbindEvent(DXEvent.Type.UNBIND);
                }

                @Override
                void callListeners(DXUnbind dXUnbind) {
                    this.callListener(dXEngineListener, dXUnbind);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener2, DXUnbind dXUnbind) {
                    dXEngineListener2.onUnbind(dXUnbind);
                }
            });
        } else {
            logger.log(Level.SEVERE, "Listener cannot be removed because it has not been added: {0}", dXEngineListener);
        }
    }

    private SourceType getSourceType(URI uRI) {
        return this.sourceTypeMap.get(DXIds.getTypeId(uRI));
    }

    private JobType getJobType(URI uRI) {
        URI uRI2 = DXIds.getTypeId(uRI);
        String string = this.sourcePathMap.get(uRI2);
        SourceType sourceType = null;
        if (string != null) {
            sourceType = this.sourceTypeMap.get(DXIds.newTypeId(uRI2, string));
        }
        JobType jobType = null;
        if (sourceType != null) {
            jobType = sourceType.jobTypeMap().get(DXIds.getTypeId(uRI));
        }
        return jobType;
    }

    private Source getSource(URI uRI) {
        assert (Engine.isMetricsThread());
        return this.sourceMap.get(uRI);
    }

    private Job getJob(URI uRI) {
        assert (Engine.isMetricsThread());
        Job job = null;
        Source source = this.getSourceContaining(uRI, false);
        if (source != null) {
            job = source.jobMap().get(DXIds.getPath(uRI));
        }
        return job;
    }

    private Item getItem(URI uRI, boolean bl) {
        assert (Engine.isMetricsThread());
        Item item = null;
        Source source = this.getSourceContaining(uRI, bl);
        if (source != null) {
            item = source.itemMap().get(DXIds.getPath(uRI));
        }
        return item;
    }

    private Source getSourceContaining(URI uRI, boolean bl) {
        SourceType sourceType;
        URI uRI2;
        assert (Engine.isMetricsThread());
        Source source = null;
        String string = this.sourcePathMap.get(DXIds.getTypeId(uRI));
        if (string != null && (source = this.sourceMap.get(uRI2 = DXIds.newId(uRI, string))) == null && bl && (sourceType = this.sourceTypeMap.get(DXIds.newTypeId(uRI2, string))) != null && (source = sourceType.createSource(DXIds.getConnectionName(uRI2))) != null) {
            source.attach(this);
            if (this.sourceMap.isEmpty() && this.isTracingEnabled()) {
                this.traceEngineEvent("onEngineActivated");
            }
            this.sourceMap.put(uRI2, source);
        }
        return source;
    }

    private ThreadFactory createThreadFactory() {
        return runnable -> {
            metricsThread = new Thread(runnable);
            metricsThread.setName("Raptor Metrics Engine Thread");
            metricsThread.setDaemon(true);
            metricsThread.setPriority(5);
            return metricsThread;
        };
    }

    static boolean isMetricsThread() {
        return Thread.currentThread() == metricsThread;
    }

    void setWorkerService(WorkerService workerService) {
        assert (this.workerService == null);
        this.workerService = workerService;
    }

    void setPropertyService(PropertyService propertyService) {
        assert (this.propertyService == null);
        this.propertyService = propertyService;
    }

    boolean isTracingEnabled() {
        return traceLogger.isLoggable(Level.FINEST);
    }

    void traceTask(URI uRI, String string) {
        this.trace(uRI, "TASK", string, null);
    }

    void traceCommand(URI uRI, String string) {
        this.trace(uRI, "COMMAND", string, null);
    }

    void traceEvent(URI uRI, String string, String string2, String string3) {
        this.trace(uRI, "EVENT", string, string2 + " -> " + string3);
    }

    private void traceEngineEvent(String string) {
        this.trace(null, "EVENT", string, null);
    }

    private void trace(URI uRI, String string, String string2, String string3) {
        assert (this.isTracingEnabled());
        StringBuilder stringBuilder = new StringBuilder();
        if (uRI != null) {
            String string4 = DXIds.getConnectionTypeName(uRI);
            String string5 = DXIds.getConnectionName(uRI);
            String string6 = DXIds.getPath(uRI);
            stringBuilder.append(this.sourceMap.get(uRI) == null && this.removedSourceMap.get(uRI) == null ? "Job" : "Source");
            stringBuilder.append("(");
            stringBuilder.append(string4);
            stringBuilder.append(":");
            String string7 = this.sourcePathMap.get(DXIds.getTypeId(uRI));
            URI uRI2 = DXIds.newId(string4, string5, string7);
            Source source = this.sourceMap.get(uRI2);
            if (source == null) {
                source = this.removedSourceMap.get(uRI2);
            }
            if (source != null) {
                String string8 = source.getConnectionDisplayName();
                stringBuilder.append(string8);
            } else {
                stringBuilder.append(string5);
            }
            stringBuilder.append("/");
            stringBuilder.append(string6);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("Engine");
        }
        stringBuilder.append(".");
        stringBuilder.append(string);
        stringBuilder.append("@");
        stringBuilder.append(string2);
        stringBuilder.append("(");
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(")");
        traceLogger.log(Level.FINEST, stringBuilder.toString());
    }

    static {
        traceLogger = Logger.getLogger(Engine.class.getPackage().getName());
        logger = Logger.getLogger(Engine.class.getName());
        theInstance = new Engine();
    }

    private class EngineWorkerService
    extends WorkerService {
        private EngineWorkerService() {
        }

        @Override
        public void submit(final Worker worker) {
            assert (Engine.isMetricsThread());
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(worker.getDisplayName(), false, IRaptorTaskRunMode.TASKVIEWER){

                protected Void doWork() throws TaskException {
                    worker.call();
                    return null;
                }

                public boolean cancel() {
                    return worker.cancelCall();
                }
            };
            raptorTask.setCancellable(true);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    private static class EnginePropertyService
    extends PropertyService {
        private final EnginePropertyStore store = EnginePropertyStore.getInstance();

        EnginePropertyService() {
        }

        @Override
        String getPersistentProperty(String string) {
            return this.store.get(this.flattenKey(string));
        }

        @Override
        void setPersistentProperty(String string, String string2) {
            this.store.set(this.flattenKey(string), string2);
        }

        private String flattenKey(String string) {
            return string.replace('/', '+');
        }
    }

    private static class EnginePropertyStore
    extends HashStructureAdapter {
        private EnginePropertyStore(HashStructure hashStructure) {
            super(hashStructure);
        }

        static EnginePropertyStore getInstance() {
            Preferences preferences = Preferences.getPreferences();
            return new EnginePropertyStore(EnginePropertyStore.findOrCreate((PropertyStorage)preferences, (String)Engine.class.getPackage().getName()));
        }

        String get(String string) {
            return this._hash.getString(string);
        }

        void set(String string, String string2) {
            this._hash.putString(string, string2);
        }
    }

    private abstract class CallbackCommand
    extends Command {
        private final DXOperationCallback callback;

        CallbackCommand(DXOperationCallback dXOperationCallback) {
            this.callback = dXOperationCallback;
        }

        @Override
        void execute() {
            DXException dXException = null;
            try {
                this.executeImpl();
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            if (this.callback != null) {
                final DXError dXError = new DXError(DXEvent.Type.OPERATION_COMPLETE, null, dXException);
                Engine.this.addNotification(new Notification(){

                    @Override
                    void execute() {
                        CallbackCommand.this.callback.onComplete(dXError);
                    }
                });
            }
        }

        abstract void executeImpl();
    }
}

