/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.List;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.MetricsLoader;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.support.MetaURLReference;

public class DXService {
    public static void mergeSourceTypes(MetaURLReference metaURLReference, DXOperationCallback dXOperationCallback) {
        List<SourceType> list = MetricsLoader.loadXML(metaURLReference);
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createMergeSourceTypesCommand(list, dXOperationCallback));
    }

    public static void enableJob(URI uRI, boolean bl, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createJobEnableCommand(uRI, bl, dXOperationCallback));
    }

    public static void disableJob(URI uRI, boolean bl, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createJobDisableCommand(uRI, bl, dXOperationCallback));
    }

    public static void setSourceMinimumInterval(URI uRI, long l, boolean bl, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createSetSourceIntervalCommand(uRI, l, bl, dXOperationCallback));
    }

    public static void setJobTypeIntervalCommand(URI uRI, long l, boolean bl, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createSetJobIntervalCommand(uRI, l, bl, dXOperationCallback));
    }

    public static DXChannel createChannel() {
        return new DXChannel();
    }

    public static void registerChannel(DXChannel dXChannel) {
        dXChannel.register(Engine.getInstance());
    }

    public static void closeChannel(DXChannel dXChannel) {
        dXChannel.close(Engine.getInstance());
    }

    private DXService() {
    }
}

