/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format.ui;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.grid.GridResultSet;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;

public final class GridFormatterWrapper
extends TableFormatterWrapper {
    private GridResultSet m_rs;
    private ResultSetTableModel m_model;
    private ResultSetMetaData m_meta;

    public GridFormatterWrapper(JTable jTable) throws SQLException {
        super(jTable);
        this.m_model = (ResultSetTableModel)((Object)jTable.getModel());
        this.m_rs = this.m_model.getResultSet();
        this.m_meta = this.m_model.getResultSetMetaData();
    }

    @Override
    public int print() throws IOException {
        int n = 0;
        try {
            n = this.print(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int print(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws IOException, ExecutionException {
        int n = 0;
        this.m_formatter.start();
        try {
            while (this.m_rs != null && this.m_rs.next()) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                } else if (this.isInterrupted()) break;
                this.m_formatter.startRow();
                for (int i = 0; i < this.m_meta.getColumnCount(); ++i) {
                    this.m_formatter.printColumn(this.m_rs.getObject(i + 1), i, i);
                }
                this.m_formatter.endRow();
                n = this.m_rs.getRow();
            }
        }
        catch (ExecutionException executionException) {
            try {
                if (this.m_rs == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.m_formatter.end();
        return n;
    }

    public void close() {
        if (this.m_rs != null) {
            try {
                this.m_rs.done();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

