/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccess;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;

public class ExtractConnectionAccessCatalog {
    ArrayList<ExtractConnectionAccess> _connAccessCatalog = new ArrayList();

    public ExtractConnectionAccessCatalog(List<ExtractObject> list) {
        for (ExtractObject extractObject : list) {
            DBObject dBObject = extractObject.getDBObject();
            if (this.contains(dBObject)) continue;
            ExtractConnectionAccess extractConnectionAccess = new ExtractConnectionAccess(dBObject);
            this._connAccessCatalog.add(extractConnectionAccess);
        }
    }

    public Collection<ExtractConnectionAccess> getExtractConnectionAccessCatalog() {
        return this._connAccessCatalog;
    }

    public List<Connection> getConnections() {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (ExtractConnectionAccess extractConnectionAccess : this._connAccessCatalog) {
            if (arrayList.contains(extractConnectionAccess.getConnection())) continue;
            arrayList.add(extractConnectionAccess.getConnection());
        }
        return arrayList;
    }

    public int size() {
        return this._connAccessCatalog.size();
    }

    public boolean contains(DBObject dBObject) {
        for (ExtractConnectionAccess extractConnectionAccess : this._connAccessCatalog) {
            if (!extractConnectionAccess.getConnectionName().equals(dBObject.getConnectionName()) || !extractConnectionAccess.getDbName().equals(DBURLFormatHelper.getCatalog(dBObject.getURL())) || !extractConnectionAccess.getSchemaName().equals(dBObject.getSchemaName())) continue;
            return true;
        }
        return false;
    }
}

