/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.sql.Connection;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class ExtractConnectionAccess {
    String _connName = null;
    String _connDisplayName = null;
    String _dbName = null;
    String _schemaName = null;
    Connection _conn = null;

    public ExtractConnectionAccess(DBObject dBObject) {
        this._connName = dBObject.getConnectionName();
        this._connDisplayName = Connections.getDisplayName(this._connName);
        this._dbName = DBURLFormatHelper.getCatalog(dBObject.getURL());
        if (this._dbName == null) {
            this._dbName = "";
        }
        this._schemaName = dBObject.getSchemaName();
        this._conn = dBObject.getConnection();
    }

    public String getConnectionName() {
        return this._connName;
    }

    public String getConnectionDisplayName() {
        return this._connDisplayName;
    }

    public String getDbName() {
        return this._dbName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getKey() {
        return this._connName + (this._dbName.isEmpty() ? "" : "_") + this._dbName + "_" + this._schemaName;
    }

    public String toString() {
        return this._connName;
    }
}

