/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.data;

import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.IdeUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.xdb.XMLType;

public class DataMover
extends CommandListener {
    private Connection _fromConn;
    private Connection _toConn;
    private String _toSchema;
    private OutputStreamWriter _out;
    private boolean m_ignoreAllDataErrors = false;
    private String _EOL = null;
    private boolean m_isBlobColumnExists = false;

    public DataMover() {
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public DataMover(String string, String string2, List<DBObject> list) throws ConnectionException {
        this._fromConn = Connections.getInstance().getUniqueConnection(string);
        this._toConn = Connections.getInstance().getUniqueConnection(string2);
    }

    public DataMover(Connection connection, Connection connection2, ArrayList<DBObject> arrayList) throws ConnectionException {
        this._fromConn = Connections.getInstance().cloneConnection(connection);
        this._toConn = Connections.getInstance().cloneConnection(connection2);
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
    }

    public DataMover(Connection connection, Connection connection2) {
        this(connection, connection2, false);
    }

    public DataMover(Connection connection, Connection connection2, boolean bl) {
        this._fromConn = connection;
        this._toConn = connection2;
        this.m_ignoreAllDataErrors = bl;
    }

    private synchronized void feedback(String string) {
        String string2 = IdeUtil.getIdeEncoding();
        if (string == null) {
            return;
        }
        if (this._out != null) {
            try {
                this._out.write(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLogFile(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    public void close() {
        try {
            if (!this._fromConn.isClosed()) {
                this._fromConn.close();
            }
            if (!this._toConn.isClosed()) {
                this._toConn.close();
            }
        }
        catch (SQLException sQLException) {
            this.feedback(sQLException.getMessage() + this.getTerm());
        }
    }

    public void setToSchema(String string) {
        this._toSchema = string;
    }

    public void move(DBObject dBObject, boolean bl) {
        String string = "";
        int n = 0;
        this.move(dBObject, string, n, bl);
    }

    public boolean move(DBObject dBObject, String string, boolean bl) {
        int n = 0;
        return this.move(dBObject, string, n, bl);
    }

    public boolean move(DBObject dBObject, String string, int n, boolean bl) {
        return this.move(dBObject, "*", string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(DBObject dBObject, String string, String string2, int n, boolean bl) {
        String string3 = null;
        String string4 = null;
        long l = System.currentTimeMillis();
        switch (n) {
            case 0: {
                string3 = "select " + string + " from " + DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string2;
                string4 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                break;
            }
            case 1: {
                String string5 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string3 = "select " + string + " from " + string5 + " " + string2;
                string4 = "insert into " + string5;
                break;
            }
            case 2: {
                String string5 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string3 = "select " + string + " from " + string5 + " " + string2;
                string4 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                break;
            }
            case 3: {
                String string5 = this._toSchema != null ? DBUtil.addDoubleQuote((String)this._toSchema) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) : DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string3 = "select " + string + " from " + DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string2;
                string4 = "insert into " + string5;
            }
        }
        ResultSet resultSet = null;
        OracleCallableStatement oracleCallableStatement = null;
        PreparedStatement preparedStatement = null;
        int[] nArray = null;
        Integer n2 = 0;
        Integer n3 = 1;
        try {
            long l2;
            block66: {
                Object object;
                preparedStatement = this._fromConn.prepareStatement(string3);
                resultSet = preparedStatement.executeQuery();
                resultSet.setFetchSize(100);
                int n4 = resultSet.getMetaData().getColumnCount();
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                for (int i = 1; i <= n4; ++i) {
                    if (i != 1) {
                        stringBuilder.append(",");
                        stringBuilder2.append(",");
                    }
                    stringBuilder.append(DBUtil.addDoubleQuote((String)resultSet.getMetaData().getColumnName(i)));
                    stringBuilder2.append(":");
                    stringBuilder2.append(Service.cleanScriptFileName((String)resultSet.getMetaData().getColumnName(i).replaceAll(" ", "_")));
                }
                string4 = string4 + "(" + stringBuilder.toString() + ")" + " values (" + stringBuilder2.toString() + ")";
                oracleCallableStatement = (OracleCallableStatement)this._toConn.prepareCall(string4);
                l2 = 0L;
                while (resultSet.next()) {
                    block65: {
                        if (Thread.interrupted()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        this.m_isBlobColumnExists = false;
                        block43: for (int i = 1; i <= n4; ++i) {
                            int n5 = resultSet.getMetaData().getColumnType(i);
                            switch (n5) {
                                case 2004: {
                                    this.m_isBlobColumnExists = true;
                                    Blob blob = resultSet.getBlob(i);
                                    if (blob != null) {
                                        oracleCallableStatement.setBlob(i, blob.getBinaryStream());
                                        continue block43;
                                    }
                                    oracleCallableStatement.setBlob(i, blob);
                                    continue block43;
                                }
                                case 2007: {
                                    Clob clob;
                                    if (resultSet.getMetaData().getColumnTypeName(i).compareTo("SYS.XMLTYPE") != 0) continue block43;
                                    BFILE bFILE = ((OracleResultSet)resultSet).getOPAQUE(i);
                                    if (bFILE != null) {
                                        clob = XMLType.createXML((OPAQUE)bFILE);
                                        oracleCallableStatement.setObject(i, (Object)(clob != null ? clob.getStringVal() : null));
                                        continue block43;
                                    }
                                    oracleCallableStatement.setObject(i, (Object)bFILE);
                                    continue block43;
                                }
                                case -13: {
                                    BFILE bFILE = ((OracleResultSet)resultSet).getBFILE(i);
                                    oracleCallableStatement.setBfile(i, bFILE);
                                    continue block43;
                                }
                                case 2005: {
                                    Clob clob = resultSet.getClob(i);
                                    if (clob != null) {
                                        oracleCallableStatement.setClob(i, clob.getCharacterStream());
                                        continue block43;
                                    }
                                    oracleCallableStatement.setClob(i, clob);
                                    continue block43;
                                }
                                case 2011: {
                                    NClob nClob = resultSet.getNClob(i);
                                    if (nClob != null) {
                                        oracleCallableStatement.setNClob(i, nClob.getCharacterStream());
                                        continue block43;
                                    }
                                    oracleCallableStatement.setNClob(i, nClob);
                                    continue block43;
                                }
                                case 91: {
                                    DATE dATE = ((OracleResultSet)resultSet).getDATE(i);
                                    oracleCallableStatement.setDATE(i, dATE);
                                    continue block43;
                                }
                                case 101: {
                                    oracleCallableStatement.setString(i, resultSet.getString(i));
                                    continue block43;
                                }
                                case -1: {
                                    if (!this.m_isBlobColumnExists) {
                                        oracleCallableStatement.setString(i, resultSet.getString(i));
                                        continue block43;
                                    }
                                    oracleCallableStatement.setString(i, null);
                                    continue block43;
                                }
                                case 92: 
                                case 93: {
                                    TIMESTAMP tIMESTAMP = ((OracleResultSet)resultSet).getTIMESTAMP(i);
                                    TIMESTAMP tIMESTAMP2 = tIMESTAMP != null ? new TIMESTAMP(tIMESTAMP.timestampValue()) : null;
                                    oracleCallableStatement.setTIMESTAMP(i, tIMESTAMP2);
                                    continue block43;
                                }
                                default: {
                                    oracleCallableStatement.setObject(i, resultSet.getObject(i));
                                }
                            }
                        }
                        oracleCallableStatement.addBatch();
                        Integer n6 = n2;
                        n2 = n2 + 1;
                        object = n2;
                        if (n2 < 500) continue;
                        try {
                            nArray = oracleCallableStatement.executeBatch();
                            n3 = n3 + 1;
                        }
                        catch (SQLException sQLException) {
                            object = this.getDataErrorObject(dBObject, n3, n2) + "  " + sQLException.getMessage() + this.getTerm();
                            if (bl) {
                                this.feedback((String)object);
                            }
                            if (this.dataCopyExceptionHandling((String)object) != 2) break block65;
                            boolean bl3 = false;
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                if (oracleCallableStatement != null) {
                                    oracleCallableStatement.close();
                                }
                            }
                            catch (Exception exception) {
                                this.feedback(exception.getMessage() + this.getTerm());
                            }
                            return bl3;
                        }
                    }
                    l2 += (long)n2.intValue();
                    n2 = 0;
                }
                if (n2 > 0) {
                    l2 += (long)n2.intValue();
                    try {
                        nArray = oracleCallableStatement.executeBatch();
                    }
                    catch (SQLException sQLException) {
                        l2 -= (long)n2.intValue();
                        object = this.getDataErrorObject(dBObject, n3, n2) + "  " + sQLException.getMessage() + this.getTerm();
                        if (bl) {
                            this.feedback((String)object);
                        }
                        if (this.dataCopyExceptionHandling((String)object) != 2) break block66;
                        boolean bl4 = false;
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (oracleCallableStatement != null) {
                                oracleCallableStatement.close();
                            }
                        }
                        catch (Exception exception) {
                            this.feedback(exception.getMessage() + this.getTerm());
                        }
                        return bl4;
                    }
                }
            }
            if (bl) {
                this.feedback(MessageFormat.format(this.getTerm() + CopyPanelArb.getString("INSERTED_ROWS_INTO") + this.getTerm(), l2, dBObject.getObjectName(), System.currentTimeMillis() - l));
            }
            this._toConn.commit();
            boolean bl5 = true;
            return bl5;
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.feedback(CopyPanelArb.getString(this.getDataErrorObject(dBObject, n3, n2) + "  " + sQLException.getMessage() + this.getTerm()));
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (Exception exception) {
                this.feedback(exception.getMessage() + this.getTerm());
            }
        }
        return true;
    }

    private OraDATEFormat getDateFormat() {
        try {
            return ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._toConn)).getOraDATEFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private String getDataErrorObject(DBObject dBObject, Integer n, Integer n2) {
        return CopyPanelArb.format("DATA_ERROR_OBJECT", dBObject.getObjectType(), dBObject.getObjectName(), n.toString(), n2.toString()) + this.getTerm();
    }

    private int dataCopyExceptionHandling(String string) {
        if (!this.m_ignoreAllDataErrors) {
            DatabaseCopyException databaseCopyException = new DatabaseCopyException();
            int n = 0;
            try {
                n = databaseCopyException.askContinueOnError(string + CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                if (n == 0) {
                    this.m_ignoreAllDataErrors = false;
                } else if (n == 1) {
                    this.m_ignoreAllDataErrors = true;
                } else if (n == 2) {
                    this.m_ignoreAllDataErrors = true;
                }
                return n;
            }
            catch (Throwable throwable) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(OutputStreamWriter outputStreamWriter, Connection connection, Connection connection2, HashMap<String, String> hashMap) throws Exception {
        ResultSet resultSet;
        this._out = outputStreamWriter;
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        DDLFormat dDLFormat2 = new DDLFormat();
        dDLFormat2.setDrop(true);
        dDLFormat2.setSchema(false);
        dDLFormat2.setSegments(false);
        dDLFormat2.setTerminiator(true);
        DDLGenerator.getInstance().setFormating(dDLFormat2);
        StringBuilder stringBuilder = new StringBuilder("select user ,object_name,object_type from user_objects ");
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (hashMap.get("FILTER") != null) {
            if (bl) {
                stringBuilder.append(" and object_name like :FILTER");
            } else {
                stringBuilder.append(" where object_name like :FILTER");
                bl = true;
            }
        }
        if (hashMap.get("TYPES") != null) {
            if (bl) {
                stringBuilder.append(" and instr(:TYPES,upper(object_name)) > 0");
            } else {
                stringBuilder.append(" where instr(:TYPES,upper(object_name)) > 0");
                bl = true;
            }
        }
        if ((resultSet = DBUtil.getInstance((Connection)connection).executeQuery(stringBuilder.toString(), hashMap)) != null) {
            try {
                while (resultSet.next()) {
                    arrayList.add(new DBObject(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(connection), null, resultSet.getString(1), resultSet.getString(3)), resultSet.getString(2))));
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
        DDLGenerator.getInstance().setFormating(dDLFormat);
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (iSQLCommand.getSql().trim().toLowerCase().startsWith("copyschema")) {
                String[] stringArray = iSQLCommand.getSql().split("\\W");
                Connection connection2 = Connections.getInstance().getConnection(stringArray[3]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 3; i < stringArray.length; i += 2) {
                    hashMap.put(stringArray[i].toUpperCase(), stringArray[i + 1]);
                }
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }
}

