/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportGenerationOutputStream;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.PDFFormatter;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.SQLFormatterWrapper;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.ide.Ide;

public class ExportAPI {
    private static final Logger LOGGER = Logger.getLogger(ExportAPI.class.getName());
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private DatabaseQueryTask<Void> _task = null;
    private Connection _conn;
    private String _connName;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private TargetFormat _targetFormat;
    private DDLTypes _ddlType;
    private ExtractListModel _listModel;
    private boolean _cancel;
    private String badSetup;
    ResultsFormatter _formatter = null;
    ResultSet _rs;
    private boolean _isExportOwnedResultSet;
    private boolean _isGridResultSet;
    private boolean _isReconcileTypesAndObjects = true;
    private ExportGenerationOutputStream _genOutputStream;
    private HashMap<String, HashMap<String, String>> nlsHashMap;

    private final String INIT_APEX_SQL() {
        return "declare\nsgid number := 0;\nappid number := wwv_flow_utilities.minimum_free_flow;\nbegin\nfor r in ( select workspace_id,schema from apex_workspace_schemas ) loop\nwwv_flow_application_install.set_workspace_id(r.workspace_id);\nwwv_flow_application_install.set_schema(r.schema);\nwwv_flow_application_install.set_image_prefix( wwv_flow_global.g_image_prefix );\nsgid := r.workspace_id;\nend loop;\nwwv_flow_application_install.set_application_id(appid);\nwwv_flow_api.set_security_group_id( sgid);\nwwv_flow_application_install.set_application_alias(appid);\nwwv_flow_application_install.generate_offset;\nend;\n/\n";
    }

    public void setExtractListModel(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        this.setConnection(this._listModel.getSourceConn());
        this._ddlFormat = this._listModel.getDDLFormat();
        this._dataFormat = this._listModel.getDataFormat();
        this._ddlType = this._listModel.getDDLTypes();
    }

    private void setConnection(Connection connection) {
        this._conn = connection;
        this._connName = Connections.getInstance().getConnectionName(this._conn);
    }

    public void setTargetFormat(TargetFormat targetFormat) {
        this._targetFormat = targetFormat;
    }

    public void setQuickDDL(ExtractListModel extractListModel, int n, String string) {
        try {
            this._listModel = extractListModel;
            DDLFormat dDLFormat = new DDLFormat();
            dDLFormat.isExtractEnabled(true);
            this._listModel.setDDLFormat(dDLFormat);
            DDLTypes dDLTypes = this._listModel.getDDLTypes();
            List<ExtractObject> list = this._listModel.getList(0, new int[]{107});
            dDLTypes.setTypes(list);
            this._listModel.setDDLTypes(dDLTypes);
            this.setExtractListModel(extractListModel);
            extractListModel.clearSelectExtractData();
            TargetFormat targetFormat = new TargetFormat(1, 1);
            targetFormat.isCompressed(false);
            targetFormat.setSaveAsType(n);
            if (n == 4) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_WORKSHEET"));
            } else if (n == 5) {
                targetFormat.setSaveAs(DDLResources.getString("SAVE_AS_CLIPBOARD"));
            } else {
                targetFormat.setSaveAs(string);
            }
            this.setTargetFormat(targetFormat);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void setDeploy(DbCartDeployOptions dbCartDeployOptions) {
        this._listModel = new ExtractListModel();
        this._listModel.setSelectedExtractObjects(dbCartDeployOptions.getSourceExtractObjectList());
        this._listModel.setSchemas();
        this.setExtractListModel(this._listModel);
        this._ddlFormat = dbCartDeployOptions.getDDLFormat();
        this._listModel.setDDLFormat(this._ddlFormat);
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        List<ExtractObject> list = this._listModel.getList(0, new int[]{100, 101});
        List<ExtractObject> list2 = ExtractListModel.getList(list, new int[]{107});
        dDLTypes.setTypes(list2);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        dDLTypes.setConstraint(this._ddlFormat.getConstraint());
        dDLTypes.setRefConstraint(this._ddlFormat.getRefConstraint());
        this._listModel.setDDLTypes(dDLTypes);
        for (ExtractObject extractObject : dbCartDeployOptions.getSourceExtractObjectList()) {
            extractObject.setListModel(this._listModel);
        }
        this._dataFormat = dbCartDeployOptions.getDataFormat();
        this._dataFormat.isExportEnabled(dbCartDeployOptions.isIncludeData());
        this._listModel.setDataFormat(this._dataFormat);
        this.setTargetFormat(dbCartDeployOptions.getTargetFormat());
        this._isReconcileTypesAndObjects = false;
    }

    public static String validateOptions(DDLFormat dDLFormat, ExtractDataFormat extractDataFormat, TargetFormat targetFormat, PDFFormatOptions pDFFormatOptions, Component component) {
        int n;
        int n2 = 0;
        String string = "";
        if ((targetFormat.getSaveAsType() == 0 || targetFormat.getSaveAsType() >= 4) && extractDataFormat.isExportEnabled() && dDLFormat.isExtractEnabled() && !extractDataFormat.isInsert()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat()};
            return ExportWizArb.format("SINGLE_FILE_NOT_SUPPORTED", objectArray);
        }
        if (targetFormat.getSaveAsType() == 0 && extractDataFormat.isExportEnabled() && extractDataFormat.isLoader() && extractDataFormat.isSeparateDataFile()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat(), ExportWizArb.getString("SEPARATE_DATA_FILE")};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT_WITH_OPT", objectArray);
        }
        if (targetFormat.isCompressed() && extractDataFormat.isExportEnabled() && ((ResultsFormatter)FormatRegistry.getFormatter((String)extractDataFormat.getFormat())).isStreamHandler()) {
            Object[] objectArray = new Object[]{ExportWizArb.getString("COMPRESSED"), extractDataFormat.getFormat()};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", objectArray);
        }
        if (targetFormat.getSaveAsType() < 4) {
            n2 = targetFormat.validateSaveAs(component);
            if (n2 == 1) {
                return targetFormat.getValidationMessage();
            }
            if (n2 == 2) {
                return "";
            }
        } else if (extractDataFormat.isExportEnabled() && !extractDataFormat.isTextEditorReadable()) {
            Object[] objectArray = new Object[]{targetFormat.getSaveAsTypeString(), extractDataFormat.getFormat()};
            return ExportWizArb.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", objectArray);
        }
        ResultsFormatter resultsFormatter = (ResultsFormatter)FormatRegistry.getFormatter((String)extractDataFormat.getFormat());
        if (!dDLFormat.isExtractEnabled() && extractDataFormat.isExportEnabled()) {
            targetFormat.setDataFormatExtension(resultsFormatter.getExt());
        }
        if (resultsFormatter instanceof PDFFormatter) {
            if (pDFFormatOptions == null) {
                pDFFormatOptions = new PDFConfig().getPDFPreferences();
            }
            ((PDFFormatter)resultsFormatter).setPDFFormatOptions(pDFFormatOptions);
        }
        if (resultsFormatter.isQuerySupported()) {
            resultsFormatter.setQueryName(extractDataFormat.getQueryName());
            resultsFormatter.isQuerySaved(extractDataFormat.isQuerySaved());
        }
        if (resultsFormatter.isDataNameSupported()) {
            resultsFormatter.setDataName(extractDataFormat.getDataName());
        }
        if (resultsFormatter.isCommitSupported()) {
            resultsFormatter.isCommit(extractDataFormat.isCommit());
            resultsFormatter.setCommitRows(extractDataFormat.getCommitRows());
        }
        if ((n = resultsFormatter.validateOptions()) != 0) {
            string = string + (string.length() == 0 ? resultsFormatter.getValidationMessage() : "\n\n" + resultsFormatter.getValidationMessage());
        }
        if (n2 != 0 || n != 0) {
            if (n2 == 1 || n == 1) {
                return string;
            }
            return "";
        }
        return null;
    }

    private boolean isExportDBObjects() {
        return this._listModel.isTypeDBO();
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this._targetFormat.getSaveAs() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_FILE") + this.getTerm());
            bl = false;
        }
        if (this._targetFormat.getSaveAsType() == 4 || this._targetFormat.getSaveAsType() == 5) {
            this._targetFormat.isCompressed(false);
        }
        if (this.isExportDBObjects()) {
            if (this._ddlFormat == null) {
                stringBuilder.append(ExportWizArb.getString("NO_FORMAT") + this.getTerm());
                bl = false;
            }
            if (this._ddlType == null) {
                stringBuilder.append(ExportWizArb.getString("NO_TYPE") + this.getTerm());
                bl = false;
            }
        } else if (this._listModel == null || this._listModel.getFirstDataObject() == null || this._listModel.getFirstDataObject().getTable() == null) {
            stringBuilder.append(ExportWizArb.getString("NO_DATA") + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    private String getTerm() {
        return "\n";
    }

    private void write(String string) throws IOException {
        this._genOutputStream.println(string);
    }

    public void cancelExport() {
        this._cancel = true;
    }

    private void exportMetaListAppend(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                if (!this._cancel) {
                    String string = extractObject.getDDL(n).trim();
                    if (string.length() <= 0) continue;
                    this.write(string + this.getTerm());
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void exportMetaList(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                if (!this._cancel) {
                    String string;
                    DBObject dBObject = extractObject.getDBObject();
                    ExtractScript extractScript = null;
                    if (n == 2 || n == 3) {
                        extractScript = extractObject.getScript(110);
                    }
                    if (extractScript == null) {
                        this._genOutputStream.startObject(dBObject.getObjectName(), dBObject.getObjectType());
                    } else {
                        this._genOutputStream.startObject(dBObject.getObjectName(), dBObject.getObjectType(), extractScript.getType(), extractScript.getPath());
                    }
                    if (this._targetFormat.isDeployCloud() && ((string = dBObject.getObjectType()).equals("APEX") || string.equals("APEX_PAGE"))) {
                        this.write(this.INIT_APEX_SQL());
                    }
                    if ((string = extractObject.getDDL(n).trim()).length() > 0) {
                        this.write(string + this.getTerm());
                    }
                    if (n == 2) {
                        this.exportScript(extractObject, 111);
                        continue;
                    }
                    if (n != 3) continue;
                    this.exportScript(extractObject, 111);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void exportDataList(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        try {
            for (ExtractObject extractObject : list) {
                if (this._cancel) break;
                DBObject dBObject = extractObject.getDBObject();
                this.initDataExport();
                ExtractScript extractScript = extractObject.getScript(112);
                if (extractScript == null) {
                    this._genOutputStream.startObject(dBObject.getObjectName(), "DATA_" + dBObject.getObjectType());
                } else {
                    this._genOutputStream.startObject(dBObject.getObjectName(), "DATA_" + dBObject.getObjectType(), extractScript.getType(), extractScript.getPath());
                }
                if (!extractObject.isEmptySelect()) {
                    this.writeDataUsingFormatter(extractObject);
                }
                this.exportScript(extractObject, 113);
            }
            if (list.size() > 0) {
                this._formatter.finishExport();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void loadAndSetNls(List<ExtractObject> list) {
        this.nlsHashMap = new HashMap();
        for (ExtractObject extractObject : list) {
            String string = extractObject.getSourceConnName();
            if (!this.nlsHashMap.containsKey(string)) {
                this.nlsHashMap.put(string, new HashMap());
                HashMap<String, String> hashMap = this.getConNlsValues(string);
                hashMap.put("NLS_LANGUAGE", this.getNlsValue(string, "NLS_LANGUAGE"));
                hashMap.put("NLS_TERRITORY", this.getNlsValue(string, "NLS_TERRITORY"));
                hashMap.put("NLS_CALENDAR", this.getNlsValue(string, "NLS_CALENDAR"));
            }
            this.setCloudNLS(string, "NLS_LANGUAGE", "AMERICAN");
            this.setCloudNLS(string, "NLS_TERRITORY", "AMERICA");
            this.setCloudNLS(string, "NLS_CALENDAR", "GREGORIAN");
        }
    }

    private HashMap<String, String> getConNlsValues(String string) {
        return this.nlsHashMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNlsValue(String string, String string2) {
        String string3 = "SELECT value FROM NLS_DATABASE_PARAMETERS where parameter = :PARAM";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("PARAM", string2);
        String string4 = null;
        boolean bl = false;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                string4 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string3, hashMap);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string4;
    }

    private void unsetCloudNLS() {
        for (String string : this.nlsHashMap.keySet()) {
            HashMap<String, String> hashMap = this.getConNlsValues(string);
            for (String string2 : hashMap.keySet()) {
                String string3 = hashMap.get(string2);
                this.setCloudNLS(string, string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCloudNLS(String string, String string2, String string3) {
        String string4 = "ALTER SESSION SET " + string2 + "=:VALUE";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("VALUE", string3);
        Connection connection = null;
        boolean bl = false;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                DBUtil.getInstance((Connection)connection).executeUpdate(string4, hashMap);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void exportScript(int n) {
        List<ExtractObject> list = this._listModel.getList(n);
        for (ExtractObject extractObject : list) {
            if (this._cancel) break;
            this.exportScript(extractObject, n == 9 ? 114 : 115);
        }
    }

    private void exportScript(ExtractObject extractObject, int n) {
        ExtractScript extractScript = extractObject.getScript(n);
        if (extractScript != null) {
            try {
                String string = extractObject.getType() == 0 ? extractObject.getDBObject().getObjectName() : (n == 114 ? "INITIAL" : "FINAL");
                this._genOutputStream.writeScript(string, extractScript.getType(), extractScript.getPath());
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private void exportScriptList(int n, int n2) {
    }

    private void writeExportDBObjects() throws Exception {
        Object object;
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        dDLGenerator.setWriter(this._genOutputStream.getWriter());
        dDLGenerator.setFormating(this._ddlFormat);
        if (this._targetFormat.isGenDate()) {
            object = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
            Date date = new Date();
            String string = "--------------------------------------------------------" + this.getTerm() + Messages.getString("ExportAPI.157") + ((DateFormat)object).format(date) + "   " + this.getTerm() + "--------------------------------------------------------" + this.getTerm();
            if (this._targetFormat.getSaveAsType() == 0) {
                if (this._ddlFormat.isExtractEnabled() || this._dataFormat.isInsert()) {
                    this.write(string);
                }
            } else {
                this._genOutputStream.setControllingFileHeader(string);
            }
        }
        if (this._isReconcileTypesAndObjects) {
            this._listModel.startProcess();
        } else {
            this._listModel.startProcessReconcileObjects();
        }
        this.exportScript(9);
        if (this._targetFormat.isDeployCloud()) {
            object = this._listModel.getList(0, new int[]{100, 8});
            this.loadAndSetNls((List<ExtractObject>)object);
        }
        if (!this._cancel && this._ddlFormat.isExtractEnabled() && this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("DROP", "DROP");
            this.exportMetaListAppend(4);
        }
        if (this._ddlFormat.getDep()) {
            this._ddlType.setTypes(this._listModel.getList(0, new int[]{100}));
        }
        if (!this._cancel) {
            this.exportScriptList(2, 110);
        }
        if (!this._cancel) {
            this.exportMetaList(2);
        }
        if (!this._cancel) {
            this.exportScriptList(2, 111);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(7);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isTruncate() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this._genOutputStream.startObject("TRUNCATE", "TRUNCATE");
            this.exportMetaListAppend(5);
        }
        if (!this._cancel) {
            this.exportScriptList(0, 112);
        }
        if (!this._cancel) {
            this.exportDataList(8);
        }
        if (!this._cancel) {
            this.exportScriptList(0, 113);
        }
        if (!this._cancel) {
            this.exportScriptList(3, 110);
        }
        if (!this._cancel) {
            this.exportMetaList(3);
        }
        if (!this._cancel && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(6);
        }
        if (!this._cancel) {
            this.exportScriptList(3, 111);
        }
        if (!this._cancel) {
            this.exportScript(10);
        }
        if (this._targetFormat.isDeployCloud()) {
            this.unsetCloudNLS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExportJTable(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Boolean bl = true;
        try {
            ExtractObject extractObject = this._listModel.getFirstDataObject();
            JTable jTable = null;
            jTable = !extractObject.isSqlExtendable() ? extractObject.getTable() : extractObject.getTable();
            if (bl.booleanValue()) {
                this.initDataExport();
                this._genOutputStream.startObject(extractObject.getTableName(), "DATA");
                if (extractObject.isEmptySelect()) {
                    return;
                }
                this._formatter.setOutWriter(this._genOutputStream.getWriter());
                this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
                this._formatter.setDbObject((Object)extractObject.getDBObject());
                this._formatter.setTableName(this._dataFormat.isTableNameVisible() ? this._dataFormat.getTableName() : extractObject.getTableName());
                if (jTable != null && !extractObject.isExcludedColumns()) {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)this.getDataProvider(jTable));
                } else if (extractObject.isSqlExtendable()) {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                } else {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(this._listModel.getSourceConnName(), extractObject.getSql()));
                }
                this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
                this._formatter.doPrint(iRaptorTaskProgressUpdater);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                DBUtil.closeResultSet((ResultSet)this._rs);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private void initDataExport() {
        if (this._formatter == null) {
            this._formatter = (ResultsFormatter)FormatRegistry.getFormatter((String)this._dataFormat.getFormat());
            this._formatter.startExport();
            this._formatter.isHeader(this._dataFormat.isHeader());
            this._formatter.setDelimiter(this._dataFormat.getDelimiterValue());
            this._formatter.setEnclosures(this._dataFormat.getEnclosures(), this._dataFormat.getEnclosureLeftValue(), this._dataFormat.getEnclosureRightValue(), this._dataFormat.isEnclosureRightDouble());
            this._formatter.setLineTerminator(this._dataFormat.getRecordTerminatorValue());
            this._formatter.setLineTerminatorString(BaseDataFormat.getRecordTerminatorString(this._dataFormat.getRecordTerminatorValue()));
            this._formatter.isSeparateDataFile(this._dataFormat.isSeparateDataFile());
            this._formatter.setEncode(this._targetFormat.getEncoding());
            this._dataFormat.setEncoding(this._targetFormat.getEncoding());
            this._formatter.setDataName(this._dataFormat.getDataName());
            this._formatter.isQuerySaved(this._dataFormat.isQuerySaved());
            this._formatter.setQueryName(this._dataFormat.getQueryName());
            this._formatter.isDeployCloud(this._targetFormat.isDeployCloud());
            this._targetFormat.setDataFormatExtension(this._formatter.getExt());
            this._genOutputStream.setFormatter(this._formatter);
            if (this._formatter instanceof PDFFormatter) {
                PDFFormatOptions pDFFormatOptions = (PDFFormatOptions)this._listModel.getPropertyValue("REPORT_OPTIONS");
                if (pDFFormatOptions == null) {
                    pDFFormatOptions = new PDFConfig().getPDFPreferences();
                } else {
                    PDFFormatOptions pDFFormatOptions2 = new PDFConfig().getPDFPreferences();
                    pDFFormatOptions.setFontLocations(pDFFormatOptions2.getFontLocations());
                    pDFFormatOptions.setExternalLibrary(pDFFormatOptions2.getExternalLibrary());
                }
                ((PDFFormatter)this._formatter).setTempTitle(this._dataFormat.getTitle());
                ((PDFFormatter)this._formatter).setTempSubject(this._dataFormat.getSubject());
                ((PDFFormatter)this._formatter).setTempKeywords(this._dataFormat.getKeywords());
                ((PDFFormatter)this._formatter).setPDFFormatOptions(pDFFormatOptions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataUsingFormatter(ExtractObject extractObject) throws FileNotFoundException {
        if (!this._targetFormat.isCompressed()) {
            this._formatter.setOutWriter(this._genOutputStream.getWriter());
            this._formatter.setOutputStream(this._genOutputStream.getOutputStream());
        } else {
            this._formatter.setZipper(this._genOutputStream.getZipper());
        }
        JTable jTable = extractObject.getTable();
        try {
            this._isExportOwnedResultSet = false;
            if (jTable != null && !extractObject.isTableDirty() && !extractObject.isExcludedColumns()) {
                this._formatter.setDataProvider((IResultsFormatterWrapper)this.getDataProvider(jTable));
            } else if (!extractObject.getListModel().isSourceConnTimesTen()) {
                this._isExportOwnedResultSet = true;
                if (extractObject.isSqlExtendable()) {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSqlForVisibleCols() + extractObject.getFinalWhere(), extractObject.getBindMap()));
                } else {
                    this._formatter.setDataProvider((IResultsFormatterWrapper)new SQLFormatterWrapper(extractObject.getDBObject().getConnectionName(), extractObject.getSql() + extractObject.getFinalWhere()));
                }
            }
            this._formatter.setDbObject((Object)extractObject.getDBObject());
            this._formatter.setTableName(extractObject.getTableName());
            this._formatter.setFileName(this._genOutputStream.getCurrentFileName());
            this._formatter.doPrint(this._task != null ? this._task.getRaptorTaskProgressUpdater() : null);
            ArrayList arrayList = this._formatter.getAddToControllingFile();
            for (String string : arrayList) {
                this._genOutputStream.addToControllingFile(string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if ((this._isExportOwnedResultSet || this._isGridResultSet) && this._formatter != null) {
                    this._formatter.close();
                }
                DBUtil.closeResultSet((ResultSet)this._rs);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private ResultsFormatterWrapper getDataProvider(JTable jTable) throws Exception {
        boolean bl = false;
        if (jTable instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)jTable)).allRowsFetched();
        }
        if (!bl) {
            Connection connection = Connections.getInstance().getConnection(((ResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
            String string = ((ResultSetTableModel)((Object)jTable.getModel())).getModifiedSql();
            Map<String, ?> map = ((ResultSetTableModel)((Object)jTable.getModel())).getBindMap();
            List<?> list = ((ResultSetTableModel)((Object)jTable.getModel())).getBindList();
            this._rs = this.getClonedResultSetForTableSql(connection, string, map, list);
            TableModel tableModel = jTable.getModel();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableFormatterWrapper tableFormatterWrapper = new TableFormatterWrapper(jTable);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            int[] nArray = new int[tableFormatterWrapper.getColumnCount()];
            int[] nArray2 = new int[tableFormatterWrapper.getColumnCount()];
            IResultSetTableModel iResultSetTableModel = ExportAPI.getBaseModel(tableModel);
            for (int i = 0; i < tableFormatterWrapper.getColumnCount(); ++i) {
                int n2;
                n = n2 = tableColumnModel.getColumn(i).getModelIndex();
                arrayList.add(n);
                nArray[i] = tableFormatterWrapper.getColumnSize(i);
                arrayList2.add(tableFormatterWrapper.getColumnName(i));
                nArray2[i] = iResultSetTableModel != null ? iResultSetTableModel.getColumnSqlType(n2) : 0;
            }
            this._isExportOwnedResultSet = true;
            return new ResultSetFormatterWrapper(this._rs, arrayList, arrayList2, nArray, nArray2, string);
        }
        return new TableFormatterWrapper(jTable);
    }

    private static IResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof IResultSetTableModel ? (IResultSetTableModel)((Object)tableModel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getClonedResultSetForTableSql(Connection connection, String string, Map<String, ?> map, List<?> list) {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                resultSet = map != null ? DBUtil.getInstance((Connection)connection).executeQuery(string, map) : DBUtil.getInstance((Connection)connection).executeQuery(string, list);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return resultSet;
    }

    public void writeExportHeadless() {
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        try {
            this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
            this._genOutputStream.endPreamble();
            if (!this.checkSetup()) {
                this.write(this.badSetup);
            }
            this.writeExportDBObjects();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                DBUtil.closeResultSet((ResultSet)this._rs);
                this._genOutputStream.finished();
                if (this._targetFormat.isSftp()) {
                    SftpUtil sftpUtil = new SftpUtil();
                    sftpUtil.SftpPut(this._targetFormat.getSftpParms(), true);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeExportWithDialog() {
        boolean bl = false;
        ExtractObject extractObject = this._listModel.getFirstDataObject();
        if (extractObject != null && extractObject.getTable() != null && extractObject.getTable() instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)extractObject.getTable())).allRowsFetched();
        }
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        if (!this.isExportDBObjects()) {
            iRaptorTaskRunMode = this._targetFormat.getSaveAsType() == 0 && !bl ? IRaptorTaskRunMode.IDE_STATUSBAR : IRaptorTaskRunMode.MODAL;
        }
        this._genOutputStream = new ExportGenerationOutputStream(this._targetFormat);
        String string = this._targetFormat.getSaveAsType() < 4 ? this._targetFormat.getSaveAs() : this._targetFormat.getSaveAsTypeString();
        String string2 = ExportWizArb.format("UNLOADING", string);
        this._task = new DatabaseQueryTask<Void>(string2, iRaptorTaskRunMode, false, true){

            public Void doWork() {
                try {
                    ExportAPI.this._genOutputStream.startPreamble(ExportWizArb.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
                    ExportAPI.this._genOutputStream.endPreamble();
                    if (!ExportAPI.this.checkSetup()) {
                        ExportAPI.this.write(ExportAPI.this.badSetup);
                    }
                    ExportAPI.this._cancel = false;
                    if (!ExportAPI.this._targetFormat.getSaveAs().equals("")) {
                        if (ExportAPI.this.isExportDBObjects()) {
                            ExportAPI.this.writeExportDBObjects();
                        } else {
                            ExportAPI.this.writeExportJTable(this.getRaptorTaskProgressUpdater());
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    try {
                        SftpUtil sftpUtil;
                        boolean bl;
                        DBUtil.closeResultSet((ResultSet)ExportAPI.this._rs);
                        ExportAPI.this._genOutputStream.finished();
                        if (ExportAPI.this._targetFormat.isSftp() && !(bl = (sftpUtil = new SftpUtil()).SftpPut(ExportAPI.this._targetFormat.getSftpParms(), true))) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportWizArb.getString("FTP_ERROR_MSG"), ExportWizArb.getString("FTP_ERROR_TITLE"), 0);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                return null;
            }

            public boolean cancel() {
                ExportAPI.this._cancel = true;
                return true;
            }

            @Override
            public String getConnectionName() {
                return ExportAPI.this._connName;
            }

            @Override
            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    if (!ExportAPI.this._targetFormat.isSftp() && ExportAPI.this._genOutputStream != null) {
                        ExportAPI.this._genOutputStream.openTargetInUI(ExportAPI.this._connName);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    ExportAPI.this._task = null;
                }
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }
}

