/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.util.Resource;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class GrantPrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JCheckBox chkAdmin = new JCheckBox();
    protected JCheckBox chkGrant = new JCheckBox();
    private ObjectActionController.ObjectActionPostProcess _oapp;

    protected GrantPrivilegesPanel(DBObject dBObject, ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        super(dBObject);
        this._oapp = objectActionPostProcess;
        ResourceUtils.resButton((AbstractButton)this.chkAdmin, (String)CreateDialogArb.getString("PRIVILEGE_INFO_LABEL_GRANT"));
        this.addItem(this.jPanel3, null, this.chkAdmin, true);
        this.init();
    }

    protected void init() {
        try {
            SQLComboxModel sQLComboxModel = new SQLComboxModel(this.getDBObject().getConnectionName(), "select 'PUBLIC' from dual union all select username from all_users union all select distinct role from session_roles order by 1");
            this.cbxUsers.setModel(sQLComboxModel);
            this.cbxUsers.setEditable(true);
            String[] stringArray = this.getAvailablePrivileges();
            this.mdlPrivFrom.removeAllElements();
            for (int i = 0; i < stringArray.length; ++i) {
                this.mdlPrivFrom.addElement(stringArray[i]);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)this.getDBObject().getConnectionName(), null, (String)Messages.getString((String)"GrantPrivilegesPanel.2"), (SQLException)((SQLException)exception));
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected String[] getAvailablePrivileges() throws IOException {
        Properties properties = new Properties();
        properties.load(Resource.getResourceAsStream(this.getClass(), (String)"privileges.properties"));
        String string = properties.getProperty(this.getDBObject().getObjectType().replace(' ', '_'));
        return string.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performGrant() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grant ");
        if (this.chkAll.isSelected()) {
            stringBuilder.append("ALL");
        } else {
            object = this.getSelectedPrivileges();
            for (int i = 0; i < object.size(); ++i) {
                if (i != object.size() - 1) {
                    stringBuilder.append(object.get(i) + ",");
                    continue;
                }
                stringBuilder.append(object.get(i));
            }
        }
        stringBuilder.append(" on ");
        if (this.getDBObject().getObjectType().equalsIgnoreCase("DIRECTORY")) {
            stringBuilder.append(" directory ");
            stringBuilder.append("\"" + this.getDBObject().getObjectName() + "\"");
        } else {
            stringBuilder.append("\"" + this.getDBObject().getSchemaName() + "\".\"" + this.getDBObject().getObjectName() + "\"");
        }
        stringBuilder.append(" to ");
        stringBuilder.append("\"" + this.cbxUsers.getSelectedItem().toString().toUpperCase() + "\"");
        if (this.chkAdmin.isSelected()) {
            stringBuilder.append(" WITH GRANT OPTION");
        }
        object = this.getDBObject().getConnectionName();
        DBUtil dBUtil = DBUtil.getInstance((String)object);
        dBUtil.setRaiseError(true);
        if (Connections.getInstance().lock((String)object)) {
            try {
                Log.log((String)("GRANTING:" + stringBuilder.toString()));
                if (dBUtil.execute(stringBuilder.toString(), (List)null) && this._oapp != null) {
                    this._oapp.run();
                }
            }
            finally {
                Connections.getInstance().unlock((String)object);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cbxUsers.getSelectedItem() != null && this.cbxUsers.getSelectedItem().toString().length() > 0) {
            this.performGrant();
            this.close(actionEvent);
        } else {
            MessageDialog.error((Component)this, (Object)Messages.getString((String)"GrantPrivilegesPanel.21"), (String)Messages.getString((String)"GrantPrivilegesPanel.22"), null);
        }
    }
}

