/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.ui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizArb;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizDBSelector;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizObjShuttlePanel;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizSummaryPanel;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizTypesPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controller.TriggerController;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class DBDiffWizMain {
    public static final String DIFF_NAME = "raptor.dbdiffWizard";
    public static final int DIFF_ACTION = Ide.findOrCreateCmdID((String)"raptor.dbdiffWizard");
    static final String STATE_B = "StateB";
    static final String TRANSITION_B = "B";
    static final String TRANSITION_FIN = "Fin";
    static final String STATE_FIN = "StateFin";
    static final String STATE_A = "StateA";
    static final String TRANSITION_A = "A";
    private static DBDiffWizMain INSTANCE;

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DBDiffWizArb.getString("STEP1"), DBDiffWizDBSelector.class, "f1_diffhelp_id_for_step1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_A, (Object)STATE_A);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step2 = new Step(DBDiffWizArb.getString("STEP2"), DBDiffWizTypesPanel.class, "f1_diffhelp_id_for_step2");
        fSMBuilder.newState((Object)STATE_A, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_B, (Object)STATE_B);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step3 = new Step(DBDiffWizArb.getString("STEP3"), DBDiffWizObjShuttlePanel.class, "f1_diffhelp_id_for_step3");
        fSMBuilder.newState((Object)STATE_B, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step4 = new Step(DBDiffWizArb.getString("STEP5"), DBDiffWizSummaryPanel.class, "f1_help_id_for_step5");
        fSMBuilder.newFinalState((Object)STATE_FIN, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public WizardDialog getWizard() {
        FSM fSM = DBDiffWizMain.getFSM();
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(DBDiffWizArb.getString("MAIN_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DBDiffWizArb.getImage("WIZ_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DIFF_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static DBDiffWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBDiffWizMain();
        }
        return INSTANCE;
    }

    public void launch() {
        WizardDialog wizardDialog = this.getWizard();
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public static class DBDiffController
    implements Controller,
    TriggerController {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DIFF_ACTION) {
                DBDiffWizMain.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = true;
            int n = 0;
            if (ideAction.getCommandId() == DIFF_ACTION) {
                n = Connections.getInstance().getConnNames().length;
                if (n < 2) {
                    bl = false;
                }
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }

        public Object getInvalidStateMessage(IdeAction ideAction, Context context) {
            return DBDiffWizArb.getString("OPERATION_INVALID");
        }
    }
}

