/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.control;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;

public class FlatButton
extends JButton {
    private Border rolloverBorder = null;

    public FlatButton() {
        this.init();
    }

    public FlatButton(Action action) {
        super(action);
        this.init();
    }

    public FlatButton(String string) {
        super(string);
        this.init();
    }

    public FlatButton(Icon icon) {
        super(icon);
        this.init();
    }

    public void setRolloverBorder(Border border) {
        this.rolloverBorder = border;
    }

    private void init() {
        this.setUI((ButtonUI)new WindowsButtonUI());
        this.addMouseListener(this.getRolloverButtonListener());
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setOpaque(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.rolloverBorder = BorderFactory.createLineBorder(new Color(62, 86, 255));
    }

    private MouseListener getRolloverButtonListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Object object;
                if (FlatButton.this.rolloverBorder != null && (object = mouseEvent.getSource()) instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)object;
                    abstractButton.setBorder(FlatButton.this.rolloverBorder);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Object object = mouseEvent.getSource();
                if (object instanceof AbstractButton) {
                    ((AbstractButton)object).setBorder(null);
                }
            }
        };
        return mouseAdapter;
    }
}

