/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.datatypes.DataTypeArb;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.TextCellEditor;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.ExtensionBundle;
import oracle.ide.util.ResourceUtils;

public class LongCharCustomCellEditor
extends BaseCustomCellEditor
implements ChangeListener {
    IdeSettings settings = Ide.getSettings();
    String _EOLChars = null;
    String eolLabel = null;
    EnvironOptions envopts;
    protected Object value = null;
    protected boolean canChange = true;
    protected JPanel customEditorComponent;
    final JTextField _jtfLineTerminator = new JTextField();
    protected JTextArea jtaEditValue = new JTextArea();
    private JButton lineTermBtn;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";

    public LongCharCustomCellEditor() {
        super(new TextCellEditor());
    }

    @Override
    protected JComponent getCustomEditorComponent() {
        if (null == this.customEditorComponent) {
            this.customEditorComponent = new JPanel();
            this.envopts = (EnvironOptions)this.settings.getData("environment-options");
            this.envopts.addChangeListener((ChangeListener)this);
            this.getEOLSettings();
            this.getLongCharEditPanel();
            this.customEditorComponent.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    LongCharCustomCellEditor.this.envopts.addChangeListener((ChangeListener)LongCharCustomCellEditor.this);
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    LongCharCustomCellEditor.this.envopts.removeChangeListener((ChangeListener)LongCharCustomCellEditor.this);
                }
            });
        }
        return this.customEditorComponent;
    }

    @Override
    protected JComponent getCustomEditorFocusComponent() {
        return this.jtaEditValue;
    }

    @Override
    protected Object getCustomEditorValue() {
        String string = this.jtaEditValue.getText();
        String string2 = string.replaceAll(System.getProperty("line.separator"), this._EOLChars);
        return string2;
    }

    @Override
    protected void setCustomEditorValue(Object object) {
        if (null == object) {
            return;
        }
        Object object2 = object;
        if (object2 instanceof DataValue) {
            this.dataValue = (DataValue)object;
            object2 = this.dataValue.getStringValue();
        }
        String string = object2.toString();
        String string2 = string.replaceAll(LINE_SEPARATOR_PATTERN, System.getProperty("line.separator"));
        this.jtaEditValue.setText(string2);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LongCharCustomCellEditor.this.getEOLSettings();
                LongCharCustomCellEditor.this._jtfLineTerminator.setText(LongCharCustomCellEditor.this.eolLabel);
            }
        });
    }

    protected void getLongCharEditPanel() {
        this.customEditorComponent.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        String string = EnvironOptionsArb.getString((int)20);
        this._jtfLineTerminator.setText(this.eolLabel);
        this._jtfLineTerminator.setEditable(false);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._jtfLineTerminator, (String)string);
        this.lineTermBtn = new JButton();
        this.lineTermBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongCharCustomCellEditor.this.settings.showDialog((Frame)Ide.getMainWindow(), new String[]{ExtensionBundle.get((String)"ENVIRONMENT_SETTINGS")});
            }
        });
        this.lineTermBtn.setEnabled(this.canChange);
        ResourceUtils.resButton((AbstractButton)this.lineTermBtn, (String)DataTypeArb.get((String)"BUTTON_CHANGE"));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.jtaEditValue, (String)DataTypeArb.getString((String)"LABEL_VALUE"));
        JScrollPane jScrollPane = new JScrollPane(this.jtaEditValue);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.jtaEditValue.setRows(10);
        this.jtaEditValue.setEditable(this.canChange);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.customEditorComponent.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.customEditorComponent.add((Component)this._jtfLineTerminator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.customEditorComponent.add((Component)this.lineTermBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.customEditorComponent.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.customEditorComponent.add((Component)jScrollPane, gridBagConstraints);
    }

    protected void getEOLSettings() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        int n = this.envopts.getLineTerminator();
        if (n == 1) {
            this._EOLChars = "\r\n";
            this.eolLabel = EnvironOptionsArb.getString((int)23);
        } else if (n == 3) {
            this._EOLChars = "\r";
            this.eolLabel = EnvironOptionsArb.getString((int)25);
        } else if (n == 2) {
            this._EOLChars = "\n";
            this.eolLabel = EnvironOptionsArb.getString((int)24);
        } else {
            this._EOLChars = System.getProperty("line.separator");
            this.eolLabel = EnvironOptionsArb.getString((int)22);
        }
    }
}

