/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.datatypes.DataValue;

public class BooleanCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;
    private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public BooleanCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorder(this.noFocusBorder);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            this.setSelected((Boolean)object);
        }
        if (object instanceof DataValue) {
            this.setSelected(Boolean.valueOf(((DataValue)object).getStringValue().toString()));
        }
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
            this.setOpaque(true);
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            this.setOpaque(false);
        }
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(this.noFocusBorder);
        }
        return this;
    }
}

