/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.ide.util.ResourceUtils;

public abstract class BaseFormatOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JPanel _formatPanel = new JPanel(new GridBagLayout());
    protected JCheckBox _header;
    protected JComboBox _format;
    private JComboBox _delimiter;
    private JComboBox _enclosureLeft;
    private JComboBox _enclosureRight;
    private JComboBox _recordTerminator;
    private GridBagConstraints _headerConstraints;
    private GridBagConstraints _delimiterLabelConstraints;
    private GridBagConstraints _delimiterConstraints;
    private GridBagConstraints _enclosureLeftLabelConstraints;
    private GridBagConstraints _enclosureLeftConstraints;
    private GridBagConstraints _enclosureRightLabelConstraints;
    private GridBagConstraints _enclosureRightConstraints;
    private GridBagConstraints _recordTerminatorLabelConstraints;
    private GridBagConstraints _recordTerminatorConstraints;
    protected JCheckBox _enclosureRightDouble;
    protected GridBagConstraints _enclosureRightDoubleConstraints;
    protected BaseDataFormat _dataFormat;
    protected IFormatOptions _options;
    protected JLabel _formatLabel;
    private JLabel _delimiterLabel;
    private JLabel _recordTerminatorLabel;
    private JLabel _enclosureLeftLabel;
    private JLabel _enclosureRightLabel;
    protected int _row = 0;
    protected DocumentListener _enclosureLeftTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        void enclosureLeftChanged(DocumentEvent documentEvent) {
            String string;
            String string2 = "";
            try {
                string2 = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && (string = BaseFormatOptionsPanel.this._dataFormat.getEnclosureRightFromLeft(string2)) != null) {
                BaseFormatOptionsPanel.this.getEnclosuresRightComponent().setSelectedItem(string);
            }
        }
    };

    public BaseFormatOptionsPanel(BaseDataFormat baseDataFormat) {
        this._dataFormat = baseDataFormat;
        this._options = this._dataFormat.getOptions();
    }

    public BaseFormatOptionsPanel() {
    }

    public void setOptions(IFormatOptions iFormatOptions) {
        this._options = iFormatOptions;
    }

    public BaseDataFormat getFormatProperties() {
        this._row = 0;
        if (this._options.isDelimiterSupported()) {
            this._dataFormat.setDelimiter((String)this._delimiter.getSelectedItem());
        }
        if (this._options.isEnclosuresSupported()) {
            this._dataFormat.setEnclosureLeft((String)this._enclosureLeft.getSelectedItem());
            this._dataFormat.setEnclosureRight((String)this._enclosureRight.getSelectedItem());
            if (this._enclosureRightDouble != null) {
                this._dataFormat.isEnclosureRightDouble(this._enclosureRightDouble.isSelected());
            }
        }
        if (this._options.isLineTerminatorSupported()) {
            this._dataFormat.setRecordTerminator((String)this._recordTerminator.getSelectedItem());
        }
        this._dataFormat.isHeader(this._dataFormat.isHeaderOptionSupported() ? this._header.isSelected() : true);
        return this._dataFormat;
    }

    public JPanel getFormatPanel() {
        this._row = 0;
        this.addFormatComponents();
        return this._formatPanel;
    }

    public JCheckBox getHeaderComponent() {
        return this._header;
    }

    public JComboBox getFormatComponent() {
        return this._format;
    }

    public JComboBox getDelimiterComponent() {
        return this._delimiter;
    }

    public JComboBox getEnclosuresLeftComponent() {
        return this._enclosureLeft;
    }

    public JComboBox getEnclosuresRightComponent() {
        return this._enclosureRight;
    }

    public JComboBox getRecordTerminatorComponent() {
        return this._recordTerminator;
    }

    public JCheckBox getEnclosureRightDoubleComponent() {
        return this._enclosureRightDouble;
    }

    public void addFormatComponents() {
        this.addDelimitedComponents();
        this.addOtherComponents();
    }

    public void addFormatPreferenceComponents() {
        if (this._options.isEnclosuresSupported()) {
            if (this._enclosureRightDouble == null) {
                this.initEnclosureDoubleComponent();
            } else {
                this.setEnclosureDoubleComponent();
            }
            this._formatPanel.add((Component)this._enclosureRightDouble, this._enclosureRightDoubleConstraints);
        }
    }

    void initDelimitedComponents() {
        this.initDelimiter();
        this.initRecordTerminator();
        this.initEnclosures();
        this.addDelimitedConstraints();
    }

    public void setDelimitedComponents() {
        this.setDelimiter();
        this.setRecordTerminator();
        this.setEnclosures();
    }

    public void setDelimiter() {
        if (this._options.isDelimiterSupported()) {
            this._delimiter.setSelectedItem(this._dataFormat.getTranslatedDelimiter());
            if (this._options.isDelimiterConfigurable()) {
                this._delimiter.setEnabled(true);
            } else {
                this._delimiter.setEnabled(false);
            }
        }
    }

    public void setRecordTerminator() {
        if (this._options.isLineTerminatorSupported()) {
            this._recordTerminator.setSelectedItem(this._dataFormat.getRecordTerminator());
        }
    }

    public void setEnclosures() {
        if (this._options.isEnclosuresSupported()) {
            this._enclosureLeft.setSelectedItem(this._dataFormat.getEnclosureLeft());
            this._enclosureRight.setSelectedItem(this._dataFormat.getEnclosureRight());
        }
    }

    void addDelimitedConstraints() {
        int n = 3;
        int n2 = 0;
        int n3 = 0;
        if (this._options.isDelimiterSupported()) {
            this._delimiterLabelConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0);
            this._delimiterConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.5, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0);
            n3 = 24;
        }
        if (this._options.isLineTerminatorSupported()) {
            this._recordTerminatorLabelConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, n3, 0, 8), 0, 0);
            this._recordTerminatorConstraints = new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0);
        }
        if (n2 != 0) {
            ++n;
            n2 = 0;
        }
        if (this._options.isEnclosuresSupported()) {
            this._enclosureLeftLabelConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0);
            this._enclosureLeftConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 8), 0, 0);
            this._enclosureRightLabelConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 24, 0, 8), 0, 0);
            this._enclosureRightConstraints = new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0);
            this._formatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        }
        if (n2 != 0) {
            ++n;
            n2 = 0;
        }
    }

    void addDelimitedComponents() {
        this.initDelimitedComponents();
        if (this._options.isDelimiterSupported()) {
            this._formatPanel.add((Component)this._delimiterLabel, this._delimiterLabelConstraints);
            this._formatPanel.add((Component)this._delimiter, this._delimiterConstraints);
            if (this._options.isDelimiterConfigurable()) {
                this._delimiter.setEnabled(true);
                this._delimiter.setEditable(true);
            } else {
                this._delimiter.setEnabled(false);
            }
        }
        if (this._options.isLineTerminatorSupported()) {
            this._formatPanel.add((Component)this._recordTerminatorLabel, this._recordTerminatorLabelConstraints);
            this._formatPanel.add((Component)this._recordTerminator, this._recordTerminatorConstraints);
            this._recordTerminator.setEditable(true);
        }
        if (this._options.isEnclosuresSupported()) {
            this._formatPanel.add((Component)this._enclosureLeftLabel, this._enclosureLeftLabelConstraints);
            this._formatPanel.add((Component)this._enclosureLeft, this._enclosureLeftConstraints);
            this._formatPanel.add((Component)this._enclosureRightLabel, this._enclosureRightLabelConstraints);
            this._formatPanel.add((Component)this._enclosureRight, this._enclosureRightConstraints);
            this._enclosureLeft.setEditable(true);
            this._enclosureRight.setEditable(true);
        }
    }

    protected void addEnclosureDoubleComponent() {
        this.initEnclosureDoubleComponent();
        if (this._options.isEnclosuresSupported() && this._enclosureRightDouble != null) {
            this._formatPanel.add((Component)this._enclosureRightDouble, this._enclosureRightDoubleConstraints);
            if (!this._options.isEnclosureRightDoubleConfigurable()) {
                this._enclosureRightDouble.setEnabled(false);
            }
        }
    }

    protected void addOtherComponents() {
    }

    protected void addBasicComponents() {
        if (this._dataFormat.isHeaderOptionSupported()) {
            if (this._header == null) {
                this.initBasicComponents();
            } else {
                this.setBasicComponents();
            }
            this._formatPanel.add((Component)this._header, this._headerConstraints);
        }
    }

    void setBasicComponents() {
        if (this._header != null) {
            this._header.setSelected(this._dataFormat.isHeader());
        }
    }

    void initBasicComponents() {
        if (this._options.isHeaderOptionSupported() && this._header == null) {
            this.initHeader();
            this.addHeaderConstraints();
        }
    }

    void addHeaderConstraints() {
        this._headerConstraints = new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
    }

    protected void initHeader() {
        if (this._options.isHeaderOptionSupported() && this._header == null) {
            this._header = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._header, (String)ExportWizArb.getString("HEADER"));
        }
        this._header.setSelected(this._dataFormat.isHeader());
    }

    void initDelimiter() {
        if (this._options.isDelimiterSupported()) {
            if (this._delimiterLabel == null) {
                this._delimiter = new JComboBox<String>(this._dataFormat.getDelimiters());
                this._delimiter.setSelectedIndex(0);
                this._delimiterLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("DELIMITER")));
                this._delimiterLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("DELIMITER")));
                this._delimiterLabel.setLabelFor(this._delimiter);
            }
            this.setDelimiter();
        }
    }

    void initRecordTerminator() {
        if (this._options.isLineTerminatorSupported()) {
            if (this._recordTerminatorLabel == null) {
                this._recordTerminator = new JComboBox<String>(this._dataFormat.getRecordTerminators());
                this._recordTerminatorLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("RECORD_TERMINATOR")));
                this._recordTerminatorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("RECORD_TERMINATOR")));
                this._recordTerminatorLabel.setLabelFor(this._recordTerminator);
            }
            this.setRecordTerminator();
        }
    }

    void initEnclosures() {
        if (this._options.isEnclosuresSupported()) {
            if (this._enclosureLeft == null) {
                this._enclosureLeft = new JComboBox<String>(this._dataFormat.getEnclosuresLeft());
                this._enclosureLeft.setSelectedIndex(0);
                this._enclosureLeftLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("ENCLOSURE_LEFT")));
                this._enclosureLeftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("ENCLOSURE_LEFT")));
                this._enclosureLeftLabel.setLabelFor(this._enclosureLeft);
                this._enclosureRight = new JComboBox<String>(this._dataFormat.getEnclosuresRight());
                this._enclosureRight.setSelectedIndex(0);
                this._enclosureRightLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("ENCLOSURE_RIGHT")));
                this._enclosureRightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("ENCLOSURE_RIGHT")));
                this._enclosureRightLabel.setLabelFor(this._enclosureRight);
            }
            this.setEnclosures();
        }
    }

    protected void addLeftEnclosureListener() {
        if (this._options.isEnclosuresSupported() && this._enclosureLeft != null) {
            ((JTextField)this._enclosureLeft.getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureLeftTextListener);
        }
    }

    void setEnclosureDoubleComponent() {
        if (this._enclosureRightDouble != null) {
            this._enclosureRightDouble.setSelected(this._dataFormat.isEnclosureRightDouble());
        }
    }

    void initEnclosureDoubleComponent() {
        this._enclosureRightDoubleConstraints = new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(8, 24, 0, 8), 0, 0);
        if (this._options.isEnclosuresSupported() && this._enclosureRightDouble == null) {
            this._enclosureRightDouble = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._enclosureRightDouble, (String)ExportWizArb.getString("ENCLOSURE_RIGHT_DOUBLE"));
        }
        this._enclosureRightDouble.setSelected(this._dataFormat.isEnclosureRightDouble());
        if (!this._options.isEnclosureRightDoubleConfigurable()) {
            this._enclosureRightDouble.setEnabled(false);
        }
    }

    public void enableOptions(boolean bl) {
        if (this._format != null) {
            this._format.setEnabled(bl);
        }
        if (this._header != null) {
            this._header.setEnabled(bl);
        }
        if (this._delimiter != null) {
            this._delimiter.setEnabled(bl);
        }
        if (this._enclosureLeft != null) {
            this._enclosureLeft.setEnabled(bl);
        }
        if (this._enclosureRight != null) {
            this._enclosureRight.setEnabled(bl);
        }
        if (this._recordTerminator != null) {
            this._recordTerminator.setEnabled(bl);
        }
        if (this._enclosureRightDouble != null) {
            if (!this._options.isEnclosureRightDoubleConfigurable()) {
                this._enclosureRightDouble.setEnabled(false);
            } else {
                this._enclosureRightDouble.setEnabled(bl);
            }
        }
    }
}

