/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.databasecopy.CopyAPI;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.javatools.db.DBException;

public class DbDndCopy
extends CopyAPI {
    private List<ExtractObject> m_EOList;
    private boolean isCopyToSchemaFolder = false;
    private boolean isSessionAltered = false;

    public void setDbDndCopy() {
        this.setExtractListModel();
        this.setDbDndCopy(this.m_listModel);
    }

    public void setDbDndCopy(ExtractListModel extractListModel) {
        Object object;
        this.openLog();
        this.m_listModel = extractListModel;
        this.setDDLFormat();
        this.setDataFormat();
        DDLTypes dDLTypes = this.m_listModel.getDDLTypes();
        List<ExtractObject> list = this.m_listModel.getList(0, new int[]{107});
        dDLTypes.setTypes(list);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        this.m_listModel.setDDLTypes(dDLTypes);
        this.log(CopyPanelArb.getString("DRAGGED"));
        for (ExtractObject extractObject : this.getExtractObjectList()) {
            DBObject dBObject = extractObject.getDBObject();
            this.log(dBObject.getObjectName() != null && !dBObject.getObjectName().isEmpty() ? Connections.getDisplayName(dBObject.getConnectionName()) + "." + dBObject.getSchemaName() + "." + dBObject.getObjectType() + "." + dBObject.getObjectName() : Connections.getDisplayName(dBObject.getConnectionName()) + "." + dBObject.getSchemaName() + "." + dBObject.getObjectFolderType() + " " + CopyPanelArb.getString("FOLDER"));
            this.m_listModel.setSourceConnName(extractObject.getSourceConnName());
            this.m_listModel.setDestConnName(this.getTargetConnection());
            if (this.getCopyToSchemaFolder()) {
                this.m_listModel.setSchemas(new String[]{this.getDestinationSchemaName()});
            }
            extractObject.setListModel(this.m_listModel);
        }
        if (this.getDestinationSchemaName() == null) {
            this.log(CopyPanelArb.getString("DROP_TARGET") + " " + Connections.getDisplayName(this.getTargetConnection()));
        } else {
            this.log(CopyPanelArb.getString("DROP_TARGET") + " " + Connections.getDisplayName(this.getTargetConnection()) + "." + this.getDestinationSchemaName());
        }
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DDL_OPTION")) + ": " + (this.isCopyDDL() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyDDL()) {
            this.log(this.isReplaceDest() ? CopyPanelArb.getString("REPLACE") : CopyPanelArb.getString("DO_NOT_REPLACE") + " " + CopyPanelArb.getString("EXISTING_OBJECTS"));
        }
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DATA_OPTION")) + ": " + (this.isCopyData() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyData() && !this.isReplaceDest()) {
            object = CopyPanelArb.getString("SKIP_DATA");
            if (this.isAppendDest()) {
                object = CopyPanelArb.getString("APPEND");
            }
            if (this.isTruncateData()) {
                object = CopyPanelArb.getString("TRUNCATE");
            }
            this.log((String)object + " " + CopyPanelArb.getString("EXISTING_OBJECTS"));
        }
        object = this.m_listModel.getDataFormat();
        ((ExtractDataFormat)object).isTruncate(this.isTruncateData());
        this.m_listModel.setDataFormat((ExtractDataFormat)object);
        this.isReconcileTypesAndObjects(false);
        this.isSessionAltered = false;
        this.startDatabaseCopyWithDialog();
    }

    public void setExtractListModel() {
        this.m_listModel = new ExtractListModel();
        this.m_listModel.setSelectedExtractObjects(this.getExtractObjectList());
        try {
            this.setDestinationConn(Connections.getInstance().getConnection(this.getTargetConnection()));
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    @Override
    protected void setDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        dDLFormat.setUseOtherSchema(true);
        if (this.getCopyToSchemaFolder()) {
            dDLFormat.setUseOtherSchema(true);
            dDLFormat.setIgnoreSchema(false);
        } else {
            dDLFormat.setUseOtherSchema(false);
        }
        dDLFormat.setSegments(false);
        dDLFormat.setSchema(false);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        this.m_listModel.setDDLFormat(dDLFormat);
    }

    @Override
    protected void startDatabaseCopy() {
        this.alterSessionSetCurrentSchema(this.getDestinationConn());
        if (this.isCopyDDL() && !this.isCopyData()) {
            this.databaseCopyDDLOnly();
            return;
        }
        if (this.isCopyDDL()) {
            this.databaseCopyDDL();
        }
        if (this.isCopyData() && !this.m_cancel) {
            this.databaseCopyData();
        }
    }

    @Override
    protected void endDatabaseCopy() {
        this.resetSessionSetCurrentSchema(this.getDestinationConn());
    }

    public void setTargetConnection(String string) {
        this.m_destinationConnName = string;
    }

    public String getTargetConnection() {
        return this.m_destinationConnName;
    }

    public List<ExtractObject> getExtractObjectList() {
        return this.m_EOList;
    }

    public void setExtractObjectList(List<ExtractObject> list) {
        this.m_EOList = list;
    }

    @Override
    protected void databaseCopyData() {
        if (!this.isReplaceDest() && this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(7, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(5, 104, this.getDestinationConn());
        }
        this.getExtractListAndCopyData(8, this.getDestinationConn());
        if (this.isCopyDDL()) {
            if (!this.isReplaceDest()) {
                this.getExtractListAndExecuteDDL(3, 105, this.getDestinationConn());
            } else {
                this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
            }
        }
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(6, 104, this.getDestinationConn());
        }
    }

    @Override
    protected void getExtractListAndExecuteDDL(int n, int n2, Connection connection) {
        List<ExtractObject> list = null;
        list = n2 == 0 ? this.m_listModel.getList(n) : this.m_listModel.getList(n, new int[]{n2});
        boolean bl = false;
        try {
            ExtractScript extractScript = null;
            for (ExtractObject extractObject : list) {
                block20: {
                    String string = extractObject.getDDL(n, ExtractObject.COPY_DDL);
                    boolean bl2 = string != null && string.endsWith("set define off;");
                    extractScript = extractObject.getScript(n);
                    this.checkCancelled();
                    if (bl2 && extractScript == null) continue;
                    if (n == 2) {
                        this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                    } else if (n == 3) {
                        this.setProg(DatabaseCopyArb.getString("CREATING_SUPPORTING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                    } else if (n == 4) {
                        this.setProg(DatabaseCopyArb.getString("DROP_OBJ") + " " + extractObject.getDBObject().getObjectName());
                    }
                    try {
                        if (n == 2 && extractScript != null) {
                            if (!bl) {
                                this.lineStart();
                                bl = true;
                            }
                            this.getExecutionScript(extractObject, 110);
                        }
                        if (string != null && !string.isEmpty()) {
                            this.lineStart();
                            bl = true;
                            this.executeSql(string, connection);
                        }
                        if (n == 2 && extractScript != null) {
                            if (!bl) {
                                this.lineStart();
                                bl = true;
                            }
                            this.getExecutionScript(extractObject, 111);
                        }
                    }
                    catch (Exception exception) {
                        if (this.m_ignoreAllErrors) break block20;
                        DatabaseCopyException databaseCopyException = new DatabaseCopyException();
                        int n3 = 0;
                        try {
                            n3 = databaseCopyException.askContinueOnError(CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                            if (n3 == 2) {
                                this.cancel();
                            } else {
                                this.m_ignoreAllErrors = true;
                            }
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                        }
                    }
                }
                if (bl) {
                    this.lineEnd();
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void getExtractListAndCopyData(int n, Connection connection) {
        List<ExtractObject> list = this.m_listModel.getList(n, new int[]{103});
        String string = null;
        try {
            for (ExtractObject extractObject : list) {
                DBObject dBObject = extractObject.getDBObject();
                if (!extractObject.isSelectedData() || !dBObject.getObjectType().equals("TABLE")) continue;
                this.checkCancelled();
                this.lineStart();
                string = extractObject.getFinalWhere();
                DataMover dataMover = new DataMover(Connections.getInstance().getConnection(extractObject.getSourceConnName()), connection);
                dataMover.setLogFile(this.m_out);
                this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + dBObject.getObjectName());
                this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + dBObject.getObjectName());
                if (n == 8) {
                    this.getExecutionScript(extractObject, 112);
                }
                if (!dataMover.move(dBObject, string, 0, true)) {
                    this.cancel();
                    this.checkCancelled();
                    break;
                }
                if (n == 8) {
                    this.getExecutionScript(extractObject, 113);
                }
                this.lineEnd();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void getExecutionScript(ExtractObject extractObject, int n) {
        ExtractScript extractScript = extractObject.getScript(n);
        if (extractScript != null) {
            try {
                String string = extractObject.getType() == 0 ? extractObject.getDBObject().getObjectName() : (n == 114 ? "INITIAL" : "FINAL");
                this.executeSqlScript(extractScript.getUrl());
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private boolean alterSessionSetCurrentSchema(Connection connection) {
        String string = null;
        try {
            if (!this.isSessionAltered && this.getCopyToSchemaFolder()) {
                string = "ALTER SESSION SET CURRENT_SCHEMA = " + DBUtil.addDoubleQuote((String)this.getDestinationSchemaName()) + ";";
                this.executeSql(string, connection);
                this.isSessionAltered = true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private boolean resetSessionSetCurrentSchema(Connection connection) {
        String string = null;
        try {
            if (this.isSessionAltered && this.getCopyToSchemaFolder()) {
                string = "ALTER SESSION SET CURRENT_SCHEMA = " + DBUtil.addDoubleQuote((String)Connections.getInstance().getDatabase(this.m_destinationConnName).getUserName()) + ";";
                this.executeSql(string, connection);
                this.isSessionAltered = true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlScript(URL uRL) {
        ScriptExecutor scriptExecutor = new ScriptExecutor(uRL, this.getDestinationConn());
        try {
            this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_STARTED"), uRL.getFile()));
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.setSqlError(4);
            ScriptExecutor.enableDbmsOutput((Connection)this.getDestinationConn(), (int)20000);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutor.run();
            this.log(this.getTerm() + CopyPanelArb.getString("SQLEXECUTION_SUCCESSFULL"));
        }
        catch (Exception exception) {
            try {
                this.log(this.getTerm() + CopyPanelArb.getString("SQLEXECUTION_FAILED"));
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            catch (Throwable throwable) {
                this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
                throw throwable;
            }
            this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
        }
        this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
    }

    public boolean getCopyToSchemaFolder() {
        return this.isCopyToSchemaFolder;
    }

    public void setCopyToSchemaFolder(boolean bl) {
        this.isCopyToSchemaFolder = bl;
    }
}

