/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public abstract class ImportGen {
    private static final String DEFAULT_GROUP_QUOTE = "importgen";
    protected final String ENCODING_UTF8 = "UTF-8";
    private final String NEW_LINE = "\n";
    private static StringTemplateGroup _templateGroup = null;
    private ImportProperties _iProps;
    private GenericTable _genTable;
    private boolean _isExistingTable;
    private boolean _isBatch;
    private Connection _baseConn;
    private String _baseUser;
    private String _schemaName;
    private String _connName;
    private ImportDataFormat _dataFormat;
    private ImportWriteStream _stream;
    private String _encoding;
    Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGen(ImportProperties importProperties) {
        this._iProps = importProperties;
    }

    public ExitCode start() {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.1"));
        try {
            this._encoding = Ide.getEnvironOptions().getEncoding();
            this._stream = (ImportWriteStream)this._iProps.get(ImportKeys.IMPORT_WRITE_STREAM);
            this._isExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
            this._isBatch = (Boolean)this._iProps.get(ImportKeys.IS_BATCH);
            this._genTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            this._connName = ((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getConnectionName();
            this._baseConn = Connections.getInstance().getConnection(this._connName);
            this._baseUser = this._baseConn.getMetaData().getUserName();
            this._schemaName = ((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getSchemaName();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exception.getMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public abstract ExitCode generate();

    protected boolean isBatch() {
        return this._isBatch;
    }

    protected boolean isExistingTable() {
        return this._isExistingTable;
    }

    protected Connection getConn() {
        return this._baseConn;
    }

    protected String getConnName() {
        return this._connName;
    }

    protected String getUser() {
        return this._baseUser;
    }

    protected String getSchemaName() {
        return this._schemaName;
    }

    protected GenericTable getGenTable() {
        return this._genTable;
    }

    protected String getTableName() {
        return this._genTable.getTable().getTablename();
    }

    protected ImportDataFormat getDataFormat() {
        return this._dataFormat;
    }

    protected ImportWriteStream getStream() {
        return this._stream;
    }

    protected String getEncoding() {
        return this._encoding;
    }

    protected String addUser(String string) {
        if (!this._baseUser.equals(this._schemaName)) {
            return DBUtil.addDoubleQuote((String)this._schemaName) + "." + string;
        }
        return string;
    }

    protected String addDoubleQuote(String string) {
        if (this._isExistingTable) {
            return DBUtil.addDoubleQuote((String)string);
        }
        return string;
    }

    protected String translateEOL(String string) {
        string = string.replaceAll("\\r", "");
        String string2 = this._dataFormat.getRecordTerminatorValue((String)this._iProps.get(ImportKeys.FILEOUTNEWLINE));
        String string3 = this._dataFormat.getRecordTerminatorValue(this._dataFormat.getRecordTerminator());
        String string4 = string2 != null && !BaseDataFormat.isRecordTerminatorImportFile(string2) ? string2 : string3;
        string = string.replaceAll("\\n", string4);
        return string;
    }

    protected String dos(String string) {
        return string.replaceAll("\\r", "").replaceAll("\\n", "\r\n");
    }

    protected String nix(String string) {
        return string.replaceAll("\\r", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutFile(File file, String string) {
        OutputStreamWriter outputStreamWriter = null;
        String string2 = DBConfig.getInstance().getString("IMPORT_LDR_GEN_ENCODING");
        try {
            outputStreamWriter = string2 != null && string2.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2) : (this._encoding == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this._encoding));
            outputStreamWriter.write(string);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
    }

    protected String getCreateTableStatementWithComments() {
        StringBuffer stringBuffer = new StringBuffer();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        stringBuffer.append(this.getCreateTableStatement() + "\n\n");
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null || columnArray[i].getComment() == null || columnArray[i].getComment().trim().length() <= 0) continue;
            stringBuffer.append(this.getCommentStatement(this._genTable.getTable().getTablename(), columnArray[i].getName(), columnArray[i].getComment()) + "\n\n");
        }
        return stringBuffer.toString();
    }

    protected String getCreateTableStatement() {
        String string = this._genTable.getTable().getTablename();
        String[] stringArray = this.formatTableColumns();
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CreateTableStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        return stringTemplate.toString();
    }

    protected String getCommentStatement(String string, String string2, String string3) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CommentOnColumnStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        stringTemplate.setAttribute("colName", (Object)this.addDoubleQuote(string2));
        stringTemplate.setAttribute("comment", (Object)string3);
        return stringTemplate.toString();
    }

    protected String getInsertStatement(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 1);
    }

    protected String getInsertStatementForPrepare(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 2);
    }

    protected String getInsertStatementForError(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 3);
    }

    protected String getInsertStatementForComment(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 4);
    }

    private String getInsertStatement(String string, Column[] columnArray, Object[] objectArray, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        StringTemplate stringTemplate = new StringTemplate();
        if (n == 1) {
            stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatement");
        } else if (n == 2) {
            bl = true;
            stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatementForPrepare");
        } else if (n == 3) {
            bl2 = true;
            stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatementForError");
        } else {
            stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatementForComment");
        }
        String[] stringArray = new String[columnArray.length];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColID() < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String[] stringArray2 = new String[objectArray2.length];
        ITypeFormattor iTypeFormattor = null;
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            stringArray[n2] = this._isExistingTable ? DBUtil.addDoubleQuote((String)columnArray[n2].getName()) : columnArray[n2].getName();
        }
        if (!bl2) {
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                if (bl) {
                    stringArray2[n2] = "?";
                    continue;
                }
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[n2].getType());
                if (iTypeFormattor == null) {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
                String string2 = iTypeFormattor.formatData(objectArray2[n2], columnArray[n2]);
                if (string2.length() > 4000) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = string2.length();
                    if ((n3 = (string2 = string2.substring(1, n3 - 1)).length()) > 0) {
                        int n4 = 0;
                        int n5 = 500;
                        while (n3 > 0) {
                            String string3 = string2.substring(n4, n5);
                            if (string3.endsWith("'") && !string3.endsWith("''")) {
                                --n5;
                            }
                            stringBuffer.append("TO_CLOB('" + string2.substring(n4, n5));
                            if ((n3 -= n5 - n4) == 0) {
                                stringBuffer.append("')");
                            } else {
                                stringBuffer.append("')\n|| ");
                            }
                            n4 = n5;
                            n5 += Math.min(500, n3);
                        }
                        string2 = stringBuffer.toString();
                    } else {
                        stringBuffer.append("''");
                    }
                }
                stringArray2[n2] = string2;
            }
        }
        stringTemplate.setAttribute("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        if (!bl2) {
            stringTemplate.setAttribute("valList", (Object)stringArray2);
        }
        return stringTemplate.toString();
    }

    protected String[] formatTableColumns() {
        return this.formatTableColumns(false);
    }

    protected String[] formatTableColumns(boolean bl) {
        String[] stringArray = null;
        Column[] columnArray = null;
        String string = null;
        ITypeFormattor iTypeFormattor = null;
        if (this._genTable != null) {
            columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            stringArray = new String[columnArray.length];
            for (int i = 0; i < columnArray.length; ++i) {
                string = columnArray[i].getType();
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(string.toUpperCase());
                if (iTypeFormattor != null) {
                    iTypeFormattor.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
                } else {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.isAddDoubleQuote(bl);
                stringArray[i] = iTypeFormattor.formatColumn(columnArray[i]);
            }
        }
        return stringArray;
    }

    protected void loadTemplates() {
        RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/raptor/data/templates", this.getClass().getClassLoader());
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        _templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_GROUP_QUOTE);
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    public void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        _templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        if (_templateGroup == null) {
            this.loadTemplates();
        }
        return _templateGroup;
    }

    protected static void openSqlNodeForURL(URL uRL) throws Exception {
        SqlNode sqlNode = null;
        sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
        final SqlNode sqlNode2 = sqlNode;
        if (sqlNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                }
            });
        }
    }

    protected ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
        ObjectAction objectAction = (ObjectAction)this._iProps.get(ImportKeys.OBJECTACTION);
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
        return objectActionPostProcess;
    }

    protected boolean isFileWritable(String string) {
        File file = new File(string);
        boolean bl = true;
        if (file.exists()) {
            boolean bl2 = bl = this._iProps.getValueBoolean(ImportKeys.IS_BATCH) == false;
            if (bl) {
                AskDelete askDelete = new AskDelete(string);
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        askDelete.run();
                    } else {
                        SwingUtilities.invokeAndWait(askDelete);
                    }
                    if (askDelete.getDeleted() != null && askDelete.getDeleted().equals(Boolean.FALSE)) {
                        bl = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
                }
            }
        }
        return bl;
    }

    static class AskDelete
    implements Runnable {
        private Boolean deleted = Boolean.FALSE;
        private String in = null;
        private File inFile = null;

        public AskDelete(String string) {
            this.in = string;
            this.inFile = new File(this.in);
        }

        @Override
        public void run() {
            String string = this.in;
            int n = this.in.lastIndexOf(File.separator);
            if (n != -1) {
                string = this.in.substring(n + 1);
            }
            switch (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("FILE_EXISTS_OVERWRITE"), (String)string)) {
                case 1: {
                    this.inFile.delete();
                    this.deleted = Boolean.TRUE;
                    break;
                }
                default: {
                    this.deleted = Boolean.FALSE;
                }
            }
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }
}

