/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.net.URL;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.data.writers.ImportGenSqlLoader;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.ide.Ide;

public class ImportAPI {
    protected final String ENCODING = "UTF-8";
    private ImportProperties _iProps;
    private ImportGen _generator;
    private ImportWriteStream _stream;
    private URL _url;
    private LoadFile _file;
    private ImportDataFormat _dataFormat;
    protected String _encoding;

    public ImportAPI(ImportProperties importProperties) {
        this._iProps = importProperties;
        this._stream = (ImportWriteStream)this._iProps.get(ImportKeys.IMPORT_WRITE_STREAM);
        this._url = (URL)importProperties.get(ImportKeys.URL_FOR_AUTO_OPEN);
        this._encoding = Ide.getEnvironOptions().getEncoding();
        this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        this._file = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._generator = this.getGenerator();
    }

    private ImportGen getGenerator() {
        Integer n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return new ImportGenSqlLoader(this._iProps);
            }
        }
        return null;
    }

    public ExitCode start() {
        try {
            this._generator.loadTemplates();
            return this._generator.start();
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + exception.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    public ExitCode doLoad() {
        return this._generator.generate();
    }
}

