/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportDiscardFilePanel
extends JPanel {
    private JCheckBox _importFileCheckBox;
    private URLFileChooser.URLFileChooserPanel _importFilePanel;
    private boolean checkBoxControlled;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportDiscardFilePanel() {
        this(true);
    }

    public ImportDiscardFilePanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initFilePanel();
    }

    public JCheckBox getCheckBox() {
        return this._importFileCheckBox;
    }

    public String getSelectedDirectory() {
        if (this._importFilePanel.getSelectedFile() != null) {
            return this._importFilePanel.getSelectedFile().getPath();
        }
        return null;
    }

    void initFilePanel() {
        int n = 0;
        this._importFileCheckBox = new JCheckBox();
        this._importFileCheckBox.setSelected(true);
        this._importFileCheckBox.setText(PreferencesArb.getString("IMPORT_USE_DISCARD"));
        if (this.checkBoxControlled) {
            this._importFileCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    ImportDiscardFilePanel.this._importFilePanel.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this._importFilePanel = URLFileChooser.createURLFileChooserPanel(0, PreferencesArb.getString("IMPORT_DISCARD_DIR"), true, true);
        this._importFilePanel.setSelectionScope(1);
        this._importFilePanel.setPathContext(this.getClass().getName() + "._discardFileChooser");
        this.add((Component)this._importFileCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._importFilePanel, new GridBagConstraints(1, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this._importFilePanel.setCurrentDirectory(new File(dBConfig.getString("IMPORT_LDR_DISCARDGEN_DIR")));
        this._importFileCheckBox.setSelected(dBConfig.getBoolean("IMPORT_LDR_USE_DISCARD"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_LDR_USE_DISCARD", this._importFileCheckBox.isSelected());
        dBConfig.putString("IMPORT_LDR_DISCARDGEN_DIR", this._importFilePanel.getSelectedFile().getName());
    }
}

