/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ColumnListPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.KnownColumnPropertiesPanel;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;

public class ColumnPanel
extends DefaultTraversablePanel
implements ColumnChangeListener {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(ColumnPanel.class.getName());
    private GenericTable genericTable;
    private JTextPane instructions;
    private JPanel matchPanel;
    private JComboBox matchBy;
    private ActionListener matchByListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnPanel.this.matchByType = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
            ColumnPanel.this.refreshColumnData();
        }
    };
    private ColumnListPanel clp;
    private DataPreviewGizmo gizmo;
    private boolean insertToExistingTable;
    private ColumnPropertyPanel colPropPanel;
    private GridBagConstraints cppConstraints = new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private Column _column;
    private TraversableContext m_ctx;
    private boolean isHeader;
    private boolean matchByInit = false;
    private int matchByType;
    private static int matchByName = 0;
    private static int matchByPosition = 1;
    private int _loadMethod;
    private ImportProperties _iProps;
    private LoadFile _loadFile;
    private Locale _locale;

    public ColumnPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 7, 7, 0};
        this.setLayout(gridBagLayout);
        this.instructions = new JTextPane();
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setRequestFocusEnabled(false);
        this.instructions.setFocusable(false);
        this.add(this.instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.matchPanel = new JPanel(new GridBagLayout());
        this.add(this.matchPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.clp = new ColumnListPanel();
        this.clp.getLstColumns().setSelectionModel(new SingleSelectionModel(){

            @Override
            public void updateSingleSelection(int n, int n2) {
                if (n >= 0) {
                    Column column = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n);
                    if (ColumnPanel.this.colPropPanel != null && column != null) {
                        column.refreshData(ColumnPanel.this.colPropPanel.getColumnDetails());
                        Column column2 = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n2);
                        if (column2 != null) {
                            LoadField loadField = ColumnPanel.this._loadFile.getFieldByName(column2.getSourceColumnName());
                            loadField.isChecked(true);
                        }
                        if (ColumnPanel.this.colPropPanel != null) {
                            ColumnPanel.this._column = column2;
                            ColumnPanel.this.colPropPanel.setColumn(column2);
                            ColumnPanel.this.gizmo.refreshOneCol(column2.getSourceColID());
                        }
                        ColumnPanel.this.clp.setCurrentSelection(n2);
                    }
                } else {
                    Column column = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n2);
                    if (column != null) {
                        ColumnPanel.this._loadFile.getFieldByName(column.getSourceColumnName()).isChecked(true);
                    }
                }
            }
        });
        this.add(this.clp, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        ImportDataFormat importDataFormat;
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
        this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.clp.onEntry(traversableContext);
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        this.insertToExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
        this.gizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
        this.gizmo.onEntry(traversableContext);
        this.populateDBO(traversableContext);
        if (!this.insertToExistingTable && !this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
            this.gizmo.detectColumnDefinitions(this._loadFile, this._locale);
        }
        this.populateSrcDataColumns(traversableContext);
        this.setupColumnDetails(traversableContext);
        if (this.insertToExistingTable) {
            importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            if (!this.matchByInit) {
                JLabel jLabel = new JLabel();
                jLabel.setText(DataImportArb.getString("MATCH_BY_LABEL"));
                this.matchPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                String[] stringArray = new String[]{DataImportArb.getString("MATCH_BY_NAME"), DataImportArb.getString("MATCH_BY_POSITION"), DataImportArb.getString("MATCH_BY_NONE")};
                this.matchBy = new JComboBox<String>(stringArray);
                this.isHeader = importDataFormat.isHeader();
                if (!this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
                    this.matchBy.addActionListener(this.matchByListener);
                    if (this.isHeader) {
                        this.matchBy.setSelectedIndex(0);
                    } else {
                        this.matchBy.setSelectedItem(DataImportArb.getString("MATCH_BY_POSITION"));
                    }
                } else {
                    this.matchBy.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.MATCH_BY_TYPE));
                    this.matchBy.addActionListener(this.matchByListener);
                }
                this.matchPanel.add((Component)this.matchBy, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            } else if (this.isHeader != importDataFormat.isHeader()) {
                this.isHeader = importDataFormat.isHeader();
                this.refreshColumnData();
            }
            this.matchByInit = true;
        }
        this._column = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
        importDataFormat = new Column();
        importDataFormat.refreshData(this._column);
        importDataFormat.setSourceColID(this._column.getSourceColID());
        importDataFormat.setSourceColumnName(this._column.getSourceColumnName());
        this.colPropPanel.setColumn((Column)importDataFormat);
        if (Boolean.valueOf(n == 2 || n == 3 || n == 4).booleanValue()) {
            traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        } else {
            traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
        }
    }

    private void refreshColumnData() {
        for (int i = 0; i < this.clp.getLstColumns().getModel().getSize(); ++i) {
            Column column = (Column)this.clp.getLstColumns().getModel().getElementAt(i);
            Column column2 = null;
            if (this.matchByType == matchByName) {
                column2 = this.genericTable.getTable().getFirstColumn();
                for (Column column3 : this.genericTable.getTable().getColumns()) {
                    if (column3.getName().equalsIgnoreCase(column.getSourceColumnName().trim())) {
                        column2 = column3;
                        break;
                    }
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else if (this.matchByType == matchByPosition) {
                try {
                    column2 = (Column)this.genericTable.getTable().getColumns().get(i);
                }
                catch (Exception exception) {
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            if (this.insertToExistingTable && column2 == null) {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            column.refreshData(column2);
            if (column.getFormat() != null && column2.getFormat().length() != 0) continue;
            this.gizmo.detectFormat(column, this._locale);
        }
        if (this.colPropPanel != null) {
            Column column = this.clp.getCurrentSelection();
            this.colPropPanel.setColumn(column);
        }
        this.clp.resetValidators();
        this.clp.repaint();
    }

    private void setupColumnDetails(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        try {
            ColumnPropertyPanel columnPropertyPanel;
            if (this.colPropPanel != null) {
                this.remove(this.colPropPanel);
            }
            if (this.insertToExistingTable) {
                columnPropertyPanel = new KnownColumnPropertiesPanel((DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO), Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)));
                ((KnownColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable, true);
                this.colPropPanel = columnPropertyPanel;
                this.add(columnPropertyPanel, this.cppConstraints);
                ((KnownColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
            } else {
                this.colPropPanel = columnPropertyPanel = new ColumnPropertiesPanel((DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO), Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE));
                ((ColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable);
                this.add(columnPropertyPanel, this.cppConstraints);
                if (this._loadMethod == 2 || this._loadMethod == 3) {
                    ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(false);
                } else {
                    ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(true);
                }
                ((ColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
            }
            columnPropertyPanel = this.clp.getCurrentSelection();
            if (columnPropertyPanel != null) {
                this.gizmo.refreshOneCol(this.genericTable.getTable().getColumnIndexByName(columnPropertyPanel.getSourceColumnName()));
            }
            this.validate();
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    private void populateSrcDataColumns(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        ((DefaultListModel)this.clp.getLstColumns().getModel()).clear();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        for (int i = columnArray.length - 1; i >= 0; --i) {
            this.clp.addColumn(columnArray[i]);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
        Column column = this.clp.getCurrentSelection();
    }

    public Object getExitTransition() {
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        return n != 2 && n != 3 && n != 4;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this.matchBy != null) {
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, this.matchBy.getSelectedIndex());
        }
        if (traversableContext.getDirection() == 1) {
            for (LoadFieldValidator loadFieldValidator : (LoadFieldValidator[])this._iProps.get(ImportKeys.VALIDATORS)) {
                if (!loadFieldValidator.getLoadField().isLoad() || loadFieldValidator.getHighestExitCode() != ExitCode.EXIT_SEVERE) continue;
                throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_ERR"));
            }
        }
        LoadFieldValidator[] loadFieldValidatorArray = (LoadFieldValidator[])this.clp.getLstColumns().getSelectedValue();
        loadFieldValidatorArray.refreshData(this.colPropPanel.getColumnDetails());
        this.colPropPanel.setDateMask(loadFieldValidatorArray.getFormat());
    }

    private void validateColumnNames(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = this.genericTable.getColumns();
        int n = 0;
        String string = "";
        String string2 = " ";
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        Database database = dBObject.getDatabase();
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = columnArray[i].getName();
                try {
                    database.validateName("COLUMN", string3);
                    continue;
                }
                catch (InvalidNameException invalidNameException) {
                    string = string + string2 + string3;
                    if (string2.equals(" ")) {
                        this.clp.setCurrentSelection(i);
                    }
                    string2 = ",";
                }
            }
        }
        if (string.length() != 0) {
            throw new TraversalException(DataImportArb.format("COLUMN_NAMES_INVALID_ERROR", string));
        }
    }

    private void ensureSelectedColumnsHaveMapping(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        int n = 0;
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                if (columnArray[i].getName() != null && columnArray[i].getPrecision() > 0 && columnArray[i].getType() != null) continue;
                this.clp.setCurrentSelection(i);
            }
        }
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        if (this._iProps.get(ImportKeys.DBOBJECT) == null) {
            if (genericTable == null) {
                genericTable = new GenericTable();
                genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
                Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
                for (int i = columnArray.length - 1; i >= 0; --i) {
                    genericTable.addColumn(columnArray[i]);
                }
            }
        } else if (((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getObjectName() != null) {
            this.insertToExistingTable = true;
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            if (genericTable == null) {
                try {
                    genericTable = new GenericTable(Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), dBObject.getSchemaName(), dBObject.getObjectName());
                }
                catch (DBException dBException) {
                    LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                }
            }
        } else if (genericTable == null) {
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                genericTable.addColumn(columnArray[i]);
            }
        }
        this.setTable(genericTable);
        this.setInstruction((DBObject)this._iProps.get(ImportKeys.DBOBJECT));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this.instructions.setText(DataImportArb.getString("DATA_MAPPING_EXISTING_INFO"));
            return;
        }
        this.instructions.setText(DataImportArb.getString("DATA_MAPPING_CREATE_INFO"));
    }

    private void setTable(GenericTable genericTable) {
        this.genericTable = genericTable;
    }

    @Override
    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        Column column = columnChangeEvent.getColumn();
        this._column.refreshData(column);
        ColumnChangeEvent.Type type = columnChangeEvent.getType();
        switch (type) {
            case MAPPING: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
                this.clp.resetCurrentSelectionValidator();
                break;
            }
            case NAME: {
                this.clp.resetValidators(LoadFieldValidator.Test.COLUMN_NAME);
                break;
            }
            case DATATYPE: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_DATATYPE, LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case PRECISION: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case SCALE: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case FORMAT: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case DATA: {
                this.clp.resetCurrentSelectionValidator(LoadFieldValidator.Test.COMPATIBLE_DATA);
                break;
            }
            default: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
            }
        }
        this.clp.repaint();
    }

    private class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            int n3 = this.getMinSelectionIndex();
            super.setSelectionInterval(n, n2);
            int n4 = this.getMinSelectionIndex();
            if (n3 != n4) {
                this.updateSingleSelection(n3, n4);
            }
        }

        public void updateSingleSelection(int n, int n2) {
        }
    }
}

