/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.data.readers.CSVReader;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DelimitedReader;
import oracle.dbtools.raptor.data.readers.TxtReader;
import oracle.dbtools.raptor.data.readers.XLSReader;
import oracle.dbtools.raptor.data.readers.XLSXReader;

public class DataReaderRegistry {
    private static Map<String, Class<? extends DataReadable>> s_registry = new HashMap<String, Class<? extends DataReadable>>();

    public static synchronized void registerReader(DataReadable dataReadable) {
        s_registry.put(dataReadable.getType().toLowerCase(), dataReadable.getClass());
    }

    public static synchronized void unregisterReader(DataReadable dataReadable) {
        s_registry.remove(dataReadable.getType().toLowerCase());
    }

    public static synchronized DataReadable getReader(String string) {
        try {
            return s_registry.get(string.toLowerCase()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(DataReaderRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(DataReaderRegistry.class.getName()).log(Level.SEVERE, "Unable to instantiate the Data Reader");
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    public static boolean isTypeRegistered(String string) {
        return s_registry.get(string.toLowerCase()) != null;
    }

    static {
        DataReaderRegistry.registerReader(new DelimitedReader());
        DataReaderRegistry.registerReader(new CSVReader());
        DataReaderRegistry.registerReader(new XLSReader());
        DataReaderRegistry.registerReader(new XLSXReader());
        DataReaderRegistry.registerReader(new TxtReader());
    }
}

