/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.qbql;

import java.awt.Component;
import java.awt.Cursor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.javatools.editor.BasicEditorPane;

public class QBQLEditPanel {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(QBQLEditPanel.class.getName());
    private static boolean JIT_METADATA_LOADING = true;
    private static boolean DEBUG = Boolean.getBoolean("sqldev.debug");
    private static final String LOADING_MSG = ControlsArb.getString("QueryBuilderEditorPanel_LoadingMsg");
    private static final String JIT_LOADING_MSG = ControlsArb.getString("QueryBuilderEditorPanel_JITLoadingMsg");
    private static final String GENERIC_EXCEPTION_MSG = ControlsArb.getString("QueryBuilderEditorPanel_GenericExceptionMsg");
    private static final String NOT_VALID_SELECT_MSG_KEY = "QueryBuilderEditorPanel_NotValidSelectMsg";
    private static final String UNSUPPORTED_SYNTAX_MSG_KEY = "QueryBuilderEditorPanel_UnsupportedSyntaxMsg";
    private static final String CONN_NOT_SUPPORTED_MSG = ControlsArb.getString("QueryBuilderEditorPanel_NotSupportedMsg");
    private static final String CONN_NULL_MSG = ControlsArb.getString("QueryBuilderEditorPanel_NullConnectionMsg");
    private static final String MESSAGE_DIALOG_TITLE = ControlsArb.getString("QueryBuilderEditorPanel_MessageDialogTitle");
    private static final String SORT_FIELDS_MENU_TEXT = ControlsArb.getString("QueryBuilderEditorPanel_SortFieldsMenuText");
    private static final String CREATE_ORACLE_JOINS_MENU_TEXT = ControlsArb.getString("QueryBuilderEditorPanel_CreatOracleJoinsMenuText");
    private static Cursor BUSY_CURSOR = null;
    private boolean componentShown;
    private boolean textChanged;
    private DocumentListener _textListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            QBQLEditPanel.this.textChanged = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            QBQLEditPanel.this.textChanged = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    private JTextComponent _textComponent;
    private BasicEditorPane qbqlPane = new BasicEditorPane();

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void info(String string) {
        LOGGER.log(Level.INFO, string);
    }

    public QBQLEditPanel(JTextComponent jTextComponent) {
        assert (jTextComponent != null);
        this.setTextComponent(jTextComponent);
    }

    public void dispose() {
        this._textComponent.getDocument().removeDocumentListener(this._textListener);
        this._textComponent = null;
        this._textListener = null;
    }

    private void setTextComponent(JTextComponent jTextComponent) {
        this._textComponent = jTextComponent;
        this._textComponent.getDocument().addDocumentListener(this._textListener);
    }

    private void setText(String string) {
        if (this._textComponent != null) {
            this._textComponent.setText(string);
        }
    }

    private String getText() {
        if (this._textComponent != null) {
            return this._textComponent.getText();
        }
        return null;
    }

    public Component getGUI() {
        return this.qbqlPane;
    }
}

