/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.grid.FilterableColumnHeaderCellRenderer;
import oracle.dbtools.raptor.controls.grid.FilteringJListItem;
import oracle.dbtools.raptor.controls.grid.RSTModelFactory;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellEditor;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellRenderer;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.ExportGrid;
import oracle.dbtools.raptor.controls.grid.contextmenu.FilterGrid;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.PublishQueryToApexApplication;
import oracle.dbtools.raptor.controls.grid.contextmenu.RemoveGridFilter;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;

public class ResultSetTable
extends RaptorGridTable {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(ResultSetTable.class.getName());
    private static IResultSetTableDrillDown _drillDown;
    private static boolean _initedStatics;
    private static Preferences prefs;
    private static FontSizeOptions fontSizeOptions;

    private void initStatics() {
        if (!_initedStatics) {
            ResultSetTable.addGridContextMenu((GridContextMenuItem)ExportGrid.getInstance());
            ResultSetTable.addGridContextMenu((GridContextMenuItem)PublishQueryToApexApplication.getInstance());
            ResultSetTable.addGridContextMenu((GridContextMenuItem)RemoveGridFilter.getInstance());
            ResultSetTable.addColumnHeaderContextMenu((GridHeaderContextMenuItem)FilterGrid.getInstance());
            ResultSetTable.addColumnHeaderContextMenu((GridHeaderContextMenuItem)RemoveGridFilter.getInstance());
            _initedStatics = true;
        }
    }

    public ResultSetTable() {
        this.initStatics();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ResultSetTable.this.drillDown();
                }
            }
        });
        if (fontSizeOptions != null) {
            Font font = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
            this.setFont(font);
            fontSizeOptions.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    Font font = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
                    ResultSetTable.this.setFont(font);
                }
            });
        }
        DBConfig.getInstance().addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    if (!"ZEBRA_ROWS".equals(changeInfo.getPropertyName())) continue;
                    Object object = changeInfo.getNewValue();
                    ResultSetTable.this.setDefault("ZEBRA_ROWS", object != null ? object.toString() : null);
                }
            }
        });
    }

    public ResultSetTable(String string) {
        this();
        this.setName(string);
    }

    protected void setDefault(String string, String string2) {
        super.setDefault(string, string2);
    }

    public void initializeDefaults(Properties properties) {
        properties.setProperty("ZEBRA_ROWS", DBConfig.getInstance().getString("ZEBRA_ROWS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drillDown() {
        if (_drillDown != null && this.getModel() instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)((Object)this.getModel());
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            if ((n = this.convertRowIndexToModel(n)) > -1 && resultSetTableModel.getDrillUrls().size() > n) {
                URL uRL = resultSetTableModel.getDrillUrls().get(n).getUrl();
                String string = resultSetTableModel.getDrillUrls().get(n).getRow();
                DatabaseNode databaseNode = null;
                try {
                    databaseNode = DatabaseNavigatorElementFactory.getObjectNode(uRL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (databaseNode != null) {
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    try {
                        if (waitCursor != null) {
                            waitCursor.show();
                        }
                        _drillDown.performDrill(databaseNode, string);
                    }
                    finally {
                        if (waitCursor != null) {
                            waitCursor.hide();
                        }
                    }
                }
            }
        }
    }

    public static synchronized void setDrillDown(IResultSetTableDrillDown iResultSetTableDrillDown) {
        _drillDown = iResultSetTableDrillDown;
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map) {
        ResultSetTableModel resultSetTableModel = RSTModelFactory.getResultSetTableModel(string2, string, list, map);
        resultSetTableModel.setVerticalDisplay(this.isVerticalDisplay());
        this.setModel((TableModel)((Object)resultSetTableModel));
    }

    public void open(RaptorGridTaskWrapper raptorGridTaskWrapper) throws ExecutionException {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            resultSetTableModel.open(raptorGridTaskWrapper);
        } else {
            this.logger.severe(RSTableMessages.getString("ResultSetTable.0"));
        }
    }

    public void open(boolean bl) throws ExecutionException {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            if (bl) {
                RaptorGridTaskWrapper raptorGridTaskWrapper = new RaptorGridTaskWrapper(Messages.getString("DisplayPanel.32"), IRaptorTaskRunMode.MODAL);
                resultSetTableModel.open(raptorGridTaskWrapper);
            } else {
                resultSetTableModel.open(null);
            }
        } else {
            this.logger.severe(RSTableMessages.getString("ResultSetTable.0"));
        }
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            resultSetTableModel.registerConsumer(iStatusMessageConsumer);
        } else {
            this.logger.fine(iStatusMessageConsumer + RSTableMessages.getString("ResultSetTable.1"));
        }
    }

    public void unRegisterConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            resultSetTableModel.unRegisterConsumer(iStatusMessageConsumer);
        } else {
            this.logger.fine(iStatusMessageConsumer + RSTableMessages.getString("ResultSetTable.1"));
        }
    }

    public ResultSetTableModel getGridModel() {
        if (this.getModel() instanceof ResultSetTableModel) {
            return (ResultSetTableModel)((Object)this.getModel());
        }
        return null;
    }

    public String getDefaultExportName() {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        String string = null;
        if (resultSetTableModel != null && resultSetTableModel._tablename != null) {
            string = resultSetTableModel._tablename.replaceAll("\"", "");
        }
        return string;
    }

    public void addColumn(TableColumn tableColumn) {
        tableColumn.setCellRenderer(new ResultSetTableCellRenderer());
        tableColumn.setCellEditor(new ResultSetTableCellEditor(this));
        super.addColumn(tableColumn);
        tableColumn.setHeaderRenderer((TableCellRenderer)((Object)FilterableColumnHeaderCellRenderer.INSTANCE));
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        Component component = this.getEditorComponent();
        if (component != null && component instanceof RaptorTableEditorJPanel && eventObject instanceof KeyEvent) {
            JComponent jComponent = ((RaptorTableEditorJPanel)component).getEditorDelegate().getEditor();
            KeyEvent keyEvent = (KeyEvent)eventObject;
            char c = keyEvent.getKeyChar();
            String string = null;
            string = Character.isISOControl(c) ? "" : Character.toString(c);
            if (jComponent instanceof RaptorTableEditorTextField) {
                RaptorTableEditorTextField raptorTableEditorTextField = (RaptorTableEditorTextField)jComponent;
                raptorTableEditorTextField.setText(string);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FilteringJListItem> getLoadedRowsForColumn(int n) {
        ArrayList<FilteringJListItem> arrayList = new ArrayList<FilteringJListItem>();
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            int n2 = this.convertColumnIndexToModel(n);
            ResultSetGridColumn resultSetGridColumn = resultSetTableModel.getGridColumns().get(n2);
            String string = resultSetGridColumn.getOriginal();
            try {
                RaptorGridFilter raptorGridFilter;
                if (string.equals(resultSetGridColumn.getAlias()) && ((raptorGridFilter = resultSetTableModel.getFilter(n2)) == null || !raptorGridFilter.isEnabled())) {
                    int n3 = this.getColumnModel().getColumn(n).getWidth();
                    for (int i = 0; i < resultSetTableModel.getLoadedRowCount(); ++i) {
                        RaptorGridCell raptorGridCell = (RaptorGridCell)resultSetTableModel.getRowModel(i).getRow().get(n2);
                        Connection connection = this.getConnection();
                        String string2 = raptorGridCell.getDisplayValue(n3);
                        Object object = raptorGridCell.getCellData();
                        String string3 = DataTypesUtil.toSQLStringValue((Connection)connection, (FormatType)FormatType.GENERIC, (Object)object, (Object)string2);
                        String string4 = this.addEqualityPredicate(DataTypesUtil.toSQLSyntax((Connection)connection, (FormatType)FormatType.GENERIC, (Object)object, (Object)string2));
                        FilteringJListItem filteringJListItem = new FilteringJListItem(raptorGridCell.getDisplayValue(n3), raptorGridCell.getCellData(), i, string3, string4);
                        if (arrayList.contains(filteringJListItem)) continue;
                        arrayList.add(filteringJListItem);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected String addEqualityPredicate(String string) {
        String string2 = string;
        if (string != null && string.length() != 0) {
            string2 = string.equalsIgnoreCase("NULL") ? "IS " + string : "= " + string;
        }
        return string2;
    }

    public String getCurrentSql() {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (resultSetTableModel != null) {
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string;
                String string2 = string = this.getColumnName(i);
                DBUtil dBUtil = null;
                try {
                    dBUtil = DBUtil.getInstance((String)resultSetTableModel.getConnectionName());
                    string2 = dBUtil.addDbQuotes(string);
                }
                catch (Exception exception) {
                    string2 = DBUtil.addDoubleQuote((String)string);
                }
                stringBuilder.append(string2 + ", ");
            }
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), " FROM");
            stringBuilder.append("(\n");
            stringBuilder.append(resultSetTableModel.getModifiedSql());
            stringBuilder.append("\n)");
            return stringBuilder.toString();
        }
        return null;
    }

    public boolean canAutoFilter(int n) {
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 > -1 && resultSetTableModel != null) {
            int n3 = resultSetTableModel.getColumnSqlType(n2);
            return DataTypesUtil.canAutoFilter((int)n3) && super.canAutoFilter(n);
        }
        return false;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new FilterableColumnHeader(this.columnModel);
    }

    private Connection getConnection() {
        String string = this.getGridModel().getConnectionName();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string, false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return connection;
    }

    protected Component overlayValueColor(Component component, int n, int n2) {
        Color color;
        Color color2 = component != null ? component.getForeground() : null;
        Color color3 = component != null ? component.getBackground() : null;
        component = super.overlayValueColor(component, n, n2);
        Color color4 = component != null ? component.getForeground() : null;
        Color color5 = component != null ? component.getBackground() : null;
        ResultSetTableModel resultSetTableModel = this.getGridModel();
        if (!this.isCellSelected(n, n2) && resultSetTableModel != null && component != null && this.getValueAt(n, n2) == null && (color = ResultSetTable.getNullColor()) != null) {
            if (ModelUtil.areEqual((Object)color3, (Object)color5)) {
                component.setBackground(color);
            } else if (ModelUtil.areEqual((Object)color2, (Object)color4)) {
                component.setForeground(color);
            }
        }
        return component;
    }

    public static Color getColor(String string) {
        Color color = null;
        if (string != null) {
            if (string.equals("BLUE")) {
                color = Color.BLUE;
            } else if (string.equals("GRAY")) {
                color = Color.GRAY;
            } else if (string.equals("LIGHT_GRAY")) {
                color = Color.LIGHT_GRAY;
            } else if (string.equals("BLACK")) {
                color = Color.BLACK;
            } else if (string.equals("RED")) {
                color = Color.RED;
            } else if (string.equals("PINK")) {
                color = Color.PINK;
            } else if (string.equals("ORANGE")) {
                color = Color.ORANGE;
            } else if (string.equals("YELLOW")) {
                color = Color.YELLOW;
            } else if (string.equals("GREEN")) {
                color = Color.GREEN;
            }
        }
        return color;
    }

    public static Color getNullColor() {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("NULLCOLOR");
        if (string == null) {
            string = "NONE";
            dBConfig.putString("NULLCOLOR", string);
        }
        return ResultSetTable.getColor(string);
    }

    static {
        prefs = Preferences.getPreferences();
        fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)prefs);
    }

    protected class FilterableColumnHeader
    extends RaptorGridTable.GridColumnHeader
    implements MouseMotionListener,
    MouseListener {
        private int viewCol;

        public FilterableColumnHeader(TableColumnModel tableColumnModel) {
            super((RaptorGridTable)ResultSetTable.this, tableColumnModel);
            this.viewCol = -1;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            if (this.canDoFilter(mouseEvent) && this.inFilterIcon(n, mouseEvent)) {
                string = RSTableMessages.getString("ResultSetTable.2");
            } else {
                RaptorGridFilter raptorGridFilter;
                ResultSetTableModel resultSetTableModel = ResultSetTable.this.getGridModel();
                int n2 = ResultSetTable.this.convertColumnIndexToModel(n);
                if (resultSetTableModel != null && n2 != -1 && (raptorGridFilter = resultSetTableModel.getFilter(n2)) != null && raptorGridFilter.isEnabled()) {
                    string = raptorGridFilter.getDescription();
                }
            }
            return string;
        }

        public void setViewCol(int n) {
            if (this.viewCol != n) {
                this.viewCol = n;
                this.repaint();
            }
        }

        public int getViewCol() {
            return this.viewCol;
        }

        private int getMouseColumn(MouseEvent mouseEvent) {
            return this.columnAtPoint(mouseEvent.getPoint());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setViewCol(this.getMouseColumn(mouseEvent));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setViewCol(-1);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.setViewCol(-1);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.setViewCol(this.getMouseColumn(mouseEvent));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.canDoFilter(mouseEvent) && this.inFilterIcon(this.viewCol, mouseEvent)) {
                FilterGrid.getInstance().setTable(ResultSetTable.this);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FilterGrid.getInstance().showFilterPanel(ResultSetTable.this, FilterableColumnHeader.this.viewCol);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setViewCol(this.getMouseColumn(mouseEvent));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setViewCol(this.getMouseColumn(mouseEvent));
        }

        protected boolean canDoFilter(MouseEvent mouseEvent) {
            TableColumn tableColumn;
            if (!ResultSetTable.this.isVerticalDisplay() && mouseEvent.getClickCount() != 2 && !mouseEvent.isPopupTrigger() && (tableColumn = ResultSetTable.this.getTableHeader().getResizingColumn()) == null) {
                int n = this.columnAtPoint(mouseEvent.getPoint());
                return ResultSetTable.this.canAutoFilter(n);
            }
            return false;
        }

        private boolean inFilterIcon(int n, MouseEvent mouseEvent) {
            double d;
            double d2 = mouseEvent.getPoint().x;
            Rectangle rectangle = this.getHeaderRect(n);
            double d3 = (double)rectangle.getLocation().x + rectangle.getWidth();
            return d2 >= d3 - (d = this.getPreferredSize().getHeight()) && d2 <= d3;
        }
    }
}

