/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIDBAccessSafe;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.DBGridRowModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.GridColumnHighlightParameter;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.UniqueArrayList;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class EditableResultSetTableModel
extends ResultSetTableModel {
    protected boolean _columnsResolved = false;
    protected List<String> DATA_INTEGRITY_COLS = Arrays.asList("ROWID", "ORA_ROWSCN");
    protected String _schemaName = null;
    protected DBObject _dbObject = null;
    protected String _customTableName = null;
    protected String _expandedSql = null;
    protected boolean _addRowIdColumn = true;
    protected boolean _addRowScnColumn = true;
    protected String _nlsDateFormat;
    protected OraDATEFormat _dFormat;
    protected OraTIMESTAMPFormat _tsFormat;
    protected OraTIMESTAMPLTZFormat _tsltzFormat;
    protected OraTIMESTAMPTZFormat _tstzFormat;
    protected String _nlsCharSet;
    protected String _nlsLang;
    protected String _nlsDateLang;
    protected String _nlsTerritory;
    protected List<String> _log;
    protected int numberOfSaveErrors = 0;
    SaveTaskListener _saveTaskListener = null;
    protected RaptorTask<Integer> _saveTask;
    protected boolean _isCommited = true;
    protected LogPage _logPage = null;
    protected static DBConfig dbConfig = null;
    protected static boolean DML_DEFER_COMMIT_DEFER = true;
    protected static boolean DML_IMMIDIATE_COMMIT_DEFER = false;
    protected static boolean DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
    protected static boolean Preference_USE_SCN = true;
    protected IRaptorGridUpdater _gridUpdater = null;
    protected List<String> _uneditableColumns = null;
    protected List<String> _editableColNames = null;
    protected List<Integer> _uneditableRows = null;

    public Object formatDisplayValueAt(String string, int n, int n2) {
        try {
            Format format = NLSUtils.getFormat((Connection)this.getConnection(), (int)this.getColumnSqlType(n2), (FormatType)FormatType.PREFERRED);
            if (string != null && format != null) {
                return format.parseObject(string);
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        RaptorGridRowModel raptorGridRowModel = this.getRowModel(n);
        if (raptorGridRowModel != null) {
            RaptorGridCell raptorGridCell = (RaptorGridCell)raptorGridRowModel.getRow().get(n2);
            Connection connection = null;
            try {
                connection = this.getConnection();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            GridCellUpdateInfo gridCellUpdateInfo = null;
            if (connection != null) {
                Object object2 = raptorGridCell.getCellData();
                if (object2 == null && (object == null || object.toString().length() == 0)) {
                    return;
                }
                if (!DataTypesUtil.isEqual((Object)object2, (Object)object, (Connection)connection, (int)this.getColumnSqlType(n2))) {
                    if (object instanceof String && ((String)object).length() == 0 && DataTypesUtil.isTemporalType((Object)object, (int)this.getColumnSqlType(n2))) {
                        object = null;
                    }
                    raptorGridCell.setCellData(object);
                    if (this._gridUpdater != null) {
                        gridCellUpdateInfo = this._gridUpdater.cellUpdated(this._connName, raptorGridRowModel, n, n2, object2);
                    }
                }
                if (gridCellUpdateInfo == null) {
                    this.fireTableCellUpdated(n, n2);
                    this.getRowHeaderModel().fireTableCellUpdated(n, 0);
                } else if (gridCellUpdateInfo.isUpdateHandeled()) {
                    Exception exception = gridCellUpdateInfo.getUpdateException();
                    if (exception != null) {
                        raptorGridRowModel.setError(RaptorTaskUtils.getErrorMessage((Throwable)exception));
                        this.fireTableCellUpdated(n, n2);
                        this.getRowHeaderModel().fireTableCellUpdated(n, 0);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)RaptorTaskUtils.getErrorMessage((Throwable)exception), (String)"Update Failed", null);
                    } else {
                        if (gridCellUpdateInfo.needsCommit()) {
                            this.commit();
                        }
                        try {
                            this.refresh();
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                        }
                    }
                } else {
                    this.fireTableCellUpdated(n, n2);
                    this.getRowHeaderModel().fireTableCellUpdated(n, 0);
                }
            }
        }
    }

    @Override
    protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
        super.init(string, string2, list, map);
        this.fecthTableName();
        this._rstmsql.setTableName(this._tablename);
        this._log = new ArrayList<String>();
        dbConfig = DBConfig.getInstance();
        EditableResultSetTableModel.setCommitProps();
        dbConfig.addStructureChangeListener(new OVPreferenceChangeListener());
        Preference_USE_SCN = dbConfig.getBoolean("DATAEDITOR_USE_SCN");
    }

    protected void init(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        this._dbObject = dBObject;
        this.init(string, string2, list, map);
    }

    @Override
    public void setSkipCols(List<String> list) {
        super.setSkipCols(list);
        for (String string : this.DATA_INTEGRITY_COLS) {
            this._skipCols.add(string);
        }
    }

    void setUneditableColumns(List<String> list) {
        this._uneditableColumns = list;
    }

    void setEditableColumns(List<String> list) {
        this._editableColNames = list;
    }

    void setUneditableRows(List<Integer> list) {
        this._uneditableRows = list;
    }

    public void setDataIntegrityColumnNames(List<String> list) {
        this.DATA_INTEGRITY_COLS = list;
    }

    protected void fecthTableName() {
        if (this._dbObject != null) {
            DBUtil dBUtil = DBUtil.getInstance((String)this._dbObject.getConnectionName());
            this._schemaName = dBUtil.addDbQuotes(this._dbObject.getSchemaName());
            this._tablename = dBUtil.addDbQuotes(this._dbObject.getObjectName());
        } else {
            int n;
            int n2 = this._sql.toLowerCase().indexOf("from");
            if (n2 < 0) {
                this._tablename = "";
            } else {
                this._tablename = this._sql.substring(n2 + "from".length(), this._sql.length()).trim();
                this._tablename = this._tablename.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
                n = this._tablename.indexOf(" ");
                if (n > 0) {
                    this._tablename = this._tablename.substring(0, n + 1).trim();
                }
            }
            if (ModelUtil.hasLength((String)this._tablename) && (n = this._tablename.indexOf(".")) > 0) {
                this._schemaName = this._tablename.substring(0, n);
                this._tablename = this._tablename.substring(n + 1, this._tablename.length());
            }
        }
    }

    public boolean addRow(int n) {
        return this.addRow(n, null);
    }

    public boolean addRow(int n, RaptorGridRowModel raptorGridRowModel) {
        boolean bl = true;
        if (raptorGridRowModel == null) {
            raptorGridRowModel = DBGridRowModel.getNewRow(this, this._connName);
        }
        raptorGridRowModel.setNew();
        this.addRowImpl(n, raptorGridRowModel);
        this.fireTableDataChanged();
        this.getRowHeaderModel().fireTableDataChanged();
        ArrayList<RaptorGridRowModel> arrayList = new ArrayList<RaptorGridRowModel>();
        arrayList.add(raptorGridRowModel);
        return bl;
    }

    public AbstractRaptorGridModel.RowHeaderTableModel getRowHeaderModel() {
        if (this._rowHeaderModel == null) {
            this._rowHeaderModel = new RowHeaderERSTM();
        }
        return this._rowHeaderModel;
    }

    public RaptorGridRowModel getRowModel(int n) {
        return super.getRowModel(n);
    }

    @Override
    protected ResultSet openResultSet() throws SQLException, DBException {
        return super.openResultSet();
    }

    @Override
    @UIDBAccessSafe
    public void closeModel() {
        this._columnsResolved = false;
        this._addRowIdColumn = true;
        this._addRowScnColumn = true;
        this.numberOfSaveErrors = 0;
        super.closeModel();
    }

    @Override
    public String getModifiedSql() {
        return this._sql;
    }

    @Override
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        String string = this.getModifiedSql();
        PreparedStatement preparedStatement = null;
        if (ModelUtil.hasLength((String)string)) {
            preparedStatement = this.getConnection().prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            if (this.getBindList() != null && this.getBindList().size() > 0) {
                DBUtil.bind((PreparedStatement)preparedStatement, this.getBindList());
            } else if (this.getBindMap() != null && this.getBindMap().size() > 0) {
                DBUtil.bind((String)string, (PreparedStatement)preparedStatement, this.getBindMap());
            }
        }
        return preparedStatement;
    }

    @Override
    public List<ResultSetGridColumn> getGridColumns() {
        if (this.gridColumns == null && this._rs != null && !this.isVerticalDisplay()) {
            this.gridColumns = new ArrayList();
            try {
                for (String string : this.DATA_INTEGRITY_COLS) {
                    this._skipCols.add(string);
                }
                ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    boolean bl = false;
                    if (this._skipCols.contains(string)) {
                        bl = true;
                    }
                    ResultSetGridColumn resultSetGridColumn = new ResultSetGridColumn(string, bl, resultSetMetaData.getColumnType(i), resultSetMetaData.getColumnTypeName(i));
                    if (this._highlightCols.contains(string.toUpperCase())) {
                        resultSetGridColumn.setSkipped(true);
                        resultSetGridColumn.setHighlightParameter(new GridColumnHighlightParameter(string.toUpperCase(), Color.CYAN));
                    }
                    if (!bl && this._editableColNames != null && (this._editableColNames.contains(string) || this._editableColNames.size() == 1 && this._editableColNames.get(0).equals("*"))) {
                        resultSetGridColumn.setEditable(true);
                    }
                    if (bl || this._uneditableColumns != null && this._uneditableColumns.contains(string)) {
                        resultSetGridColumn.setEditable(false);
                    }
                    if (this._queryObj != null) {
                        List list = this._queryObj.getCols();
                        for (Column column : list) {
                            if (!column.getName().equals(string) || column.isEditable().booleanValue()) continue;
                            resultSetGridColumn.setEditable(false);
                            break;
                        }
                    }
                    this.gridColumns.add(resultSetGridColumn);
                }
            }
            catch (SQLException sQLException) {
                this._log.add(sQLException.getLocalizedMessage());
                this.publishStatusMessage(sQLException.getMessage(), sQLException);
            }
            UniqueArrayList.aliasWithDelim((ArrayList)this.gridColumns, (String)"_");
            for (int i = 0; i < this.gridColumns.size(); ++i) {
                ((ResultSetGridColumn)((Object)this.gridColumns.get(i))).setSortable(this.isColumnSortable(i));
            }
            if (this._autoApplyPersistedSort) {
                this.applySavedSort();
            }
        }
        return this.gridColumns;
    }

    public String getColumnSqlTypeName(int n) {
        return this.getGridColumns().get(n).getSqlTypeName();
    }

    @Override
    public int getColumnSqlType(int n) {
        return this.getGridColumns().get(n).getSqlType();
    }

    protected DBObject getDBObject() {
        return this._dbObject;
    }

    public boolean isColumnSortable(int n) {
        boolean bl = super.isColumnSortable(n);
        if (bl) {
            int n2 = this.getColumnSqlType(n);
            switch (n2) {
                case -13: 
                case -10: 
                case -7: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1111: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: 
                case 2011: {
                    Connection connection = null;
                    try {
                        connection = this.getConnection();
                    }
                    catch (DBException dBException) {
                        return false;
                    }
                    if (connection == null) {
                        return false;
                    }
                    ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(this.getConnectionName(), connection);
                    if (connectionTypeDetails == null) {
                        return false;
                    }
                    return connectionTypeDetails.isColumnTypeSortable(this.getColumnSqlType(n));
                }
            }
        }
        return bl;
    }

    public boolean isSortable() {
        return true;
    }

    public void rollback() {
        if (!this._isCommited) {
            try {
                this.getConnection().rollback();
                this._isCommited = true;
                this._log.add(Messages.getString("EditableResultSetTableModel.14"));
            }
            catch (SQLException sQLException) {
                this._log.add(sQLException.getMessage());
                this._log.add(Messages.getString("EditableResultSetTableModel.15"));
            }
            catch (DBException dBException) {
                this._log.add(dBException.getMessage());
                this._log.add(Messages.getString("EditableResultSetTableModel.15"));
            }
        } else {
            this._log.add(Messages.getString("EditableResultSetTableModel.32"));
        }
    }

    protected int insertRows(List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws DBException, SQLException, ExecutionException {
        if (this._gridUpdater != null) {
            return this._gridUpdater.insertRows(this._connName, list, iRaptorTaskProgressUpdater, list2);
        }
        return 0;
    }

    protected int updateRows(List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws DBException, SQLException, ExecutionException {
        if (this._gridUpdater != null) {
            return this._gridUpdater.updateRows(this._connName, list, iRaptorTaskProgressUpdater, list2);
        }
        return 0;
    }

    protected int deleteRows(List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws DBException, SQLException, ExecutionException {
        if (this._gridUpdater != null) {
            return this._gridUpdater.deleteRows(this._connName, list, iRaptorTaskProgressUpdater, list2);
        }
        return 0;
    }

    public boolean isOracle() {
        return Connections.getInstance().isOracle(this.getConnectionName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectRowscn(RaptorGridRowModel raptorGridRowModel) throws DBException {
        String string = this._schemaName + "." + this._tablename;
        String string2 = "SELECT ORA_ROWSCN FROM " + string + " WHERE ROWID = ?";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getConnection().prepareStatement(string2);
            preparedStatement.setString(1, this.getRowId(raptorGridRowModel));
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                return;
            }
            this.setRowScn(raptorGridRowModel, resultSet.getString(1));
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected String quote(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("'", "''");
        return "'" + string2 + "'";
    }

    public boolean save(boolean bl, boolean bl2) {
        if (this._taskWrapper != null && this._taskWrapper instanceof RaptorEditableGridTaskWrapper) {
            RaptorEditableGridTaskWrapper raptorEditableGridTaskWrapper = (RaptorEditableGridTaskWrapper)this._taskWrapper;
            this._saveTask = this.createSaveTask(raptorEditableGridTaskWrapper.getTaskName(), raptorEditableGridTaskWrapper.isDeterminate(), raptorEditableGridTaskWrapper.getTaskRunMode(), bl);
            for (IRaptorTaskListener iRaptorTaskListener : raptorEditableGridTaskWrapper.getSaveRaptorTaskListeners()) {
                this._saveTask.getDescriptor().addListener(iRaptorTaskListener);
            }
            this.submitTask(raptorEditableGridTaskWrapper, this._saveTask);
        }
        if (bl2) {
            try {
                if (this._saveTask == null) {
                    return false;
                }
                int n = (Integer)this._saveTask.getResult();
                if (n > 0) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, nullPointerException.getStackTrace()[0].toString(), nullPointerException);
                return false;
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
                return false;
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                return false;
            }
        }
        return true;
    }

    public int save(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, boolean bl) throws ExecutionException {
        if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.checkCanProceed();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            return 0;
        }
        if (connection != null) {
            if (this.isOracle()) {
                this._nlsDateFormat = NLSUtils.getDateFormat((Connection)connection);
                try {
                    this._dFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat(NLSUtils.getDateFormat((Connection)connection, (FormatType)FormatType.GENERIC));
                }
                catch (Exception exception) {
                    this._dFormat = null;
                }
                try {
                    this._tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat(NLSUtils.getTimeStampFormat((Connection)connection, (FormatType)FormatType.GENERIC));
                }
                catch (Exception exception) {
                    this._tsFormat = null;
                }
                try {
                    this._tsltzFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPLTZFormat(NLSUtils.getTimeStampFormat((Connection)connection, (FormatType)FormatType.GENERIC));
                }
                catch (Exception exception) {
                    this._tsltzFormat = null;
                }
                try {
                    this._tstzFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPTZFormat(NLSUtils.getTimeStampWithTimeZoneFormat((Connection)connection, (FormatType)FormatType.GENERIC));
                }
                catch (Exception exception) {
                    this._tstzFormat = null;
                }
                this._nlsCharSet = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getDBCharset();
                this._nlsLang = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getDBLanguage();
                this._nlsDateLang = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getDBDateLanguage();
                this._nlsTerritory = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getDBTerritory();
            }
        } else {
            return 0;
        }
        this.numberOfSaveErrors = 0;
        int n = 0;
        this._log.clear();
        boolean bl2 = true;
        boolean bl3 = true;
        List<RaptorGridRowModel> list = this.getChangedRows();
        try {
            bl3 = this.getConnection().getAutoCommit();
            this.getConnection().setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ArrayList<RaptorGridRowModel> arrayList = new ArrayList<RaptorGridRowModel>();
            for (int i = 0; i < list.size(); ++i) {
                RaptorGridRowModel raptorGridRowModel = list.get(i);
                raptorGridRowModel.setError(null);
                if (raptorGridRowModel == null || !raptorGridRowModel.isDeleted() || raptorGridRowModel.isNew()) continue;
                arrayList.add(raptorGridRowModel);
            }
            if (arrayList.size() > 0) {
                n += this.deleteRows(arrayList, iRaptorTaskProgressUpdater, this._log);
                list.removeAll(arrayList);
                arrayList.clear();
            }
            ArrayList<RaptorGridRowModel> arrayList2 = new ArrayList<RaptorGridRowModel>();
            for (int i = 0; i < list.size(); ++i) {
                RaptorGridRowModel raptorGridRowModel = list.get(i);
                if (raptorGridRowModel == null || !raptorGridRowModel.isUpdated()) continue;
                arrayList2.add(raptorGridRowModel);
            }
            if (arrayList2.size() > 0) {
                n += this.updateRows(arrayList2, iRaptorTaskProgressUpdater, this._log);
                list.removeAll(arrayList2);
                arrayList2.clear();
            }
            ArrayList<RaptorGridRowModel> arrayList3 = new ArrayList<RaptorGridRowModel>();
            for (int i = 0; i < list.size(); ++i) {
                RaptorGridRowModel raptorGridRowModel = list.get(i);
                if (raptorGridRowModel == null || !raptorGridRowModel.isNew() || raptorGridRowModel.isDeleted()) continue;
                arrayList3.add(raptorGridRowModel);
            }
            if (arrayList3.size() > 0) {
                n += this.insertRows(arrayList3, iRaptorTaskProgressUpdater, this._log);
                list.removeAll(arrayList3);
                arrayList3.clear();
            }
        }
        catch (Exception exception) {
            ++n;
        }
        if (n > 0) {
            bl2 = false;
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (!bl) {
            this.commit();
        } else {
            this._isCommited = false;
        }
        try {
            connection.setAutoCommit(bl3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numberOfSaveErrors = n;
        System.gc();
        return n;
    }

    int getNumberOfErrors() {
        return this.numberOfSaveErrors;
    }

    public List<RaptorGridRowModel> getChangedRows() {
        ArrayList<RaptorGridRowModel> arrayList = new ArrayList<RaptorGridRowModel>();
        for (int i = 0; i < this.getLoadedRowCount(); ++i) {
            RaptorGridRowModel raptorGridRowModel = this.getRowModel(i);
            if (!raptorGridRowModel.isDeleted() && !raptorGridRowModel.isNew() && !raptorGridRowModel.isUpdated()) continue;
            arrayList.add(raptorGridRowModel);
        }
        return arrayList;
    }

    public List<String> getLog() {
        return this._log;
    }

    public String getErrorMessage(int n) {
        RaptorGridRowModel raptorGridRowModel = this.getRowModel(n);
        if (raptorGridRowModel != null) {
            return raptorGridRowModel.getErrorMessage();
        }
        return null;
    }

    public boolean isRowError(int n) {
        RaptorGridRowModel raptorGridRowModel = this.getRowModel(n);
        return raptorGridRowModel != null && raptorGridRowModel.getError();
    }

    public boolean isRowDeleted(int n) {
        RaptorGridRowModel raptorGridRowModel = this.getRowModel(n);
        return raptorGridRowModel != null && raptorGridRowModel.isDeleted();
    }

    public boolean markRowDeleted(int n, boolean bl) {
        boolean bl2 = true;
        RaptorGridRowModel raptorGridRowModel = this.getRowModel(n);
        if (raptorGridRowModel != null) {
            raptorGridRowModel.setDeleted(bl);
            raptorGridRowModel.setError(false);
        }
        this.fireTableDataChanged();
        this.getRowHeaderModel().fireTableDataChanged();
        return true;
    }

    public String getTableName() {
        if (this._customTableName != null) {
            return this._customTableName;
        }
        return this._schemaName != null ? this._schemaName + "." + this._tablename : "" + this._tablename;
    }

    public void setTableName(String string) {
        if (this._gridUpdater != null) {
            this._customTableName = string;
        }
    }

    protected String getRowId(RaptorGridRowModel raptorGridRowModel) {
        return ((RaptorGridCell)raptorGridRowModel.getRow().get(0)).getDisplayValue(Integer.MAX_VALUE);
    }

    protected String getRowScn(RaptorGridRowModel raptorGridRowModel) {
        return ((RaptorGridCell)raptorGridRowModel.getRow().get(1)).getDisplayValue(Integer.MAX_VALUE);
    }

    protected void setRowId(RaptorGridRowModel raptorGridRowModel, String string) {
        ((RaptorGridCell)raptorGridRowModel.getRow().get(0)).setCellData((Object)string);
    }

    protected void setRowScn(RaptorGridRowModel raptorGridRowModel, String string) {
        ((RaptorGridCell)raptorGridRowModel.getRow().get(1)).setCellData((Object)string);
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isCellEditorEditable(int n, int n2) {
        return this.isEditable() && (this._uneditableRows == null || !this._uneditableRows.contains(n)) && this.getGridColumns().get(n2).isEditable();
    }

    public String getFilterClause() {
        return this._rstmsql.getWhereClauseFilter();
    }

    public void setFilterClause(String string) {
        this._rstmsql.setWhereClauseFilter(string);
    }

    protected boolean commit() {
        if (!this.isEditable()) {
            this._isCommited = true;
            return true;
        }
        try {
            this.getConnection().commit();
            this._isCommited = true;
            this._log.add(Messages.getString("EditableResultSetTableModel.28"));
            return true;
        }
        catch (SQLException sQLException) {
            this._log.add(sQLException.getMessage());
            this._log.add(Messages.getString("EditableResultSetTableModel.29"));
        }
        catch (DBException dBException) {
            this._log.add(dBException.getMessage());
            this._log.add(Messages.getString("EditableResultSetTableModel.29"));
        }
        this._isCommited = false;
        return false;
    }

    boolean isChanged() {
        return this.getChangedRows().size() > 0 || !this._isCommited;
    }

    protected RaptorTask<Integer> createSaveTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, final boolean bl2) {
        this._saveTask = new DatabaseQueryTask<Integer>(string, iRaptorTaskRunMode, true, true){

            @Override
            public String getConnectionName() {
                return EditableResultSetTableModel.this.getConnectionName();
            }

            @Override
            public String getQuery() {
                return MessageFormat.format(Messages.getString("EditableResultSetTableModel.31"), EditableResultSetTableModel.this.getTableName());
            }

            protected Integer doWork() throws TaskException {
                int n = 0;
                try {
                    n = EditableResultSetTableModel.this.save(this.getRaptorTaskProgressUpdater(), bl2);
                }
                catch (ExecutionException executionException) {
                    throw new TaskException((Throwable)executionException);
                }
                return n;
            }
        };
        this._saveTask.getDescriptor().addListener((IRaptorTaskListener)this.getSaveTaskListener());
        return this._saveTask;
    }

    SaveTaskListener getSaveTaskListener() {
        if (this._saveTaskListener == null) {
            this._saveTaskListener = new SaveTaskListener();
        }
        return this._saveTaskListener;
    }

    public boolean isBusy() {
        return this._saveTask != null && IRaptorTaskStatus.isAlive((IRaptorTaskStatus)this._saveTask.getStatus()) || this.isTaskRunning();
    }

    void setLogPage(LogPage logPage) {
        this._logPage = logPage;
    }

    protected static void setCommitProps() {
        boolean bl = dbConfig.getBoolean("DATAEDITOR_POSTONROWCHANGE");
        boolean bl2 = dbConfig.getBoolean("DATAEDITOR_AUTOCOMMIT");
        if (!bl) {
            DML_DEFER_COMMIT_DEFER = true;
            DML_IMMIDIATE_COMMIT_DEFER = false;
            DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
        } else if (bl && !bl2) {
            DML_DEFER_COMMIT_DEFER = false;
            DML_IMMIDIATE_COMMIT_DEFER = true;
            DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
        } else if (bl && bl2) {
            DML_DEFER_COMMIT_DEFER = false;
            DML_IMMIDIATE_COMMIT_DEFER = false;
            DML_IMMIDIATE_COMMIT_IMMIDIATE = true;
        }
    }

    public boolean isPostOnRowChange() {
        return DML_IMMIDIATE_COMMIT_DEFER || DML_IMMIDIATE_COMMIT_IMMIDIATE;
    }

    public void registerGridUpdater(IRaptorGridUpdater iRaptorGridUpdater) {
        this._gridUpdater = iRaptorGridUpdater;
    }

    public IRaptorGridUpdater getGridUpdater() {
        return this._gridUpdater;
    }

    public List<String> getEditableColNames() {
        return this._editableColNames;
    }

    public class DataTabGridUpdater
    implements IRaptorGridUpdater {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                Object object;
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (raptorGridRowModel.isNew()) continue;
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                String string2 = EditableResultSetTableModel.this._schemaName + "." + EditableResultSetTableModel.this._tablename;
                stringBuffer.append(string2 + " WHERE ROWID = ");
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                stringBuffer.append("?");
                stringBuffer2.append(EditableResultSetTableModel.this.quote(EditableResultSetTableModel.this.getRowId(raptorGridRowModel)));
                if (EditableResultSetTableModel.this._addRowScnColumn && !EditableResultSetTableModel.this._dbObject.getObjectType().equals("VIEW")) {
                    stringBuffer.append(" AND ORA_ROWSCN = ?");
                    stringBuffer2.append(" AND ORA_ROWSCN = " + EditableResultSetTableModel.this.quote(EditableResultSetTableModel.this.getRowScn(raptorGridRowModel)));
                    object = EditableResultSetTableModel.this.getColumnName(2);
                    String string3 = DBUtil.getInstance((Connection)EditableResultSetTableModel.this.getConnection()).addDbQuotes((String)object);
                    String string4 = " and ( " + string3 + " is null or " + string3 + " is not null )";
                    stringBuffer.append(string4);
                    stringBuffer2.append(string4);
                }
                EditableResultSetTableModel.this._log.add(stringBuffer2.toString());
                object = null;
                try {
                    int n2;
                    object = EditableResultSetTableModel.this.getConnection().prepareStatement(stringBuffer.toString());
                    object.setString(1, EditableResultSetTableModel.this.getRowId(raptorGridRowModel));
                    if (EditableResultSetTableModel.this._addRowScnColumn && !EditableResultSetTableModel.this._dbObject.getObjectType().equals("VIEW")) {
                        object.setString(2, EditableResultSetTableModel.this.getRowScn(raptorGridRowModel));
                    }
                    if ((n2 = object.executeUpdate()) == 1 || n2 != 0) continue;
                    raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_DELETE_ERR") + System.getProperty("line.separator"));
                    ++n;
                }
                catch (SQLException sQLException) {
                    EditableResultSetTableModel.this._log.add(sQLException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    raptorGridRowModel.setError(exception.getLocalizedMessage());
                    ++n;
                }
                finally {
                    try {
                        if (object == null) continue;
                        object.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int insertRows(String var1_1, List<RaptorGridRowModel> var2_2, IRaptorTaskProgressUpdater var3_3, List<String> var4_4) throws SQLException, DBException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                Object object;
                Object object2;
                int n2;
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                ArrayList<ResultSetGridCell> arrayList = new ArrayList<ResultSetGridCell>();
                String string2 = EditableResultSetTableModel.this._schemaName + "." + EditableResultSetTableModel.this._tablename;
                stringBuffer.append(string2 + " SET ");
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                boolean bl = true;
                String string3 = null;
                ResultSetMetaData resultSetMetaData = EditableResultSetTableModel.this._rs.getMetaData();
                int n3 = EditableResultSetTableModel.this.getGridColumns().size();
                int n4 = n3 - (EditableResultSetTableModel.this._addRowIdColumn ? 1 : 0) - (EditableResultSetTableModel.this._addRowScnColumn ? 1 : 0);
                boolean bl2 = EditableResultSetTableModel.this.isOracle();
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = EditableResultSetTableModel.this.getColumnName(n2);
                    if (EditableResultSetTableModel.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                    ResultSetGridCell resultSetGridCell = (ResultSetGridCell)((Object)raptorGridRowModel.getRow().get(n2));
                    object2 = resultSetGridCell.getCellData();
                    String string4 = resultSetGridCell.getDisplayValue(Integer.MAX_VALUE);
                    boolean bl3 = resultSetGridCell.isUpdated();
                    if (object2 instanceof ExtendedType || !bl3) continue;
                    arrayList.add(resultSetGridCell);
                    if (!bl) {
                        stringBuffer.append(", ");
                        stringBuffer2.append(", ");
                    } else {
                        bl = false;
                    }
                    object = "unknown";
                    try {
                        object = EditableResultSetTableModel.this.getColumnSqlTypeName(n2);
                        if (object == null) {
                            object = "unknown";
                        }
                    }
                    catch (Exception exception) {
                        object = "unknown";
                    }
                    try {
                        if (resultSetMetaData instanceof OracleResultSetMetaData && ((OracleResultSetMetaData)resultSetMetaData).isNCHAR(n2 + 1)) {
                            arrayList2.add(arrayList.size());
                        }
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    string3 = DBUtil.getInstance((Connection)EditableResultSetTableModel.this.getConnection()).addDbQuotes(string3, false);
                    if (object2 != null && bl2 && ((String)object).equals("DATE")) {
                        stringBuffer.append(string3 + " = TO_DATE(:v" + n2 + ", '" + EditableResultSetTableModel.this._dFormat.toPattern() + "')");
                        string4 = EditableResultSetTableModel.this._dFormat.format((DATE)object2);
                        stringBuffer2.append(string3 + " = TO_DATE(" + "'" + string4 + "'" + ", '" + EditableResultSetTableModel.this._dFormat.toPattern() + "')");
                        continue;
                    }
                    if (object2 != null && bl2 && ((String)object).equals("TIMESTAMP")) {
                        stringBuffer.append(string3 + " = TO_TIMESTAMP(:v" + n2 + ", '" + EditableResultSetTableModel.this._tsFormat.toPattern() + "')");
                        string4 = EditableResultSetTableModel.this._tsFormat.format((TIMESTAMP)object2);
                        stringBuffer2.append(string3 + " = TO_TIMESTAMP(" + "'" + string4 + "'" + ", '" + EditableResultSetTableModel.this._tsFormat.toPattern() + "')");
                        continue;
                    }
                    if (object2 != null && bl2 && ((String)object).equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                        stringBuffer.append(string3 + " = TO_TIMESTAMP(:v" + n2 + ", '" + EditableResultSetTableModel.this._tsltzFormat.toPattern() + "')");
                        string4 = EditableResultSetTableModel.this._tsltzFormat.format((TIMESTAMPLTZ)object2);
                        stringBuffer2.append(string3 + " = TO_TIMESTAMP(" + "'" + string4 + "'" + ", '" + EditableResultSetTableModel.this._tsltzFormat.toPattern() + "')");
                        continue;
                    }
                    if (object2 != null && bl2 && ((String)object).equals("TIMESTAMP WITH TIME ZONE")) {
                        stringBuffer.append(string3 + " = TO_TIMESTAMP_TZ(:v" + n2 + ", '" + EditableResultSetTableModel.this._tstzFormat.toPattern() + "')");
                        string4 = EditableResultSetTableModel.this._tstzFormat.format((TIMESTAMPTZ)object2);
                        stringBuffer2.append(string3 + " = TO_TIMESTAMP_TZ(" + "'" + string4 + "'" + ", '" + EditableResultSetTableModel.this._tstzFormat.toPattern() + "')");
                        continue;
                    }
                    stringBuffer.append(string3 + (bl2 ? "=:sqldevvalue" : " = ?"));
                    stringBuffer2.append(string3 + " = " + EditableResultSetTableModel.this.quote(string4 == null || string4.length() == 0 ? null : string4));
                }
                String string5 = bl2 ? ":sqldevgridrowid" : "?";
                stringBuffer.append(" WHERE ROWID = " + string5);
                stringBuffer2.append(" WHERE ROWID = " + EditableResultSetTableModel.this.quote(EditableResultSetTableModel.this.getRowId(raptorGridRowModel)));
                if (EditableResultSetTableModel.this._addRowScnColumn && EditableResultSetTableModel.this.getRowScn(raptorGridRowModel) != null) {
                    stringBuffer.append(" AND ORA_ROWSCN = :sqldevgridrowscn");
                    stringBuffer2.append(" AND ORA_ROWSCN = " + EditableResultSetTableModel.this.quote(EditableResultSetTableModel.this.getRowScn(raptorGridRowModel)));
                }
                EditableResultSetTableModel.this._log.add(stringBuffer2.toString());
                object = null;
                try {
                    int n5;
                    Object object3;
                    ResultSetGridCell resultSetGridCell2;
                    object = EditableResultSetTableModel.this.getConnection().prepareStatement(stringBuffer.toString());
                    int n6 = 1;
                    int n7 = 0;
                    for (ResultSetGridCell resultSetGridCell2 : arrayList) {
                        object3 = resultSetGridCell2.getCellData();
                        ResultSetGridColumn resultSetGridColumn = EditableResultSetTableModel.this.getGridColumnForCell(resultSetGridCell2);
                        if (resultSetGridColumn == null) continue;
                        String string6 = "unknown";
                        string6 = resultSetGridColumn.getSqlTypeName();
                        int n8 = resultSetGridColumn.getSqlType();
                        try {
                            if (string6 == null) {
                                string6 = "unknown";
                            }
                        }
                        catch (Exception exception) {
                            string6 = "unknown";
                        }
                        if (object instanceof OraclePreparedStatement) {
                            for (Integer n9 : arrayList2) {
                                ((OraclePreparedStatement)object).setFormOfUse(n9.intValue(), (short)2);
                            }
                        }
                        if (object3 != null && !bl2 && (string6.equals("DATE") || string6.equals("TIMESTAMP"))) {
                            if (object3.toString().length() == 0) {
                                object.setNull(n6, n8);
                            } else {
                                object.setString(n6, object3.toString());
                            }
                        } else if (object3 != null && bl2 && string6.equals("DATE")) {
                            object.setString(n6, EditableResultSetTableModel.this._dFormat.format((DATE)object3));
                        } else if (object3 != null && bl2 && string6.equals("TIMESTAMP")) {
                            object.setString(n6, EditableResultSetTableModel.this._tsFormat.format((TIMESTAMP)object3));
                        } else if (object3 != null && bl2 && string6.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            object.setString(n6, EditableResultSetTableModel.this._tsltzFormat.format((TIMESTAMPLTZ)object3));
                        } else if (object3 != null && bl2 && string6.equals("TIMESTAMP WITH TIME ZONE")) {
                            object.setString(n6, EditableResultSetTableModel.this._tstzFormat.format((TIMESTAMPTZ)object3));
                        } else if (object3 != null && (string6.equals("BINARY_FLOAT") || string6.equals("NUMBER")) && object3.toString().toLowerCase().endsWith("f")) {
                            object.setFloat(n6, Float.parseFloat(object3.toString()));
                        } else if (object3 != null && string6.equals("CLOB")) {
                            if (bl2) {
                                try {
                                    ((OraclePreparedStatement)object).setStringForClob(n6, object3.toString());
                                }
                                catch (Exception exception) {
                                    object.setString(n6, object3.toString());
                                }
                            }
                        } else if (object3 == null || object3.toString().length() == 0) {
                            if (DataTypesUtil.isExtendedType(null, (int)n8)) {
                                object.setNull(n6, n8, string6);
                            } else {
                                object.setNull(n6, n8);
                            }
                        } else {
                            object.setString(n6, object3.toString());
                        }
                        ++n6;
                        ++n7;
                    }
                    object.setString(n6, EditableResultSetTableModel.this.getRowId(raptorGridRowModel));
                    ++n6;
                    if (EditableResultSetTableModel.this._addRowScnColumn && EditableResultSetTableModel.this.getRowScn(raptorGridRowModel) != null) {
                        object.setString(n6, EditableResultSetTableModel.this.getRowScn(raptorGridRowModel));
                    }
                    if (arrayList.size() > 0) {
                        n5 = object.executeUpdate();
                        if (n5 == 1) {
                            for (n2 = 0; n2 < n3; ++n2) {
                                string3 = EditableResultSetTableModel.this.getColumnName(n2);
                                if (EditableResultSetTableModel.this.DATA_INTEGRITY_COLS.contains(string3) || !((object2 = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData()) instanceof ExtendedType)) continue;
                                resultSetGridCell2 = (ExtendedType)object2;
                                object3 = DBUtil.getInstance((String)EditableResultSetTableModel.this.getConnectionName()).addDbQuotes(EditableResultSetTableModel.this.getColumnName(n2), false);
                                if (resultSetGridCell2.saveToDb(EditableResultSetTableModel.this.getConnection(), string2, (String)object3, EditableResultSetTableModel.this.getRowId(raptorGridRowModel), EditableResultSetTableModel.this.getRowScn(raptorGridRowModel), EditableResultSetTableModel.this._addRowScnColumn, EditableResultSetTableModel.this._log)) continue;
                                ++n;
                            }
                            continue;
                        }
                        if (n5 != 0) continue;
                        raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_UPDATE_ERR") + System.getProperty("line.separator"));
                        ++n;
                        continue;
                    }
                    n5 = 0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        string3 = EditableResultSetTableModel.this.getColumnName(n2);
                        if (EditableResultSetTableModel.this.DATA_INTEGRITY_COLS.contains(string3) || !((object2 = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData()) instanceof ExtendedType)) continue;
                        resultSetGridCell2 = (ExtendedType)object2;
                        object3 = DBUtil.getInstance((String)EditableResultSetTableModel.this.getConnectionName()).addDbQuotes(EditableResultSetTableModel.this.getColumnName(n2), false);
                        n5 = resultSetGridCell2.saveToDb(EditableResultSetTableModel.this.getConnection(), string2, (String)object3, EditableResultSetTableModel.this.getRowId(raptorGridRowModel), EditableResultSetTableModel.this.getRowScn(raptorGridRowModel), EditableResultSetTableModel.this._addRowScnColumn, EditableResultSetTableModel.this._log) ? 1 : 0;
                    }
                    if (n5 != 0) continue;
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), EditableResultSetTableModel.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), EditableResultSetTableModel.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (SQLException sQLException) {
                    EditableResultSetTableModel.this._log.add(sQLException.getLocalizedMessage());
                    raptorGridRowModel.setError(sQLException.getLocalizedMessage());
                    ++n;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    ++n;
                }
                finally {
                    try {
                        if (object == null) continue;
                        object.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        @Override
        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            return null;
        }

        @Override
        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    protected static class OVPreferenceChangeListener
    extends StructureChangeListener {
        protected OVPreferenceChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                String string = changeInfo.getPropertyLocalName();
                if ("DATAEDITOR_POSTONROWCHANGE".equals(string) || "DATAEDITOR_AUTOCOMMIT".equals(string)) {
                    EditableResultSetTableModel.setCommitProps();
                }
                if (!"DATAEDITOR_USE_SCN".equals(string)) continue;
                Preference_USE_SCN = dbConfig.getBoolean("DATAEDITOR_USE_SCN");
            }
        }
    }

    protected class SaveTaskListener
    extends RaptorTaskAdapter {
        protected SaveTaskListener() {
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        int n = 1;
                        if (EditableResultSetTableModel.this._saveTask != null && !IRaptorTaskStatus.isAlive((IRaptorTaskStatus)EditableResultSetTableModel.this._saveTask.getDescriptor().getStatus())) {
                            n = (Integer)EditableResultSetTableModel.this._saveTask.getResult();
                        }
                        if (n <= 0) {
                            EditableResultSetTableModel.this.refresh();
                        }
                    }
                    catch (ExecutionException executionException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected class RowHeaderERSTM
    extends AbstractRaptorGridModel.RowHeaderTableModel {
        protected RowHeaderERSTM() {
            super((AbstractRaptorGridModel)EditableResultSetTableModel.this);
        }

        public Object getValueAt(int n, int n2) {
            Object object = super.getValueAt(n, n2);
            RaptorGridRowModel raptorGridRowModel = EditableResultSetTableModel.this.getRowModel(n);
            if (raptorGridRowModel != null) {
                if (raptorGridRowModel.isNew()) {
                    return "+" + object;
                }
                if (raptorGridRowModel.isDeleted()) {
                    return "-" + object;
                }
                if (raptorGridRowModel.isUpdated()) {
                    return "*" + object;
                }
            }
            return object;
        }
    }
}

