/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RSTModelFactory;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridCopyAdapter;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellRenderer;
import oracle.dbtools.raptor.controls.grid.contextmenu.DuplicateRow;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.extendedtype.ExtendedTypeFactory;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.Ide;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.resource.IdeArb;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.actiontip.ActionTipManager;
import oracle.javatools.ui.actiontip.ActionTipTask;
import oracle.javatools.ui.actiontip.DefaultActionTipComponent;

public class EditableResultSetTable
extends ResultSetTable {
    private static DataEditorLogPage _logPage;
    protected boolean success = true;
    private ErrorTip errTip = new ErrorTip();
    private JTable _rowHeader = null;
    private IActionUpdater actionUpdater = null;
    private SaveMessageShower saveTaskListener = null;
    private Timer _timer;
    private boolean _canPostDMLs = false;
    private static boolean _initStatics;
    private boolean _isInsertAllowed = true;
    private boolean _isDeleteAllowed = true;
    private boolean _isRefreshAllowed = true;
    private boolean _isFilterFieldAllowed = true;
    private boolean _isCommitActionAllowed = true;
    private boolean _isRollbackActionAllowed = true;
    protected EditableGridController _controller = null;
    protected FetchTaskListener fetchTaskListener = null;
    private EditableResultSetTableModel _setQueryRSTM;

    public EditableResultSetTable(IActionUpdater iActionUpdater) {
        this._editable = true;
        this.initStatics();
        if (iActionUpdater == null) {
            throw new IllegalArgumentException();
        }
        this.saveTaskListener = new SaveMessageShower();
        this.fetchTaskListener = new FetchTaskListener();
        this.actionUpdater = iActionUpdater;
        this._copyAdapter = new RaptorGridCopyAdapter(this){

            protected boolean valueCanBePasted(int n, int n2) {
                if (super.valueCanBePasted(n, n2)) {
                    int n3 = EditableResultSetTable.this.getGridModel().getColumnSqlType(EditableResultSetTable.this.convertColumnIndexToModel(n2));
                    return !DataTypesUtil.isExtendedType(null, (int)n3);
                }
                return false;
            }
        };
        this._timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditableResultSetTable.this._canPostDMLs) {
                    EditableResultSetTable.this.getGridModel();
                    EditableResultSetTable.this.save(!EditableResultSetTableModel.DML_IMMIDIATE_COMMIT_IMMIDIATE, false);
                    EditableResultSetTable.this._canPostDMLs = false;
                }
                EditableResultSetTable.this.actionUpdater.updateActions();
            }
        });
        this._timer.setRepeats(false);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditableResultSetTable.this.getGridModel() != null && !EditableResultSetTable.this.getGridModel().isBusy() && !listSelectionEvent.getValueIsAdjusting() && EditableResultSetTable.this.isChanged() && EditableResultSetTable.this.getGridModel().isPostOnRowChange()) {
                    int n = EditableResultSetTable.this.getSelectedRow();
                    EditableResultSetTable.this._canPostDMLs = !EditableResultSetTable.this.getGridModel().isBusy() && EditableResultSetTable.this.getGridModel().getChangedRows().size() > 0 && n != -1 && !EditableResultSetTable.this.isRowError(n) && n != -1 && !EditableResultSetTable.this.isNewRow(n);
                    if (EditableResultSetTable.this._timer.isRunning()) {
                        EditableResultSetTable.this._timer.stop();
                    }
                    EditableResultSetTable.this._timer.start();
                }
            }
        });
        this._controller = new EditableGridController();
        this._controller.setGrid(this);
    }

    public EditableGridController getController() {
        return this._controller;
    }

    public void open(RaptorEditableGridTaskWrapper raptorEditableGridTaskWrapper) throws ExecutionException {
        List<IRaptorTaskListener> list = raptorEditableGridTaskWrapper.getSaveRaptorTaskListeners();
        if (this.isEditable() && !list.contains((Object)this.saveTaskListener)) {
            list.add((IRaptorTaskListener)this.saveTaskListener);
        }
        Collections.reverse(list);
        List list2 = raptorEditableGridTaskWrapper.getRaptorTaskListeners();
        if (this.isEditable() && !list2.contains((Object)this.fetchTaskListener)) {
            list2.add(this.fetchTaskListener);
        }
        super.open(raptorEditableGridTaskWrapper);
    }

    public void refresh(boolean bl) {
        try {
            if (this.isChanged() && bl) {
                String string = this.getGridModel().getTableName();
                String string2 = MessageFormat.format(IdeArb.getString((int)216), string);
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)string, null);
                switch (n) {
                    case 1: {
                        this.save();
                        return;
                    }
                    case 0: {
                        super.refresh();
                        return;
                    }
                }
                return;
            }
            super.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refresh() {
        this.refresh(true);
    }

    public boolean save(boolean bl, boolean bl2) {
        EditableResultSetTableModel editableResultSetTableModel = this.getGridModel();
        if (editableResultSetTableModel != null) {
            TableCellEditor tableCellEditor;
            if (this.isEditing() && (tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                tableCellEditor.stopCellEditing();
            }
            return editableResultSetTableModel.save(bl, bl2);
        }
        return false;
    }

    public void save() {
        this.save(false, false);
    }

    public void rollback() {
        DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(Messages.getString("EditableResultSetTable.0")){

            @Override
            protected void invokeLater() {
                EditableResultSetTable.this.getGridModel().rollback();
                EditableResultSetTable.this.refresh(false);
                EditableResultSetTable.this.saveTaskListener.showMessages();
            }

            @Override
            public String getConnectionName() {
                return EditableResultSetTable.this.getGridModel().getConnectionName();
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)deferUIOperationTask);
    }

    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        this.actionUpdater.updateActions();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        tableColumn.setCellRenderer(new ResultSetTableCellRenderer());
    }

    @Override
    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map) {
        this.setQuery(string, string2, list, map, null);
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        EditableResultSetTableModel editableResultSetTableModel;
        if (this._setQueryRSTM != null) {
            this._setQueryRSTM.closeModel();
        }
        this._setQueryRSTM = editableResultSetTableModel = RSTModelFactory.getEditableResultSetTableModel(string);
        editableResultSetTableModel.init(string2, string, list, map, dBObject);
        editableResultSetTableModel.setVerticalDisplay(this.isVerticalDisplay());
        this.setModel((TableModel)((Object)editableResultSetTableModel));
        editableResultSetTableModel.setLogPage((LogPage)EditableResultSetTable.getLogPage());
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject, List<String> list2, List<String> list3) {
        this.setQuery(string, string2, list, map, dBObject);
        this.getGridModel().setUneditableColumns(list2);
        this.getGridModel().setEditableColumns(list3);
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject, List<String> list2, List<String> list3, List<Integer> list4) {
        this.setQuery(string, string2, list, map, dBObject, list2, list3);
        this.getGridModel().setUneditableRows(list4);
    }

    public boolean deleteRow() {
        boolean bl = false;
        int n = this.getSelectedRowCount();
        if (n < 1) {
            return true;
        }
        EditableResultSetTableModel editableResultSetTableModel = this.getGridModel();
        if (editableResultSetTableModel != null) {
            if (n == 1) {
                if (editableResultSetTableModel.isRowDeleted(this.getSelectedRow())) {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), false);
                } else {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), true);
                }
            } else {
                int n2;
                int[] nArray = this.getSelectedRows();
                for (n2 = 0; n2 < n; ++n2) {
                    if (editableResultSetTableModel.isRowDeleted(nArray[n2])) continue;
                    bl = true;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (!bl) {
                        editableResultSetTableModel.markRowDeleted(nArray[n2], false);
                        continue;
                    }
                    editableResultSetTableModel.markRowDeleted(nArray[n2], true);
                }
            }
            this.repaint();
            this.actionUpdater.updateActions();
        }
        return true;
    }

    public boolean addRow() {
        return this.addRow(null);
    }

    public boolean addRow(RaptorGridRowModel raptorGridRowModel) {
        TableCellEditor tableCellEditor;
        int n = this.getSelectedRow();
        n = n < 0 ? this.getLoadedRowCount() : ++n;
        if (this.isEditing() && (tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
            tableCellEditor.stopCellEditing();
        }
        boolean bl = this.getGridModel().addRow(n, raptorGridRowModel);
        this.changeSelection(n, 0, false, false);
        this.requestFocusInWindow();
        this.actionUpdater.updateActions();
        return bl;
    }

    public boolean isVerticalDisplay() {
        return false;
    }

    public void setVerticalDisplay(boolean bl) {
    }

    @Override
    public EditableResultSetTableModel getGridModel() {
        if (this.getModel() instanceof EditableResultSetTableModel) {
            return (EditableResultSetTableModel)((Object)this.getModel());
        }
        return null;
    }

    public boolean isEditable() {
        EditableResultSetTableModel editableResultSetTableModel = this.getGridModel();
        if (editableResultSetTableModel == null) {
            return false;
        }
        return this._editable && editableResultSetTableModel.isEditable();
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.getModel() instanceof EditableResultSetTableModel && component instanceof JComponent) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)((Object)this.getModel());
            if (editableResultSetTableModel.isRowDeleted(n)) {
                ((JComponent)component).setBorder(BorderFactory.createEtchedBorder(Color.RED, Color.BLACK));
            } else if (editableResultSetTableModel.isNewRow(n)) {
                ((JComponent)component).setBorder(BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK));
            }
        }
        return component;
    }

    public JTable getRowHeader() {
        if (this._rowHeader == null) {
            this._rowHeader = super.getRowHeader();
            this._rowHeader.setColumnModel((TableColumnModel)((Object)new EditableRowHeaderColumnModel()));
            MouseHoverSupport mouseHoverSupport = new MouseHoverSupport((Component)this._rowHeader, 500, false);
            mouseHoverSupport.addMouseHoverListener(new MouseHoverListener(){

                public void mouseHovered(MouseEvent mouseEvent) {
                    int n = EditableResultSetTable.this.rowAtPoint(mouseEvent.getPoint());
                    if (n != -1 && EditableResultSetTable.this.isRowError(n)) {
                        try {
                            EditableResultSetTable.this.errTip.setRow(n);
                            ActionTipManager.getActionTipManager().submitTipTask((ActionTipTask)EditableResultSetTable.this.errTip);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), mouseEvent);
                        }
                    }
                }
            });
        }
        return this._rowHeader;
    }

    public static AbstractLogPage getLogPage() {
        if (_logPage != null) {
            return _logPage;
        }
        LogManager logManager = LogManager.getLogManager();
        return (AbstractLogPage)logManager.getMsgPage();
    }

    public List<String> getLog() {
        return this.getGridModel().getLog();
    }

    public int getNumberOfSaveErrors() {
        return this.getGridModel().getNumberOfErrors();
    }

    public String getDbTableName() {
        return this.getGridModel().getTableName();
    }

    public String getErrorMessage(int n) {
        return this.getGridModel().getErrorMessage(this.convertRowIndexToModel(n));
    }

    public boolean isRowError(int n) {
        return this.getGridModel().isRowError(n);
    }

    public boolean isNewRow(int n) {
        return this.getGridModel().isNewRow(n);
    }

    public boolean isChanged() {
        return this.getGridModel().isChanged();
    }

    public boolean canSortNow() {
        if (this.isChanged()) {
            return false;
        }
        return super.canSortNow();
    }

    public boolean canColumnSelectNow() {
        return super.canColumnSelectNow();
    }

    @Override
    public boolean canAutoFilter(int n) {
        if (this.isChanged()) {
            return false;
        }
        return super.canAutoFilter(n);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        KeyEvent keyEvent = null;
        if (aWTEvent instanceof KeyEvent) {
            keyEvent = (KeyEvent)aWTEvent;
            if (n == 0 && n2 == 0 && KeyStroke.getKeyStrokeForEvent(keyEvent).equals(KeyStroke.getKeyStroke(9, 0)) && this.isEditable()) {
                n = this.getRowCount();
                if (this.isInsertAllowed()) {
                    this.getGridModel().addRow(n);
                }
            }
        }
        super.changeSelection(n, n2, bl, bl2);
    }

    public boolean duplicateRow() {
        int n = this.getSelectedRow();
        try {
            if (n != -1) {
                int n2 = this.convertRowIndexToModel(n);
                ArrayList<ResultSetGridCell> arrayList = new ArrayList<ResultSetGridCell>();
                if (n2 != -1) {
                    RaptorGridRowModel raptorGridRowModel = this.getGridModel().getRowModel(n2);
                    List<ResultSetGridColumn> list = this.getGridModel().getGridColumns();
                    String string = "\n" + Messages.getString("EditableResultSetTable.3");
                    for (int i = 0; i < list.size(); ++i) {
                        ResultSetGridCell resultSetGridCell;
                        RaptorGridCell raptorGridCell = (RaptorGridCell)raptorGridRowModel.getRow().get(i);
                        Object object = raptorGridCell.getCellData();
                        int n3 = list.get(i).getSqlType();
                        Object object2 = null;
                        if (DataTypesUtil.isExtendedType((Object)object, (int)n3) && object != null && !object.toString().equals("") && DataTypesUtil.canDuplicate((Object)object, (int)n3)) {
                            resultSetGridCell = ExtendedTypeFactory.getExtendedType(object, n3);
                            if (resultSetGridCell == null) {
                                EditableResultSetTable.getLogPage().log((Object)(string + list.get(i).getSqlTypeName()), true);
                                return false;
                            }
                            try {
                                resultSetGridCell.duplicate();
                                object2 = resultSetGridCell;
                            }
                            catch (SQLException sQLException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                                EditableResultSetTable.getLogPage().log((Object)(string + list.get(i).getSqlTypeName()), true);
                                object2 = null;
                            }
                        } else if (!DataTypesUtil.isExtendedType((Object)object, (int)n3) && DataTypesUtil.canDuplicate((Object)object, (int)n3)) {
                            try {
                                object2 = DataTypesUtil.getDuplicate((Object)object, (Connection)this.getGridModel().getConnection(), (int)n3);
                            }
                            catch (SQLException sQLException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                                EditableResultSetTable.getLogPage().log((Object)(string + list.get(i).getSqlTypeName()), true);
                                object2 = null;
                            }
                            catch (DBException dBException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                                EditableResultSetTable.getLogPage().log((Object)(string + list.get(i).getSqlTypeName()), true);
                                object2 = null;
                            }
                        } else {
                            object2 = null;
                        }
                        resultSetGridCell = new ResultSetGridCell(object2, this.getGridModel().getConnectionName());
                        arrayList.add(resultSetGridCell);
                    }
                    RaptorGridRowModel raptorGridRowModel2 = new RaptorGridRowModel(arrayList);
                    this.addRow(raptorGridRowModel2);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    private void initStatics() {
        if (!_initStatics) {
            EditableResultSetTable.addGridContextMenu((GridContextMenuItem)DuplicateRow.getInstance());
            _initStatics = true;
        }
    }

    private void logError(final RaptorTaskEvent raptorTaskEvent, boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditableResultSetTable.getLogPage().log((Object)"\n");
                EditableResultSetTable.getLogPage().log((Object)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()), true);
                EditableResultSetTable.this.actionUpdater.updateActions();
            }
        };
        if (bl) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void registerGridUpdater(IRaptorGridUpdater iRaptorGridUpdater) {
        EditableResultSetTableModel editableResultSetTableModel = this.getGridModel();
        if (editableResultSetTableModel != null) {
            editableResultSetTableModel.registerGridUpdater(iRaptorGridUpdater);
        }
    }

    public boolean isInsertAllowed() {
        return this.isEditable() && this._isInsertAllowed;
    }

    public void setInsertAllowed(boolean bl) {
        this._isInsertAllowed = bl;
    }

    public boolean isDeleteAllowed() {
        return this.isEditable() && this._isDeleteAllowed;
    }

    public void setDeleteAllowed(boolean bl) {
        this._isDeleteAllowed = bl;
    }

    public boolean isRefreshAllowed() {
        return this._isRefreshAllowed;
    }

    public void setRefreshAllowed(boolean bl) {
        this._isRefreshAllowed = bl;
    }

    public boolean isCommitActionAllowed() {
        return this._isCommitActionAllowed;
    }

    public void setCommitActionAllowed(boolean bl) {
        this._isCommitActionAllowed = bl;
    }

    public boolean isRollbackActionAllowed() {
        return this._isRollbackActionAllowed;
    }

    public void setRollbackActionAllowed(boolean bl) {
        this._isRollbackActionAllowed = bl;
    }

    public boolean isFilterFieldAllowed() {
        return this._isFilterFieldAllowed;
    }

    public void setFilterFieldAllowed(boolean bl) {
        this._isFilterFieldAllowed = bl;
    }

    public void closeModel() {
        super.closeModel();
        this._controller.setGrid(null);
        EditableResultSetTable.removeGridContextMenu((GridContextMenuItem)this.getController().getEditableGridContextMenu());
    }

    public void deletePersistentSettings() {
        this._controller.getGridFilterField().deletePersistedFilters();
        super.deletePersistentSettings();
    }

    static {
        _initStatics = false;
    }

    private class FetchTaskListener
    extends RaptorTaskAdapter {
        private FetchTaskListener() {
        }

        public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EditableResultSetTable.getLogPage().log((Object)"\n");
                    EditableResultSetTable.getLogPage().log((Object)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()), true);
                    if (EditableResultSetTable.this.isFilterFieldAllowed()) {
                        EditableResultSetTable.this._controller.getGridFilterField().setEnabled(!EditableResultSetTable.this.isChanged());
                    }
                    EditableResultSetTable.this.actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EditableResultSetTable.getLogPage().log((Object)"\n");
                    EditableResultSetTable.getLogPage().log((Object)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()), true);
                    EditableResultSetTable.this.actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            GridFilterField gridFilterField = EditableResultSetTable.this._controller.getGridFilterField();
            if (gridFilterField != null && gridFilterField.getText() != null && !gridFilterField.getText().equals("")) {
                gridFilterField.persistFilters();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EditableResultSetTable.this.actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class SaveMessageShower
    extends RaptorTaskAdapter {
        private SaveMessageShower() {
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            EditableResultSetTable.this.logError(raptorTaskEvent, false);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            EditableResultSetTable.this.logError(raptorTaskEvent, false);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.showMessages();
        }

        void showMessages() {
            final ArrayList<String> arrayList = new ArrayList<String>(EditableResultSetTable.this.getLog());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n;
                    AbstractLogPage abstractLogPage = EditableResultSetTable.getLogPage();
                    abstractLogPage.show();
                    abstractLogPage.activate();
                    abstractLogPage.log((Object)"\n");
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (arrayList.get(n) == null) continue;
                        abstractLogPage.log((Object)((String)arrayList.get(n) + System.getProperty("line.separator")));
                    }
                    abstractLogPage.log((Object)System.getProperty("line.separator"));
                    n = EditableResultSetTable.this.getNumberOfSaveErrors();
                    if (n > 0) {
                        EditableResultSetTable.this.success = false;
                        if (n == 1) {
                            abstractLogPage.log((Object)(MessageFormat.format(ConnectionArb.getString((String)"EDITRS_SING_ERR"), EditableResultSetTable.this.getDbTableName()) + System.getProperty("line.separator")));
                        } else {
                            abstractLogPage.log((Object)(MessageFormat.format(ConnectionArb.getString((String)"EDITRS_PLUR_ERR"), n, EditableResultSetTable.this.getDbTableName()) + System.getProperty("line.separator")));
                        }
                        for (int i = 0; i < EditableResultSetTable.this.getLoadedRowCount(); ++i) {
                            if (!EditableResultSetTable.this.isRowError(i)) continue;
                            abstractLogPage.log((Object)MessageFormat.format(ConnectionArb.getString((String)"EDITRS_ROW_ERR"), i + 1, EditableResultSetTable.this.getErrorMessage(i)));
                        }
                    }
                    EditableResultSetTable.this.actionUpdater.updateActions();
                    EditableResultSetTable.this.requestFocusInWindow();
                    EditableResultSetTable.this.getLog().clear();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class ErrorTip
    implements ActionTipTask {
        int row = 0;

        ErrorTip() {
        }

        void setRow(int n) {
            this.row = n;
        }

        public void actionTipResult(ActionTipManager.TaskResult taskResult) {
        }

        public JComponent getActionTipContent() {
            return new DefaultActionTipComponent((ActionTipTask)this, Messages.getString("EditableResultSetTable.1"), EditableResultSetTable.this.getErrorMessage(this.row));
        }

        public Rectangle getLocation() {
            return EditableResultSetTable.this.getRowHeader().getCellRect(this.row, 0, true);
        }

        public JComponent getParentComponent() {
            return EditableResultSetTable.this.getRowHeader();
        }

        public boolean isCancelable() {
            return true;
        }
    }

    public static final class DataEditorLogPage
    extends DefaultLogPage {
        public DataEditorLogPage() {
            super(new ViewId("DataEditorLogPage", Messages.getString("EditableResultSetTable.12")), null, false, HIDE_FIX_SOURCE_MENU);
        }
    }

    protected class EditableRowHeaderCellRenderer
    extends RaptorGridTable.RowHeaderCellRenderer {
        private static final long serialVersionUID = 1L;

        protected EditableRowHeaderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            this.setHorizontalAlignment(4);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = jLabel.getBorder();
            EditableResultSetTableModel editableResultSetTableModel = EditableResultSetTable.this.getGridModel();
            if (editableResultSetTableModel != null && (n3 = EditableResultSetTable.this.convertRowIndexToModel(n)) >= 0) {
                if (editableResultSetTableModel.isDeletedRow(n3)) {
                    border = BorderFactory.createEtchedBorder(Color.RED, Color.BLACK);
                } else if (editableResultSetTableModel.isNewRow(n3)) {
                    border = BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK);
                } else if (editableResultSetTableModel.isUpdatedRow(n3)) {
                    border = BorderFactory.createEtchedBorder(Color.BLUE, Color.BLACK);
                }
            }
            if (border != null) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            jLabel.setBorder(border);
            return jLabel;
        }
    }

    protected class EditableRowHeaderColumnModel
    extends RaptorGridTable.RowHeaderTableColumnModel {
        protected EditableRowHeaderColumnModel() {
            super((RaptorGridTable)EditableResultSetTable.this);
        }

        public void addColumn(TableColumn tableColumn) {
            super.addColumn(tableColumn);
            tableColumn.setCellRenderer((TableCellRenderer)((Object)new EditableRowHeaderCellRenderer()));
        }
    }
}

