/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;

class PropertyTableModel
extends AbstractTableModel {
    private ChartPropertyManager propertyManager;
    private PropertyType rowCountPropertyType;
    private PropertyType[] columnPropertyTypes;
    private PropertyType[] domainPropertyTypes;
    private String[] columnNames;
    private List<Integer> applicableProperties;

    PropertyTableModel(ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType[] propertyTypeArray, String[] stringArray) {
        this(chartPropertyManager, propertyType, propertyTypeArray, null, stringArray);
    }

    PropertyTableModel(ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType[] propertyTypeArray, PropertyType[] propertyTypeArray2, String[] stringArray) {
        this.propertyManager = chartPropertyManager;
        this.rowCountPropertyType = propertyType;
        this.columnPropertyTypes = propertyTypeArray;
        this.domainPropertyTypes = propertyTypeArray2;
        this.columnNames = stringArray;
        this.applicableProperties = new ArrayList<Integer>();
    }

    @Override
    public int getRowCount() {
        Integer n = this.propertyManager.get(this.rowCountPropertyType, Integer.class);
        return n != null ? n : 0;
    }

    @Override
    public int getColumnCount() {
        return this.applicableProperties.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[this.applicableProperties.get(n)];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.propertyManager.primitiveClassOf(this.columnPropertyTypes[this.applicableProperties.get(n)]);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.propertyManager.get(this.columnPropertyTypes[this.applicableProperties.get(n2)], List.class).get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        List list = this.propertyManager.get(this.columnPropertyTypes[this.applicableProperties.get(n2)], List.class);
        list.set(n, object);
        this.propertyManager.set(this.columnPropertyTypes[this.applicableProperties.get(n2)], list);
    }

    public void addRow() {
        Integer n = this.propertyManager.get(this.rowCountPropertyType, Integer.class);
        n = n != null ? n + 1 : 1;
        this.propertyManager.set(this.rowCountPropertyType, n);
        for (PropertyType propertyType : this.columnPropertyTypes) {
            List list = this.propertyManager.get(propertyType, List.class);
            if (list.size() >= n) continue;
            for (int i = list.size(); i < n; ++i) {
                list.add(this.propertyManager.getDefaultCollectionItemOf(propertyType));
            }
            this.propertyManager.set(propertyType, list);
        }
        this.fireTableStructureChanged();
    }

    public void removeRow(int n) {
        Integer n2 = this.propertyManager.get(this.rowCountPropertyType, Integer.class);
        if (n2 != null && n >= 0 && n < n2) {
            n2 = n2 - 1;
            this.propertyManager.set(this.rowCountPropertyType, n2);
            for (PropertyType propertyType : this.columnPropertyTypes) {
                List list = this.propertyManager.get(propertyType, List.class);
                list.remove(n);
                this.propertyManager.set(propertyType, list);
            }
            this.fireTableStructureChanged();
        }
    }

    ChartPropertyManager propertyManager() {
        return this.propertyManager;
    }

    PropertyType rowCountPropertyType() {
        return this.rowCountPropertyType;
    }

    PropertyType[] columnPropertyTypes() {
        return this.columnPropertyTypes;
    }

    PropertyType[] domainPropertyTypes() {
        return this.domainPropertyTypes;
    }

    void refreshComponentValue() {
        this.applicableProperties.clear();
        for (int i = 0; i < this.columnPropertyTypes.length; ++i) {
            PropertyType propertyType = this.columnPropertyTypes[i];
            if (!this.propertyManager.isApplicable(propertyType)) continue;
            this.applicableProperties.add(i);
        }
        this.fireTableStructureChanged();
    }
}

