/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.ChartTypeProperties;
import oracle.dbtools.raptor.controls.display.chart.DataMapProperties;
import oracle.dbtools.raptor.controls.display.chart.GroupProperties;
import oracle.dbtools.raptor.controls.display.chart.LegendProperties;
import oracle.dbtools.raptor.controls.display.chart.ManagerListener;
import oracle.dbtools.raptor.controls.display.chart.PlotAreaProperties;
import oracle.dbtools.raptor.controls.display.chart.Property;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyName;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.StyleProperties;
import oracle.dbtools.raptor.controls.display.chart.TitlesProperties;
import oracle.dbtools.raptor.controls.display.chart.XAxisProperties;
import oracle.dbtools.raptor.controls.display.chart.Y1AxisProperties;
import oracle.dbtools.raptor.controls.display.chart.Y2AxisProperties;
import oracle.dss.graph.Graph;

class ChartPropertyManagerImpl
implements ChartPropertyManager {
    private static EnumMap<PropertyType, PropertyDef> propertyDefs;
    private static Graph defaultGraph;
    private Property<ChartType> chartTypeProperty;
    private EnumMap<PropertyType, Property> properties = new EnumMap(PropertyType.class);
    private HashSet<Graph> boundGraphs;
    private HashSet<PropertyListener> propertyListeners;
    private HashSet<ManagerListener> managerListeners;
    private String dbName;

    ChartPropertyManagerImpl(ChartType chartType) {
        this.chartTypeProperty = new Property<ChartType>(propertyDefs.get((Object)PropertyType.TYPE), chartType);
        this.properties.put(PropertyType.TYPE, this.chartTypeProperty);
        this.boundGraphs = new HashSet();
        this.propertyListeners = new HashSet();
        this.managerListeners = new HashSet();
    }

    @Override
    public ChartType chartType() {
        return this.chartTypeProperty.get();
    }

    @Override
    public void load(Map<String, String> map) {
        for (PropertyType propertyType : propertyDefs.keySet()) {
            PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
            Property property = propertyDef.loadProperty(new PropertyName(propertyType), map);
            if (property == null) continue;
            this.properties.put(propertyType, property);
        }
        this.verifyAll();
        this.chartTypeProperty = this.property(PropertyType.TYPE, ChartType.class);
        this.notifyPropertyChange(null);
    }

    @Override
    public void save(Map<String, String> map) {
        for (PropertyType propertyType : propertyDefs.keySet()) {
            PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
            Property property = this.properties.get((Object)propertyType);
            if (property == null) continue;
            propertyDef.saveProperty(new PropertyName(propertyType), map, property);
        }
    }

    @Override
    public boolean isApplicable(PropertyType propertyType) {
        return propertyDefs.get((Object)propertyType).isApplicable(this.chartTypeProperty.get());
    }

    @Override
    public <T> T get(PropertyType propertyType, Class<T> clazz) {
        return (T)this.get(propertyType);
    }

    @Override
    public Object get(PropertyType propertyType) {
        Object var2_2 = null;
        Property<?> property = this.property(propertyType);
        if (property != null) {
            PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
            var2_2 = propertyDef.archiver().getOwnableValue(property.get());
        }
        return var2_2;
    }

    @Override
    public void set(PropertyType propertyType, Object object) {
        PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
        if (!propertyDef.isApplicable(this.chartTypeProperty.get())) {
            throw new IllegalArgumentException();
        }
        Property<Object> property = this.properties.get((Object)propertyType);
        if (this.newValueDiffers(property, object)) {
            propertyDef.archiver().verifyValue(this, object);
            Object object2 = propertyDef.archiver().getOwnableValue(object);
            if (property != null) {
                property.set(object2);
            } else {
                property = new Property<Object>(propertyDef, object2);
                this.properties.put(propertyType, property);
            }
            if (defaultGraph != null && (propertyType == PropertyType.TYPE || propertyType == PropertyType.STYLE)) {
                defaultGraph = null;
            }
            this.notifyPropertyChange(propertyType);
        }
    }

    @Override
    public void reset() {
        this.reset(new PropertyType[0]);
    }

    @Override
    public void reset(PropertyType ... propertyTypeArray) {
        int n;
        Property[] propertyArray = new Property[propertyTypeArray.length];
        for (n = 0; n < propertyTypeArray.length; ++n) {
            if (propertyTypeArray[n] == PropertyType.TYPE) continue;
            propertyArray[n] = this.properties.get((Object)propertyTypeArray[n]);
        }
        this.properties.clear();
        this.properties.put(PropertyType.TYPE, this.chartTypeProperty);
        for (n = 0; n < propertyTypeArray.length; ++n) {
            if (propertyTypeArray[n] == PropertyType.TYPE) continue;
            this.properties.put(propertyTypeArray[n], propertyArray[n]);
        }
        this.notifyPropertyChange(null);
    }

    @Override
    public void resetProperty(PropertyType propertyType) {
        if (this.properties.remove((Object)propertyType) != null) {
            this.notifyPropertyChange(propertyType);
        }
    }

    @Override
    public Graph createGraph() {
        Graph graph = new Graph();
        this.resetGraph(graph);
        int n = graph.getGraphType();
        graph.setGraphType(17);
        graph.setGraphType(n);
        return graph;
    }

    @Override
    public void bindGraph(Graph graph) {
        this.boundGraphs.add(graph);
    }

    @Override
    public void unbindGraph(Graph graph) {
        this.boundGraphs.remove(graph);
    }

    @Override
    public void addPropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.add(propertyListener);
    }

    @Override
    public void removePropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.remove(propertyListener);
    }

    @Override
    public void addManagerListener(ManagerListener managerListener) {
        this.managerListeners.add(managerListener);
    }

    @Override
    public void removeManagerListener(ManagerListener managerListener) {
        this.managerListeners.add(managerListener);
    }

    @Override
    public String dbName() {
        return this.dbName;
    }

    @Override
    public void setDbName(String string) {
        this.dbName = string;
        ArrayList<ManagerListener> arrayList = new ArrayList<ManagerListener>(this.managerListeners);
        for (ManagerListener managerListener : arrayList) {
            managerListener.onSetDbName();
        }
    }

    @Override
    public void close() {
        ArrayList<ManagerListener> arrayList = new ArrayList<ManagerListener>(this.managerListeners);
        for (ManagerListener managerListener : arrayList) {
            managerListener.onClose();
        }
        this.chartTypeProperty = null;
        this.properties = null;
        this.boundGraphs.clear();
        this.boundGraphs = null;
        this.propertyListeners.clear();
        this.propertyListeners = null;
        this.managerListeners.clear();
        this.managerListeners = null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Chart [");
        for (PropertyType propertyType : this.properties.keySet()) {
            Property property = this.properties.get((Object)propertyType);
            stringBuilder.append("\n    " + propertyType.toString() + "=" + property.get());
        }
        stringBuilder.append("\n ]");
        return stringBuilder.toString();
    }

    @Override
    public String toString(Graph graph) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Graph [");
        ChartType chartType = ChartType.get(graph.getGraphType());
        for (PropertyType propertyType : propertyDefs.keySet()) {
            PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
            if (!propertyDef.isApplicable(chartType) || propertyDef.isGroupProperty()) continue;
            Object t = propertyDef.getGraphValue(graph);
            stringBuilder.append("\n    " + propertyType.toString() + "=" + t);
        }
        stringBuilder.append("\n ]");
        return stringBuilder.toString();
    }

    Property<?> property(PropertyType propertyType) {
        Property property = null;
        PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
        if (propertyDef.isApplicable(this.chartTypeProperty.get()) && (property = this.findApplicableProperty(propertyType)) == null) {
            property = propertyDef.getDefaultProperty(this, this.defaultGraph());
        }
        return property;
    }

    <T> Property<T> property(PropertyType propertyType, Class<T> clazz) {
        return this.property(propertyType);
    }

    PropertyDef<?> propertyDef(PropertyType propertyType) {
        return propertyDefs.get((Object)propertyType);
    }

    <T> PropertyDef<T> propertyDef(PropertyType propertyType, Class<T> clazz) {
        return propertyDefs.get((Object)propertyType);
    }

    @Override
    public Class primitiveClassOf(PropertyType propertyType) {
        return propertyDefs.get((Object)propertyType).archiver().primitiveClass();
    }

    @Override
    public Class collectionClassOf(PropertyType propertyType) {
        return propertyDefs.get((Object)propertyType).archiver().collectionClass();
    }

    @Override
    public Object getDefaultCollectionItemOf(PropertyType propertyType) {
        return propertyDefs.get((Object)propertyType).archiver().getDefaultItem();
    }

    Graph defaultGraph() {
        if (defaultGraph == null) {
            defaultGraph = new Graph();
            ChartType chartType = this.chartTypeProperty.get();
            defaultGraph.setGraphType(chartType.graphType());
            DisplayConstants.CHART_STYLES cHART_STYLES = null;
            Property property = this.properties.get((Object)PropertyType.STYLE);
            if (property != null) {
                cHART_STYLES = (DisplayConstants.CHART_STYLES)property.get();
            }
            if (cHART_STYLES != null) {
                try {
                    defaultGraph.setStylePath(cHART_STYLES.getPath());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            this.setListCardinalities(defaultGraph);
        }
        return defaultGraph;
    }

    private void notifyPropertyChange(final PropertyType propertyType) {
        for (Graph object2 : this.boundGraphs) {
            this.resetGraph(object2);
        }
        PropertyEvent propertyEvent = new PropertyEvent(){

            @Override
            public boolean changed(PropertyType ... propertyTypeArray) {
                boolean bl = propertyType == null || propertyType == PropertyType.TYPE;
                for (int i = 0; !bl && i < propertyTypeArray.length; ++i) {
                    bl = propertyTypeArray[i] == propertyType;
                }
                return bl;
            }
        };
        ArrayList<PropertyListener> arrayList = new ArrayList<PropertyListener>(this.propertyListeners);
        for (PropertyListener propertyListener : arrayList) {
            propertyListener.onChange(propertyEvent);
        }
    }

    private boolean newValueDiffers(Property property, Object object) {
        if (property == null) {
            return object != null;
        }
        Object t = property.get();
        if (t == null) {
            return object != null;
        }
        return !t.equals(object);
    }

    private void resetGraph(Graph graph) {
        graph.resetToDefault(5);
        propertyDefs.get((Object)PropertyType.TYPE).updateGraph(graph, this.property(PropertyType.TYPE));
        for (PropertyType propertyType : propertyDefs.keySet()) {
            PropertyDef propertyDef;
            if (propertyType == PropertyType.TYPE || propertyType == PropertyType.STYLE || (propertyDef = propertyDefs.get((Object)propertyType)).isGroupProperty() || !propertyDef.isApplicable(this.chartTypeProperty.get())) continue;
            propertyDef.updateGraph(graph, this.property(propertyType));
        }
        this.setListCardinalities(graph);
    }

    private void setListCardinalities(Graph graph) {
        PropertyDef propertyDef = propertyDefs.get((Object)PropertyType.PLOT_SERIES_OBJECT_COUNT);
        Integer n = (Integer)propertyDef.getGraphValue(graph);
        if (n == null || n != 5) {
            propertyDef.setGraphValue(graph, 5);
        }
    }

    private Property findApplicableProperty(PropertyType propertyType) {
        Property property;
        PropertyDef propertyDef;
        PropertyType propertyType2;
        Property property2 = this.properties.get((Object)propertyType);
        if (property2 == null && (propertyType2 = (propertyDef = propertyDefs.get((Object)propertyType)).groupPropertyType()) != null && (property = this.findApplicableProperty(propertyType2)) != null) {
            property2 = new Property(propertyDef, property.get());
        }
        return property2;
    }

    private void verifyAll() {
        for (PropertyType propertyType : propertyDefs.keySet()) {
            PropertyDef propertyDef = propertyDefs.get((Object)propertyType);
            Property<?> property = this.property(propertyType);
            if (property == null) continue;
            propertyDef.archiver().verifyValue(this, property.get());
        }
    }

    private static void registerProperties(PropertyGroup propertyGroup) {
        if (propertyDefs == null) {
            propertyDefs = new EnumMap(PropertyType.class);
        }
        propertyGroup.register(propertyDefs);
    }

    static {
        ChartPropertyManagerImpl.registerProperties(new ChartTypeProperties());
        ChartPropertyManagerImpl.registerProperties(new TitlesProperties());
        ChartPropertyManagerImpl.registerProperties(new StyleProperties());
        ChartPropertyManagerImpl.registerProperties(new LegendProperties());
        ChartPropertyManagerImpl.registerProperties(new PlotAreaProperties());
        ChartPropertyManagerImpl.registerProperties(new XAxisProperties());
        ChartPropertyManagerImpl.registerProperties(new Y1AxisProperties());
        ChartPropertyManagerImpl.registerProperties(new Y2AxisProperties());
        ChartPropertyManagerImpl.registerProperties(new GroupProperties());
        ChartPropertyManagerImpl.registerProperties(new DataMapProperties());
    }
}

