/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.proformatter.SQLFormatCommand;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;

public class DisplayCodeEditor
extends DisplayAdapter {
    private BasicEditorPane _codeArea;
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/raptor/oviewer/base/accelerators.xml")};

    public void init() {
        if (this._codeArea == null) {
            this._codeArea = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
            this._codeArea.setText("");
            this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            final LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
            this._codeArea.installPlugin((EditorPlugin)lineGutterPlugin);
            this._codeArea.installPlugin((EditorPlugin)highlightEditorPlugin);
            this._codeArea.setText("");
            this._codeArea.setEditable(false);
            this._codeArea.setBackground(Color.WHITE);
            this.getScrollableUI().setRowHeaderView((Component)lineGutterPlugin);
            final JPopupMenu jPopupMenu = new JPopupMenu(Messages.getString("DisplayCodeEditor.3"));
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("DisplayCodeEditor.4"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            lineGutterPlugin.addGutterClickListener(new GutterClickListener(){

                public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                    gutter.hashCode();
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            this.getScrollableUI().getRowHeader().addMouseListener((MouseListener)new UIUtils.MousePopupTriggerListener(){

                protected void doPopup(MouseEvent mouseEvent) {
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            });
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._codeArea;
    }

    @Override
    public void close() {
        BasicEditorPane basicEditorPane = this._codeArea;
        this._codeArea = null;
        if (basicEditorPane != null && basicEditorPane.getParent() != null) {
            basicEditorPane.getParent().remove((Component)basicEditorPane);
        }
        super.close();
    }

    @Override
    public void refresh(boolean bl) {
        this.init();
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        RaptorTask<StringBuilder> raptorTask = new RaptorTask<StringBuilder>(Messages.getString("ResultSetTableModel.8"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected StringBuilder doWork() throws TaskException {
                ResultSet resultSet = null;
                StringBuilder stringBuilder = new StringBuilder();
                String string = DisplayCodeEditor.this.getQuery().getSql();
                this.setMessage(string);
                if (Connections.getInstance().lock(DisplayCodeEditor.this.getConnection())) {
                    block8: {
                        try {
                            List list = DisplayCodeEditor.this._query.getCols();
                            DisplayCodeEditor.this._codeArea.getDocument().remove(0, DisplayCodeEditor.this._codeArea.getDocument().getLength());
                            resultSet = DBUtil.getInstance((String)DisplayCodeEditor.this.getConnName()).executeQuery(string, DisplayCodeEditor.this.getBindMap());
                            if (resultSet == null) break block8;
                            while (resultSet.next()) {
                                this.checkCanProceed();
                                if (list != null && list.size() > 0) {
                                    for (Column column : list) {
                                        stringBuilder.append(resultSet.getString(column.getName()));
                                    }
                                    continue;
                                }
                                stringBuilder.append(resultSet.getString(1));
                            }
                        }
                        catch (Exception exception) {
                            try {
                                throw new TaskException((Throwable)exception);
                            }
                            catch (Throwable throwable) {
                                DBUtil.closeResultSet(resultSet);
                                Connections.getInstance().unlock(DisplayCodeEditor.this.getConnection());
                                throw throwable;
                            }
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(DisplayCodeEditor.this.getConnection());
                }
                return stringBuilder;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter((RaptorTask)raptorTask){
            StringBuilder sb = null;
            final /* synthetic */ RaptorTask val$task;
            {
                this.val$task = raptorTask;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    this.sb = (StringBuilder)this.val$task.getResult();
                }
                catch (InterruptedException interruptedException) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)executionException);
                }
                if (this.sb != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DBConfig dBConfig = DBConfig.getInstance();
                            DisplayCodeEditor.this._codeArea.setEditable(true);
                            if (sb.length() == 0) {
                                DisplayCodeEditor.this._codeArea.setText(Messages.getString("DisplayCodeEditor.5"));
                            } else {
                                DisplayCodeEditor.this._codeArea.setBackground(Color.WHITE);
                                if (dBConfig.getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                                    SQLFormatCommand sQLFormatCommand = new SQLFormatCommand();
                                    String string = sQLFormatCommand.reallyDoIt(sb.toString());
                                    DisplayCodeEditor.this._codeArea.setText(string);
                                } else {
                                    DisplayCodeEditor.this._codeArea.setText(sb.toString());
                                }
                            }
                            DisplayCodeEditor.this._codeArea.setEditable(false);
                        }
                    });
                }
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.showError(raptorTaskEvent);
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.showError(raptorTaskEvent);
            }

            private void showError(final RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DisplayCodeEditor.this._codeArea.setEditable(true);
                        DisplayCodeEditor.this._codeArea.setText(RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                        DisplayCodeEditor.this._codeArea.setBackground(Color.GRAY);
                        DisplayCodeEditor.this._codeArea.setEditable(false);
                    }
                });
            }
        };
        ArrayList<5> arrayList = new ArrayList<5>();
        arrayList.add(raptorTaskAdapter);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void addActions(final List<ObjectAction> list) {
        UIUtils.MousePopupTriggerListener mousePopupTriggerListener = new UIUtils.MousePopupTriggerListener(){

            protected void doPopup(MouseEvent mouseEvent) {
                ContextMenu contextMenu = new ContextMenu();
                for (ObjectAction objectAction : list) {
                    contextMenu.add((Component)objectAction.getMenuItem());
                }
                Context context = new Context();
                context.setEvent((EventObject)mouseEvent);
                contextMenu.show(context);
            }
        };
        this.init();
        this._codeArea.addMouseListener((MouseListener)mousePopupTriggerListener);
    }

    @Override
    public void clear() {
        this._codeArea.setEditable(true);
        this._codeArea.setText("heloo");
        try {
            this._codeArea.getDocument().remove(0, this._codeArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.warn(this.getClass(), (Throwable)badLocationException);
        }
        this._codeArea.setEditable(false);
    }

    @Override
    public boolean isUseEditorScrollPane() {
        return false;
    }

    @Override
    public BasicEditorPane getCodeEditor() {
        return this._codeArea;
    }
}

