/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.drilllinks;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.grid.IDrillLink;

public final class DrillLinkRegistry {
    private static DrillLinkRegistry INSTANCE = null;
    private final HashMap<String, Stack<Class<?>>> drillLinkMap = new HashMap();

    public static synchronized DrillLinkRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DrillLinkRegistry();
        }
        return INSTANCE;
    }

    private DrillLinkRegistry() {
    }

    public void registerDrillLink(Class<?> clazz) {
        if (clazz != null) {
            String string = clazz.getCanonicalName();
            Stack<Class<Object>> stack = this.drillLinkMap.get(string);
            if (stack == null) {
                stack = new Stack();
                this.drillLinkMap.put(string, stack);
            }
            stack.push(clazz);
        }
    }

    public void unRegisterDrillLink(Class<?> clazz) {
        String string;
        Stack<Class<?>> stack;
        if (clazz != null && (stack = this.drillLinkMap.get(string = clazz.getCanonicalName())) != null) {
            stack.remove(clazz);
        }
    }

    private Class<?> getRegisteredClass(String string) {
        Stack<Class<?>> stack;
        if (string != null && (stack = this.drillLinkMap.get(string)) != null) {
            try {
                return stack.peek();
            }
            catch (EmptyStackException emptyStackException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, emptyStackException.getStackTrace()[0].toString(), emptyStackException);
            }
        }
        return null;
    }

    public IDrillLink getDrillLink(String[] stringArray, String string) {
        IDrillLink iDrillLink = null;
        if (stringArray != null && stringArray.length >= 1) {
            String string2 = stringArray[stringArray.length - 1];
            try {
                Class<?> clazz = this.getRegisteredClass(string2);
                if (clazz == null) {
                    clazz = Class.forName(string2);
                }
                if (clazz != null) {
                    iDrillLink = (IDrillLink)clazz.newInstance();
                    iDrillLink.setArgs(stringArray);
                    iDrillLink.setConnName(string);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return iDrillLink;
    }
}

