/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.Messages;

public class TabularPropertyPanel
extends JPanel {
    private JPanel _northPanel;
    private JPanel _southPanel;
    private JTable _table;
    private DefaultTableModel _model;

    public TabularPropertyPanel() {
        this.init();
    }

    public JTable getTable() {
        return this._table;
    }

    public void addSingleComp(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string == null ? "" : string.toString());
        jLabel.setSize(200, jLabel.getSize().height);
        this.addFooter(jLabel);
    }

    public void addFooter(JComponent jComponent) {
        this._southPanel.add(jComponent);
    }

    public void addRow(String string, Object object) {
        Object[] objectArray = new Object[]{string, object};
        this._model.addRow(objectArray);
    }

    private void init() {
        this._northPanel = new JPanel();
        this._southPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this._northPanel.setLayout(new BorderLayout());
        this._southPanel.setLayout(new BoxLayout(this._southPanel, 1));
        this.add((Component)this._northPanel, "North");
        this.add((Component)this._southPanel, "South");
        Vector<String> vector = new Vector<String>();
        vector.add(Messages.getString("TabularPropertyPanel.1"));
        vector.add(Messages.getString("TabularPropertyPanel.2"));
        Object[][] objectArrayArray = new Object[][]{{"", ""}};
        this._model = new DefaultTableModel(new Vector(), vector);
        this._table = new JTable();
        this._table.setModel(this._model);
        this._table.setShowGrid(true);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this._northPanel.add(jScrollPane);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._northPanel != null) {
            this._northPanel.setBackground(color);
        }
        if (this._southPanel != null) {
            this._southPanel.setBackground(color);
        }
    }

    @Override
    public void removeAll() {
        this._model.setRowCount(0);
        this._northPanel.removeAll();
        this._southPanel.removeAll();
    }

    public static void main(String[] stringArray) {
        TabularPropertyPanel tabularPropertyPanel = new TabularPropertyPanel();
        tabularPropertyPanel.addRow("hi", "hello");
        tabularPropertyPanel.addRow("hi2", "hello2");
        tabularPropertyPanel.addRow("hi3", "hello3");
        tabularPropertyPanel.addRow("hi4", "hello4");
        tabularPropertyPanel.addRow("hi5", "hello5");
        tabularPropertyPanel.addRow("hi6", "hello6");
        tabularPropertyPanel.addFooter(new JTextField("hello out there2"));
        String string = "Frame Title";
        JFrame jFrame = new JFrame(string);
        jFrame.setLayout(new BorderLayout());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)tabularPropertyPanel, "Center");
        int n = 300;
        int n2 = 300;
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
    }
}

