/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import oracle.ide.controls.ForegroundSwappedIcon;
import oracle.ide.util.ModelUtil;
import oracle.javatools.ui.border.SmallSquareButtonBorder;

public class SquareIconButton
extends JButton {
    public SquareIconButton(Icon icon, String string) {
        this();
        this.setIcon(icon);
        this.setToolTipText(string);
    }

    public SquareIconButton(Icon icon) {
        this(icon, null);
    }

    public SquareIconButton() {
        this.configure();
    }

    protected void configure() {
        this.setBorder((Border)new SmallSquareButtonBorder());
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon == null || icon instanceof ForegroundSwappedIcon) {
            super.setIcon(icon);
            return;
        }
        super.setIcon((Icon)new ForegroundSwappedIcon(icon, this.getForeground()));
    }

    @Override
    public void setForeground(Color color) {
        if (ModelUtil.areDifferent((Object)color, (Object)this.getForeground())) {
            super.setForeground(color);
            this.swapIconForForeground(color);
        }
    }

    protected void swapIconForForeground(Color color) {
        Icon icon = this.getIcon();
        if (icon instanceof ForegroundSwappedIcon) {
            ForegroundSwappedIcon foregroundSwappedIcon = (ForegroundSwappedIcon)icon;
            Icon icon2 = foregroundSwappedIcon.getBaseIcon();
            this.setIcon((Icon)new ForegroundSwappedIcon(icon2, color));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(null);
        this.setForeground(null);
    }
}

