/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.javatools.util.Pair;

public class SharedContextMenuSupport {
    private static final SharedContextMenuSupport INSTANCE = new SharedContextMenuSupport();
    private final List<Pair<Class, ContextMenuListener>> m_listeners = new CopyOnWriteArrayList<Pair<Class, ContextMenuListener>>();
    private final List<ContextMenu> m_menus = new CopyOnWriteArrayList<ContextMenu>();

    public static SharedContextMenuSupport getInstance() {
        return INSTANCE;
    }

    private SharedContextMenuSupport() {
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener, Class clazz) {
        this.m_listeners.add((Pair<Class, ContextMenuListener>)new Pair((Object)clazz, (Object)contextMenuListener));
        for (ContextMenu contextMenu : this.m_menus) {
            contextMenu.addContextMenuListener(contextMenuListener, clazz);
        }
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.addContextMenuListener(contextMenuListener, null);
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        if (contextMenuListener == null) {
            return;
        }
        ArrayList<Pair<Class, ContextMenuListener>> arrayList = new ArrayList<Pair<Class, ContextMenuListener>>();
        for (Pair<Class, ContextMenuListener> contextMenu : this.m_listeners) {
            if (contextMenu.getSecond() != contextMenuListener) continue;
            arrayList.add(contextMenu);
        }
        this.m_listeners.removeAll(arrayList);
        for (ContextMenu contextMenu : this.m_menus) {
            contextMenu.removeContextMenuListener(contextMenuListener);
        }
    }

    public void attachContextMenu(ContextMenu contextMenu) {
        this.m_menus.add(contextMenu);
        for (Pair<Class, ContextMenuListener> pair : this.m_listeners) {
            contextMenu.addContextMenuListener((ContextMenuListener)pair.second, (Class)pair.first);
        }
    }
}

