/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

public final class RoundedBorder
extends AbstractBorder {
    private Color _foreground = Color.BLACK;
    private Color _background = Color.WHITE;
    private static final Insets BORDER_INSETS = new Insets(2, 8, 2, 8);

    public void setForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("foreground is null");
        }
        this._foreground = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new NullPointerException("background is null");
        }
        this._background = color;
    }

    public Color getBackground() {
        return this._background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color color = graphics2D.getColor();
        Shape shape = graphics2D.getClip();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath();
            generalPath.append(new Arc2D.Double(n, n2, RoundedBorder.BORDER_INSETS.left * 2 - 1 + 5, n4 - 1, 90.0, 180.0, 0), true);
            generalPath2.append(new Arc2D.Double((double)n * 0.95, (double)n2 * 0.95, (double)(RoundedBorder.BORDER_INSETS.left * 2 - 1) * 0.95, (double)(n4 - 1) * 0.95, 90.0, 180.0, 0), true);
            generalPath.lineTo(n + n3 - RoundedBorder.BORDER_INSETS.right - 2, n2 + n4 - 1);
            generalPath2.lineTo((float)(n + n3 - RoundedBorder.BORDER_INSETS.right - 2) * 0.95f, (float)(n2 + n4 - 1) * 0.95f);
            generalPath.append(new Arc2D.Double(n + n3 - RoundedBorder.BORDER_INSETS.right * 2 - 1, n2, RoundedBorder.BORDER_INSETS.right * 2 - 1, n4 - 1, 270.0, 180.0, 0), true);
            generalPath2.append(new Arc2D.Double((double)(n + n3 - RoundedBorder.BORDER_INSETS.right * 2 - 1) * 0.98, (double)n2 * 0.98, (double)(RoundedBorder.BORDER_INSETS.right * 2 - 1) * 0.95, (double)(n4 - 1) * 0.95, 270.0, 180.0, 0), true);
            generalPath.lineTo(n + RoundedBorder.BORDER_INSETS.left, n2);
            generalPath2.lineTo((float)(n + RoundedBorder.BORDER_INSETS.left) * 0.95f, (float)n2 * 0.95f);
            graphics2D.setClip(generalPath2);
            graphics2D.setColor(this._background);
            graphics2D.fill(generalPath);
            graphics2D.setColor(this._foreground.brighter().brighter().brighter().brighter());
            graphics2D.draw(generalPath);
        }
        finally {
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics2D.setClip(shape);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return BORDER_INSETS;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = RoundedBorder.BORDER_INSETS.top;
        insets.left = RoundedBorder.BORDER_INSETS.left;
        insets.right = RoundedBorder.BORDER_INSETS.right;
        insets.bottom = RoundedBorder.BORDER_INSETS.bottom;
        return BORDER_INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new RoundedBorder());
        jPanel.setLayout(new BorderLayout());
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                jFrame.paint(jFrame.getGraphics());
            }
        });
        jTextField.setBorder(null);
        jPanel.add((Component)jTextField, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(jPanel2);
        jFrame.setContentPane(jPanel2);
        jFrame.setAlwaysOnTop(true);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

