/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.OracleStoredProgramDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandlerException;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDProviderRegistry;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Displayable;
import org.antlr.stringtemplate.StringTemplate;

public class OraclePackageMemberDnDHandler
extends DefaultRaptorCodeEditorDnDHandler
implements RaptorCodeEditorDnDHandler {
    @Override
    public String handleDrop(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            for (Displayable displayable : list) {
                stringBuilder.append(this.buildStatementForPkgMember((ChildObjectElement)displayable) + DefaultRaptorCodeEditorDnDHandler.NL);
            }
        }
        catch (Exception exception) {
            throw new RaptorCodeEditorDnDHandlerException(exception);
        }
        string = stringBuilder.toString();
        if (string == null || string.trim().length() == 0) {
            return super.handleDrop(list);
        }
        return string;
    }

    private String buildStatementForPkgMember(ChildObjectElement childObjectElement) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        URL uRL = null;
        String string6 = null;
        ArrayList<Argument> arrayList = null;
        boolean bl = true;
        try {
            if (childObjectElement != null) {
                uRL = childObjectElement.getURL();
                string = DBURLFormatHelper.getConnectionName(uRL);
                String string7 = DBURLFormatHelper.getBaseType(uRL);
                string2 = DBURLFormatHelper.getSchema(uRL);
                string3 = DBURLFormatHelper.getName(uRL);
                string4 = (String)childObjectElement.getProperty("NAME");
                string6 = (String)childObjectElement.getProperty("MEMBER_TYPE");
                if (!"PACKAGE BODY".equals(string7) && "FUNCTION".equals(string6) || "PROCEDURE".equals(string6)) {
                    arrayList = this.getArguments(string, string2, string3, string4);
                    bl = RaptorCodeEditorDnDProviderRegistry.isQualifyObjectName(this._worksheetConnectionName, string2);
                    string5 = this.generateSQL(string2, string3, string4, arrayList, string6, bl);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string5;
    }

    private String generateSQL(String string, String string2, String string3, ArrayList<Argument> arrayList, String string4, boolean bl) {
        String string5 = "";
        StringTemplate stringTemplate = null;
        String string6 = null;
        boolean bl2 = false;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string7 = null;
        String string8 = null;
        string6 = bl ? DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2) + "." + string3 : DBUtil.addDoubleQuote((String)string2) + "." + string3;
        if ("PROCEDURE".equals(string4)) {
            stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "ProcedureStatement");
        } else {
            bl2 = true;
            stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "FunctionStatement");
        }
        int n = 0;
        if (arrayList != null) {
            for (Argument argument : arrayList) {
                if ("OUT".equals(argument._argINOUT) && (argument._argName == null || argument._argName.trim().length() == 0)) {
                    string8 = argument._argDataType;
                    continue;
                }
                if (argument._argName == null) continue;
                if (stringArray == null) {
                    stringArray = new String[arrayList.size()];
                }
                stringArray[n] = argument._argName;
                if (string7 == null) {
                    stringArray2 = new String[arrayList.size()];
                }
                String string9 = "OBJECT".equals(argument._argDataType) || "TABLE".equals(argument._argDataType) ? (argument._argTypeOwner == null ? argument._argTypeName : argument._argTypeOwner + "." + argument._argTypeName) : (string7 = argument._argDataType);
                if (OracleStoredProgramDnDHandler.isCharType(argument._argDataType)) {
                    string7 = argument._argDataLength == null ? string7 + "(200)" : string7 + "(" + argument._argDataLength + ")";
                }
                stringArray2[n] = argument._argName + " " + string7;
                ++n;
            }
        }
        stringTemplate.setAttribute("objectName", (Object)string6);
        if (!bl2) {
            stringTemplate.setAttribute("paramList", stringArray);
            stringTemplate.setAttribute("procArgs", stringArray2);
        } else {
            stringTemplate.setAttribute("paramList", stringArray);
            stringTemplate.setAttribute("procArgs", stringArray2);
            stringTemplate.setAttribute("returnType", string8);
        }
        string5 = stringTemplate.toString() + "\n";
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Argument> getArguments(String string, String string2, String string3, String string4) {
        ArrayList<Argument> arrayList = new ArrayList<Argument>();
        Argument argument = null;
        String string5 = "select argument_name, data_type,  data_precision, data_scale, data_length, in_out, type_name, type_owner from all_arguments where package_name = :pkgName and object_name = :name AND  owner=:schema order by position";
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            hashMap.put("schema", string2);
            hashMap.put("pkgName", string3);
            hashMap.put("name", string4.toUpperCase());
            if (string != null && DBUtil.getConnectionResolver().lock(string)) {
                resultSet = DBUtil.getInstance((String)string).executeOracleQuery(string5, hashMap);
                while (resultSet != null && resultSet.next()) {
                    argument = new Argument(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8));
                    arrayList.add(argument);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (string != null) {
                DBUtil.getConnectionResolver().unlock(string);
            }
            DBUtil.closeResultSet(resultSet);
        }
        return arrayList;
    }

    private class Argument {
        String _argName;
        String _argDataType;
        String _argPrecision;
        String _argScale;
        String _argDataLength;
        String _argINOUT;
        String _argTypeName;
        String _argTypeOwner;

        Argument(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this._argName = string;
            this._argDataType = string2;
            this._argPrecision = string3;
            this._argScale = string4;
            this._argDataLength = string5;
            this._argINOUT = string6;
            this._argTypeName = string7;
            this._argTypeOwner = string8;
        }
    }
}

