/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.ImpExpPanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.ImportSource;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

class ImportPasswordPanel
extends ImpExpPanel {
    private JRadioButton m_btnKey;
    private JRadioButton m_btnStrip;
    private JPasswordField m_fldKey;

    ImportPasswordPanel() {
    }

    @Override
    protected void init(final TraversableContext traversableContext) {
        ImpExpFile impExpFile;
        ImpExpEngine.PasswordMode passwordMode;
        PasswordListener passwordListener = (PasswordListener)traversableContext.get("ImportExport.PASSWORD_LISTENER");
        if (passwordListener == null) {
            passwordListener = new PasswordListener(){

                @Override
                public TraversableContext getTraversableContext() {
                    return traversableContext;
                }
            };
            traversableContext.put("ImportExport.PASSWORD_LISTENER", (Object)passwordListener);
        }
        if ((passwordMode = (impExpFile = (ImpExpFile)traversableContext.get("ImportExport.SOURCE")).getMode()) == ImpExpEngine.PasswordMode.KEY) {
            this.m_btnKey.setSelected(true);
            String string = impExpFile.getKey();
            if (string != null) {
                this.m_fldKey.setText(string);
            }
        } else {
            this.m_btnStrip.setSelected(true);
        }
        System.out.println("Init(importPasswordPanel)");
        this.m_btnKey.addItemListener(passwordListener);
        this.m_fldKey.getDocument().addDocumentListener(passwordListener);
        this.updateButtonStates(traversableContext);
    }

    @Override
    protected void commit(TraversableContext traversableContext) throws TraversalException {
        PasswordListener passwordListener = (PasswordListener)traversableContext.get("ImportExport.PASSWORD_LISTENER");
        if (passwordListener != null) {
            this.m_btnKey.removeItemListener(passwordListener);
            this.m_fldKey.getDocument().removeDocumentListener(passwordListener);
        }
        ImportSource importSource = (ImportSource)traversableContext.get("ImportExport.SOURCE");
        if (this.m_btnStrip.isSelected()) {
            importSource.setMode(ImpExpEngine.PasswordMode.STRIP);
        } else {
            char[] cArray = this.m_fldKey.getPassword();
            if (cArray.length == 0) {
                throw new TraversalException(ImpExpResources.getString("ERROR_MISSING_KEY"), ImpExpResources.getString("TITLE_INVALID_KEY"));
            }
            importSource.setMode(ImpExpEngine.PasswordMode.KEY);
            importSource.setKey(new String(cArray));
            try {
                if (!importSource.isKeyValid()) {
                    throw new TraversalException(ImpExpResources.getString("ERROR_KEY_NOT_VALID"), ImpExpResources.getString("TITLE_INVALID_KEY"));
                }
            }
            catch (ConnectionException connectionException) {
                throw new TraversalException(ImpExpResources.format("FILE_READ_ERROR", importSource.getLabel()), ImpExpResources.getString("FILE_READ_ERROR_TITLE"));
            }
        }
        traversableContext.put("ImportExport.SOURCE", (Object)importSource);
    }

    @Override
    protected JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel();
        jMultiLineLabel.setText(ImpExpResources.getString("BOILERPLATE_PASSWORDS_IMPORT"));
        jPanel.add((Component)jMultiLineLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.XY));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_btnKey = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnKey, (String)ImpExpResources.getString("OPTION_IMPORT_KEY"));
        this.m_btnKey.setSelected(true);
        buttonGroup.add(this.m_btnKey);
        jPanel.add((Component)this.m_btnKey, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        this.m_fldKey = new JPasswordField();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldKey, (String)ImpExpResources.getString("LABEL_KEY"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_fldKey, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)LayoutControl.GBC.createSubPanel(jPanel2), LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.m_btnStrip = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnStrip, (String)ImpExpResources.getString("OPTION_STRIP_PASSWORDS"));
        buttonGroup.add(this.m_btnStrip);
        jPanel.add((Component)this.m_btnStrip, LayoutControl.GBC.gbc(0, 3, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        return jPanel;
    }

    @Override
    public String getHelpID() {
        return "f1_idedimportcxn_html";
    }

    @Override
    protected Boolean getBackButtonState(TraversableContext traversableContext) {
        return null;
    }

    @Override
    protected Boolean getNextButtonState(TraversableContext traversableContext) {
        if (this.m_btnKey.isSelected()) {
            char[] cArray = this.m_fldKey.getPassword();
            return cArray != null && cArray.length > 0;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean getFinishButtonState(TraversableContext traversableContext) {
        Object object;
        if (traversableContext != null && ((object = (Destination)traversableContext.get("ImportExport.DESTINATION")) != null || object.getConnectionsForCopy().size() == 0)) {
            return Boolean.FALSE;
        }
        if (this.m_btnKey.isSelected()) {
            object = this.m_fldKey.getPassword();
            return object != null && ((Object)object).length > 0;
        }
        return Boolean.TRUE;
    }

    private abstract class PasswordListener
    implements ItemListener,
    DocumentListener {
        private PasswordListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (ImportPasswordPanel.this.m_btnKey.isSelected()) {
                ImportPasswordPanel.this.m_fldKey.setEnabled(true);
            } else {
                ImportPasswordPanel.this.m_fldKey.setEnabled(false);
            }
            ImportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ImportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ImportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ImportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        public abstract TraversableContext getTraversableContext();
    }
}

