/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.impl.DatabaseTreeNode;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.model.CustomTreeModel;
import oracle.dbtools.raptor.navigator.model.DefaultNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public final class ImpExpController
implements Controller {
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ImpExpEngine.IMPORT_CMD_ID) {
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            if (databaseConnections != null) {
                ImpExpEngine impExpEngine = ImpExpEngine.createImportEngine(databaseConnections);
                impExpEngine.invoke();
            }
            return true;
        }
        if (n == ImpExpEngine.EXPORT_CMD_ID) {
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            ImpExpController.registerFolders(context, databaseConnections);
            if (databaseConnections != null) {
                ImpExpEngine impExpEngine = ImpExpEngine.createExportEngine(databaseConnections);
                impExpEngine.invoke();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ImpExpEngine.IMPORT_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == ImpExpEngine.EXPORT_CMD_ID) {
            boolean bl = false;
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            if (databaseConnections != null && databaseConnections.listConnections().size() > 0) {
                bl = true;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private static Map<DatabaseConnection, DefaultNavigatorTreeNode> registerFolders(Context context, DatabaseConnections databaseConnections) {
        DatabaseConnection databaseConnection;
        Object object;
        Object object2;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext(context);
        NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
        CustomTreeModel customTreeModel = navigatorTree.getModel();
        Vector<Object> vector = new Vector<Object>();
        HashMap<DatabaseConnection, DefaultNavigatorTreeNode> hashMap = new HashMap<DatabaseConnection, DefaultNavigatorTreeNode>();
        for (int i = 0; i < customTreeModel.getChildCount(navigatorTreeNode); ++i) {
            Object object3 = customTreeModel.getChild(navigatorTreeNode, i);
            if (object3 instanceof DefaultNavigatorTreeNode) {
                object2 = (DefaultNavigatorTreeNode)object3;
                object = ((NavigatorTreeNode)object2).getUserObject();
                if (!(object instanceof DatabasesFolder)) continue;
                vector.add(object2);
                continue;
            }
            if (!(object3 instanceof DatabaseTreeNode) || !((object = ((NavigatorTreeNode)(object2 = (DatabaseTreeNode)object3)).getUserObject()) instanceof DatabaseConnection)) continue;
            databaseConnection = null;
            Properties properties = null;
            try {
                databaseConnection = (DatabaseConnection)object;
                properties = databaseConnections.getProperties(databaseConnection.getConnectionName());
                properties.remove("NAV_FOLDER");
                databaseConnections.updateConnection(databaseConnection.getConnectionName(), null, properties);
                continue;
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        for (Object object3 : vector) {
            object2 = (DatabasesFolder)((Object)((NavigatorTreeNode)object3).getUserObject());
            object = object2.getChildren();
            while (object.hasNext()) {
                databaseConnection = (DatabaseConnection)object.next();
                if (!(databaseConnection instanceof DatabaseConnection)) continue;
                hashMap.put(databaseConnection, (DefaultNavigatorTreeNode)object3);
            }
        }
        if (hashMap.size() > 0) {
            for (Object object3 : hashMap.keySet()) {
                object2 = (DefaultNavigatorTreeNode)hashMap.get(object3);
                try {
                    object = databaseConnections.getProperties(((DatabaseConnection)object3).getConnectionName());
                    ((Properties)object).put("NAV_FOLDER", ((DatabasesFolder)((Object)((NavigatorTreeNode)object2).getUserObject())).getName());
                    databaseConnections.updateConnection(((DatabaseConnection)object3).getConnectionName(), null, (Properties)object);
                }
                catch (ConnectionException connectionException) {}
            }
        }
        return hashMap;
    }

    private static DatabaseConnections getStore(Context context) {
        DatabaseConnections databaseConnections = null;
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 1) {
            Databases databases = (Databases)elementArray[0];
            databaseConnections = DatabaseConnectionStores.getInstance().getStore(databases.getStoreId());
        }
        return databaseConnections;
    }
}

