/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.Messages;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;

public class PlSqlCompilerOptionsPanel
extends oracle.ide.db.panels.plsql.PlSqlCompilerOptionsPanel {
    private ListCellRenderer m_valRenderer = new ValueRenderer();
    private JCheckBox chkDropTypeForce = new JCheckBox();
    private JTextField profilerDir = new JTextField();
    private JComboBox optimLevel = new JComboBox();
    private JComboBox plScopeSettings = new JComboBox();
    private static String[] levels = new String[]{"0", "1", "2", "3"};
    private static String[] identifiers = new String[]{Messages.getString("PlSqlCompilerOptionsPanel.3"), Messages.getString("PlSqlCompilerOptionsPanel.4")};

    public PlSqlCompilerOptionsPanel() throws Exception {
        this.setHelpID("f1_idedidesetplsqlcompiler_html");
        this.jbInit();
    }

    private static PlSqlCompilerOptions findCompilerOptions(TraversableContext traversableContext) {
        return GlobalSettings.createGlobalSettings((PropertyStorage)traversableContext.getPropertyStorage()).getPlSqlCompilerOptions();
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        PlSqlCompilerOptions plSqlCompilerOptions = PlSqlCompilerOptionsPanel.findCompilerOptions(traversableContext);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.profilerDir.setText(dBConfig.getString("PLSQLPROFILERDIR"));
        this.optimLevel.setModel(new DefaultComboBoxModel<String>(levels));
        this.optimLevel.setSelectedItem(dBConfig.getString("PLSQLOPTIMLEVEL"));
        this.plScopeSettings.setModel(new DefaultComboBoxModel<String>(identifiers));
        this.plScopeSettings.setSelectedItem(dBConfig.getString("PLSQLSCOPE"));
        this.chkDropTypeForce.setSelected(dBConfig.getBoolean("DROPTYPEFORCE"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        PlSqlCompilerOptions plSqlCompilerOptions = PlSqlCompilerOptionsPanel.findCompilerOptions(traversableContext);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PLSQLPROFILERDIR", this.profilerDir.getText());
        dBConfig.putString("PLSQLOPTIMLEVEL", (String)this.optimLevel.getSelectedItem());
        dBConfig.putString("PLSQLSCOPE", (String)this.plScopeSettings.getSelectedItem());
        dBConfig.putBoolean("DROPTYPEFORCE", this.chkDropTypeForce.isSelected());
        super.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        int n = 6;
        ResourceUtils.resButton((AbstractButton)this.chkDropTypeForce, (String)Messages.getString("PlSqlCompilerOptionsPanel.DropTypeForce"));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.optimLevel, (String)Messages.getString("PlSqlCompilerOptionsPanel.6"));
        this.add(jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 40, 0));
        this.add(this.optimLevel, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 40, 0));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.plScopeSettings, (String)Messages.getString("PlSqlCompilerOptionsPanel.7"));
        this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 40, 0));
        this.add(this.plScopeSettings, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 40, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 40, 0));
        this.add(this.chkDropTypeForce, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 40, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 40, 0));
        Object object = null;
        try {
            Class<oracle.ide.db.panels.plsql.PlSqlCompilerOptionsPanel> clazz = oracle.ide.db.panels.plsql.PlSqlCompilerOptionsPanel.class;
            Field field = clazz.getDeclaredField("m_chkDebug");
            field.setAccessible(true);
            object = field.get((Object)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object != null) {
            this.remove((Container)object);
        }
    }

    private static class ValueRenderer
    extends DefaultListCellRenderer {
        private ValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                object = " ";
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private static class ValueModel
    implements ComboBoxModel {
        private PlSqlCompilerOptions.WarningValue m_selObj;

        private ValueModel() {
        }

        @Override
        public void setSelectedItem(Object object) {
            this.m_selObj = (PlSqlCompilerOptions.WarningValue)object;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_selObj;
        }

        @Override
        public int getSize() {
            return PlSqlCompilerOptions.WarningValue.values().length + 1;
        }

        @Override
        public Object getElementAt(int n) {
            return n == 0 ? null : PlSqlCompilerOptions.WarningValue.values()[n - 1];
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

