/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.NavigationFilterTreeRefresher;
import oracle.dbtools.raptor.config.NavigatorFilterConfig;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public class NavigationFilterChangeListener
extends StructureChangeListener {
    Collection<String> m_openConns = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(NavigationFilterChangeListener.class.getName());
    private static final String NAVIGATIONFILTER_ENABLE_FEATURE = "NAVIGATIONFILTER/NAVIGATIONFILTER/ENABLE_FEATURE";
    private static final String NAVIGATIONFILTER_ORACLE = "NAVIGATIONFILTER/NAVIGATIONFILTER/ORACLE";
    private static final String NAVIGATIONFILTER_MYSQL = "NAVIGATIONFILTER/NAVIGATIONFILTER/MYSQL";
    private static final String NAVIGATIONFILTER_DB2 = "NAVIGATIONFILTER/NAVIGATIONFILTER/DB2";
    private static final String NAVIGATIONFILTER_SYBASE = "NAVIGATIONFILTER/NAVIGATIONFILTER/SYBASE";
    private static final String NAVIGATIONFILTER_TERADATA = "NAVIGATIONFILTER/NAVIGATIONFILTER/TERADATA";
    private static final String NAVIGATIONFILTER_TIMESTEN = "NAVIGATIONFILTER/NAVIGATIONFILTER/TIMESTEN";
    private static final String NAVIGATIONFILTER_SQLSERVER = "NAVIGATIONFILTER/NAVIGATIONFILTER/SQLSERVER";
    private static final String NAVIGATIONFILTER_POSTGRESQL = "NAVIGATIONFILTER/NAVIGATIONFILTER/POSTGRESQL";
    private static final String NAVIGATIONFILTER_ACCESS = "NAVIGATIONFILTER/NAVIGATIONFILTER/ACCESS";
    private NavigationFilterTreeRefresher navigatorRefresher = new NavigationFilterTreeRefresher();

    public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
        for (int i = 0; i < changeInfoArray.length; ++i) {
            ChangeInfo changeInfo = changeInfoArray[i];
            String string = changeInfo.getPropertyName();
            String string2 = changeInfo.getPropertyLocalName();
            String string3 = changeInfo.getClass().getName();
            String string4 = changeInfo.getNewValueAsString();
            String string5 = changeInfo.getOldValueAsString();
            if (string.startsWith(NAVIGATIONFILTER_ENABLE_FEATURE) && string4 != string5) {
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_ORACLE) && string4 != string5 && !bl3) {
                bl3 = true;
                this.updateOraclePreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_MYSQL) && string4 != string5 && !bl4) {
                bl4 = true;
                this.updateMySQLPreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_DB2) && string4 != string5 && !bl5) {
                bl5 = true;
                this.updateDB2Preferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_SYBASE) && string4 != string5 && !bl9) {
                bl9 = true;
                this.updateSybasePreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_TERADATA) && string4 != string5 && !bl10) {
                bl10 = true;
                this.updateTeradataPreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_TIMESTEN) && string4 != string5 && !bl6) {
                bl6 = true;
                this.updateTimesTenPreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_SQLSERVER) && string4 != string5 && !bl7) {
                bl7 = true;
                this.updateSQLServerPreferences();
                bl = true;
            }
            if (string.startsWith(NAVIGATIONFILTER_POSTGRESQL) && string4 != string5 && !bl8) {
                bl8 = true;
                this.updatePostGreSQLPreferences();
                bl = true;
            }
            if (!string.startsWith(NAVIGATIONFILTER_ACCESS) || string4 == string5 || bl2) continue;
            bl2 = true;
            this.updateAccessPreferences();
            bl = true;
        }
        if (bl) {
            this.navigatorRefresher.refresh();
        }
    }

    private void printHashSet(Collection<String> collection) {
        int n = collection.size();
        String[] stringArray = new String[n];
        collection.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("----NavigationFilterChangeListener.printHashSet(" + i + ") = " + stringArray[i]);
        }
    }

    private void updateOraclePreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("ORACLE");
    }

    private void updateMySQLPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("MYSQL");
    }

    private void updateDB2Preferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("DB2");
    }

    private void updateSybasePreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("SYBASE");
    }

    private void updateTeradataPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("TERADATA");
    }

    private void updateTimesTenPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("TIMESTEN");
    }

    private void updateSQLServerPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("SQLSERVER");
    }

    private void updatePostGreSQLPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("POSTGRESQL");
    }

    private void updateAccessPreferences() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        navigatorFilterConfig.updateNavigationFilterPreferences("ACCESS");
    }
}

