/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ide.net.URIFactory;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudAddin;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.cloud.navigator.ViewerStyle;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;

public class FolderTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((CloudFolder)this.getElement());
    }

    private class LoadTask
    extends CloudTask<Collection<Element>> {
        private CloudFolder m_owner;
        private String m_cName;

        LoadTask(CloudFolder cloudFolder) {
            super(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            this.m_owner = cloudFolder;
            this.m_cName = cloudFolder.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            List<Element> list = null;
            if (this.m_cName != null) {
                final CloudObjectType cloudObjectType = this.m_owner.getObjectType();
                try {
                    CConnection cConnection = CConnections.getInstance().getConnection(this.m_cName, false);
                    final URL uRL = this.m_owner.getURL();
                    if (cConnection != null) {
                        Logger.fine(CloudAddin.class, (String)("CloudFolderFilter.getChildren() for " + uRL.toString()));
                        list = cConnection.executeQuery(this.m_owner.getRemoteURI(), new JSONNodeHandler<List<Element>>(){

                            @Override
                            protected List<Element> build(JSONNode jSONNode) throws IOException {
                                ArrayList<Element> arrayList = new ArrayList<Element>();
                                JSONObject jSONObject = (JSONObject)jSONNode;
                                JSONArray jSONArray = (JSONArray)JSONUtils.getValue(jSONObject, "items");
                                for (Object t : jSONArray.values()) {
                                    JSONObject jSONObject2 = (JSONObject)t;
                                    Logger.fine(CloudAddin.class, (String)("childValue: " + jSONObject2.toString()));
                                    String string = (String)JSONUtils.getValue(jSONObject2, "object_name");
                                    JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue(jSONObject2, "uri");
                                    String string2 = (String)JSONUtils.getValue(jSONObject3, "$ref");
                                    try {
                                        URL uRL2 = DBURLFormatHelper.getURL(uRL, string);
                                        CloudObject cloudObject = (CloudObject)NodeFactory.findOrCreate(CloudObject.class, (URL)uRL2);
                                        cloudObject.setCloudObjectType(cloudObjectType);
                                        cloudObject.setRemoteURI(URIFactory.newURI((String)string2));
                                        arrayList.add(cloudObject);
                                    }
                                    catch (Exception exception) {}
                                }
                                return arrayList;
                            }
                        });
                        if (list != null && list.size() > 0) {
                            CloudObject cloudObject = (CloudObject)list.get(0);
                            URI uRI = cloudObject.getRemoteURI();
                            LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap();
                            linkedHashMap = cConnection.executeQuery(uRI, new JSONNodeHandler<LinkedHashMap<String, CloudViewerDetail>>(){

                                @Override
                                protected LinkedHashMap<String, CloudViewerDetail> build(JSONNode jSONNode) throws IOException {
                                    LinkedHashMap<String, CloudViewerDetail> linkedHashMap = new LinkedHashMap<String, CloudViewerDetail>();
                                    JSONObject jSONObject = (JSONObject)jSONNode;
                                    JSONArray jSONArray = (JSONArray)JSONUtils.getValue(jSONObject, "items");
                                    for (Object t : jSONArray.values()) {
                                        JSONObject jSONObject2 = (JSONObject)t;
                                        String string = (String)JSONUtils.getValue(jSONObject2, "viewer");
                                        String string2 = (String)JSONUtils.getValue(jSONObject2, "style");
                                        JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue(jSONObject2, "uri");
                                        String string3 = (String)JSONUtils.getValue(jSONObject3, "$ref");
                                        linkedHashMap.put(string, new CloudViewerDetail(ViewerStyle.getStyle(string2), string3));
                                    }
                                    return linkedHashMap;
                                }
                            });
                            for (Element element : list) {
                                LinkedHashMap<String, CloudViewerDetail> linkedHashMap2 = new LinkedHashMap<String, CloudViewerDetail>();
                                for (String string : linkedHashMap.keySet()) {
                                    CloudViewerDetail cloudViewerDetail = (CloudViewerDetail)linkedHashMap.get(string);
                                    String string2 = cloudViewerDetail.getUriString().replace(cloudObject.getName().replace(" ", "%20"), ((CloudObject)element).getName());
                                    CloudViewerDetail cloudViewerDetail2 = new CloudViewerDetail(cloudViewerDetail.getStyle(), string2);
                                    linkedHashMap2.put(string, cloudViewerDetail2);
                                }
                                ((CloudObject)element).setViewers(linkedHashMap2);
                            }
                        }
                    }
                }
                catch (CConnectionException cConnectionException) {
                    Logger.warn(CloudController.class, (Throwable)cConnectionException);
                    throw new TaskException((Throwable)cConnectionException);
                }
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

