/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.DefaultClient;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class Client {
    private static Map<CConnectionType, Client> s_clients = new HashMap<CConnectionType, Client>();
    private CConnectionType m_type;

    public static synchronized Client getClient(CConnectionType cConnectionType, CConnectionInfo cConnectionInfo) {
        Client client = s_clients.get(cConnectionType);
        if (client == null) {
            client = new DefaultClient(cConnectionType);
            s_clients.put(cConnectionType, client);
        }
        return client;
    }

    protected Client(CConnectionType cConnectionType) {
        this.m_type = cConnectionType;
    }

    public abstract AuthenticationEngine getAuthenticationEngine();

    public abstract HttpResponse executeRequest(HttpUriRequest var1) throws ClientProtocolException, IOException;

    public abstract <T> T executeRequest(HttpUriRequest var1, ResponseHandler<? extends T> var2) throws ClientProtocolException, IOException;

    public final CConnectionType getConnectionType() {
        return this.m_type;
    }

    public static Reader createReader(HttpResponse httpResponse) {
        HttpEntity httpEntity = httpResponse.getEntity();
        Header header = httpEntity.getContentEncoding();
        try {
            return new BufferedReader(new InputStreamReader(httpEntity.getContent()));
        }
        catch (Exception exception) {
            return new StringReader("");
        }
    }
}

