/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.TreeMap;
import oracle.dbtools.raptor.controls.search.PastLookup;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;

public class SerializedData
extends Observable
implements Serializable {
    List<PastLookup> searchHistory = new LinkedList<PastLookup>();
    public boolean dbSearchSchemaTreeNodeInfoShown = false;
    public boolean dbSearchAllSourcePatternInfoShown = false;
    public TreeMap<String, Boolean> explainOptions = new TreeMap();
    public TreeMap<String, Boolean> autotraceOptions = new TreeMap();
    public boolean myStat = true;
    public boolean abbrevStat = true;
    public boolean fetchAll = false;
    private static SerializedData instance = null;
    public static final String predicates_branch = "Predicates Branch";
    public static final String predicates_column = "Predicates Column";
    public static final String projection_branch = "Projection Branch";
    public static final String projection_column = "Projection Column";
    public static final String otherxml_branch = "Other XML Branch";
    public static final String otherxml_column = "Other XML Column";
    private static final String fname = "db.serial";

    public static SerializedData getInstance() {
        if (instance == null) {
            try {
                instance = SerializedData.read();
            }
            catch (Exception exception) {
                instance = new SerializedData();
                SerializedData.instance.autotraceOptions.put("OBJECT_NAME", true);
                SerializedData.instance.autotraceOptions.put("OBJECT_NODE", false);
                SerializedData.instance.autotraceOptions.put("OBJECT_OWNER", false);
                SerializedData.instance.autotraceOptions.put("OBJECT_ALIAS", false);
                SerializedData.instance.autotraceOptions.put("OBJECT_TYPE", false);
                SerializedData.instance.autotraceOptions.put("OPTIONS", false);
                SerializedData.instance.autotraceOptions.put("COST", true);
                SerializedData.instance.autotraceOptions.put("CARDINALITY", true);
                SerializedData.instance.autotraceOptions.put("OPTIMIZER", false);
                SerializedData.instance.autotraceOptions.put("SEARCH_COLUMNS", false);
                SerializedData.instance.autotraceOptions.put("POSITION", false);
                SerializedData.instance.autotraceOptions.put("OTHER_TAG", false);
                SerializedData.instance.autotraceOptions.put("LAST_OUTPUT_ROWS", false);
                SerializedData.instance.autotraceOptions.put("LAST_CR_BUFFER_GETS", true);
                SerializedData.instance.autotraceOptions.put("LAST_ELAPSED_TIME", true);
                SerializedData.instance.autotraceOptions.put("LAST_STARTS", false);
                SerializedData.instance.autotraceOptions.put("LAST_DISK_READS", false);
                SerializedData.instance.autotraceOptions.put("LAST_DISK_WRITES", false);
                SerializedData.instance.autotraceOptions.put("LAST_CU_BUFFER_GETS", false);
                SerializedData.instance.autotraceOptions.put(predicates_branch, true);
                SerializedData.instance.autotraceOptions.put(predicates_column, false);
                SerializedData.instance.autotraceOptions.put(projection_branch, false);
                SerializedData.instance.autotraceOptions.put(otherxml_branch, false);
                SerializedData.instance.explainOptions.put("OBJECT_NAME", true);
                SerializedData.instance.explainOptions.put("OBJECT_NODE", false);
                SerializedData.instance.explainOptions.put("OBJECT_OWNER", false);
                SerializedData.instance.explainOptions.put("OBJECT_ALIAS", false);
                SerializedData.instance.explainOptions.put("OBJECT_TYPE", false);
                SerializedData.instance.explainOptions.put("OPTIONS", false);
                SerializedData.instance.explainOptions.put("COST", true);
                SerializedData.instance.explainOptions.put("CPU_COST", false);
                SerializedData.instance.explainOptions.put("IO_COST", false);
                SerializedData.instance.explainOptions.put("CARDINALITY", true);
                SerializedData.instance.explainOptions.put("OPTIMIZER", false);
                SerializedData.instance.explainOptions.put("SEARCH_COLUMNS", false);
                SerializedData.instance.explainOptions.put("DEPTH", false);
                SerializedData.instance.explainOptions.put("POSITION", false);
                SerializedData.instance.explainOptions.put("OTHER_TAG", false);
                SerializedData.instance.explainOptions.put("PARTITION_ID", false);
                SerializedData.instance.explainOptions.put("DISTRIBUTION", false);
                SerializedData.instance.explainOptions.put(predicates_branch, true);
                SerializedData.instance.explainOptions.put(predicates_column, false);
                SerializedData.instance.explainOptions.put(projection_branch, false);
                SerializedData.instance.explainOptions.put(otherxml_branch, true);
            }
        }
        return instance;
    }

    public static void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(SerializedData.getURL().getFile());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(SerializedData.getInstance());
            objectOutputStream.close();
            instance.setChanged();
            instance.notifyObservers();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private static SerializedData read() throws IOException, ClassNotFoundException {
        InputStream inputStream = SerializedData.getURL().openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        SerializedData serializedData = (SerializedData)objectInputStream.readObject();
        objectInputStream.close();
        if (serializedData.autotraceOptions.get("LAST_DISK_READS") == null) {
            serializedData.autotraceOptions.put("LAST_DISK_READS", false);
        }
        if (serializedData.autotraceOptions.get("LAST_CU_BUFFER_GETS") == null) {
            serializedData.autotraceOptions.put("LAST_CU_BUFFER_GETS", false);
        }
        if (serializedData.autotraceOptions.get("LAST_DISK_WRITES") == null) {
            serializedData.autotraceOptions.put("LAST_DISK_WRITES", false);
        }
        return serializedData;
    }

    private static URL getURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    public void logHistory(PastLookup pastLookup) {
        this.searchHistory.remove(pastLookup);
        this.searchHistory.add(0, pastLookup);
        if (1000 < this.searchHistory.size()) {
            this.searchHistory.remove(1000);
        }
        SerializedData.write();
    }

    public List<PastLookup> getHistory() {
        return this.searchHistory;
    }
}

