/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.qbql;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.qbql.Database;
import oracle.dbtools.qbql.QbqlProgram;
import oracle.dbtools.util.Service;

public class Query {
    private static Parsed prg = null;
    private static QbqlProgram programInstance = null;
    private List<String> inlineRelVars = new LinkedList<String>();
    private Database database;

    public Query(String string, Database database) throws IOException {
        ParseNode parseNode;
        this.database = database;
        List list = LexerToken.parse((String)string);
        Map<String, MaterializedPredicate> map = QbqlProgram.runProgram(string, list, Service.readFile(Query.class, (String)"qbql.prg"), prg, programInstance);
        MaterializedPredicate materializedPredicate = map.get("inlineTables");
        for (int i = 0; materializedPredicate != null && i < materializedPredicate.cardinality(); ++i) {
            parseNode = materializedPredicate.getAttribute(i, "table");
            this.inlineRelVars.add(parseNode.content(list));
        }
        HashSet<String> hashSet = new HashSet<String>();
        parseNode = map.get("relvars");
        for (int i = 0; parseNode != null && i < parseNode.cardinality(); ++i) {
            ParseNode parseNode2 = parseNode.getAttribute(i, "relvar");
            hashSet.add(parseNode2.content(list));
        }
        database.refreshCache(hashSet);
    }

    public String translateInlineVar(String string) {
        return string + " ";
    }

    public String translate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.database.tabColumns);
        for (String string : this.inlineRelVars) {
            stringBuilder.append(this.translateInlineVar(string));
        }
        return stringBuilder.toString();
    }
}

