/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptionsListener;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStyleSQLPreferences;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileRepository;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class CodingStyleManagerImpl
extends CodingStyleManager {
    private CodingStyleSQLProfile profile;
    private CodingStyleSQLProfile localProfile = new CodingStyleSQLProfile();
    private CodingStyleSQLOptionsListener profileListener = new ProfileListener();

    public CodingStyleManagerImpl() {
        CodingStyleSQLPreferences codingStyleSQLPreferences = this.getCodingStyleSQLPreferences();
        codingStyleSQLPreferences.addPropertyChangeListener(new PreferencesListener());
        this.updateProfile();
    }

    @Override
    public CodingStyleSQLOptions getCodingStyleSQLOptions() {
        return this.localProfile;
    }

    @Override
    public CodingStyleSQLOptions getCodingStyleSQLOptions(Context context) {
        return this.getCodingStyleSQLOptions();
    }

    private void updateProfile() {
        if (this.profile != null) {
            this.profile.removeCodingStyleOptionsListener(this.profileListener);
        }
        CodingStyleSQLPreferences codingStyleSQLPreferences = this.getCodingStyleSQLPreferences();
        NameAndDatabase nameAndDatabase = null;
        if (codingStyleSQLPreferences.getActiveProfile() != null) {
            nameAndDatabase = new NameAndDatabase(codingStyleSQLPreferences.getActiveProfile());
        }
        ProfileRepository profileRepository = ProfileRepository.getProfileRepository();
        if (nameAndDatabase != null) {
            this.profile = null;
            if (profileRepository.containsKey(nameAndDatabase)) {
                this.profile = profileRepository.getProfile(nameAndDatabase);
            }
        }
        if (this.profile == null) {
            this.profile = profileRepository.getDefaultProfileByDatabase(1);
        }
        if (this.profile != null) {
            this.profile.copyTo(this.localProfile);
            this.profile.addCodingStyleOptionsListener(this.profileListener);
        }
    }

    private CodingStyleSQLPreferences getCodingStyleSQLPreferences() {
        return CodingStyleSQLPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private class ProfileListener
    implements CodingStyleSQLOptionsListener {
        private ProfileListener() {
        }

        @Override
        public void optionsChanged(CodingStyleSQLOptions codingStyleSQLOptions) {
            CodingStyleManagerImpl.this.updateProfile();
        }
    }

    private class PreferencesListener
    implements PropertyChangeListener {
        private PreferencesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CodingStyleManagerImpl.this.updateProfile();
        }
    }
}

