/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences;

import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.treePreferences.SQLPreferences;
import oracle.javatools.data.HashStructure;

public final class SQLSourcePreferences
implements SQLPreferences {
    private final HashStructure hash;

    public static SQLSourcePreferences copy(SQLSourcePreferences sQLSourcePreferences) {
        HashStructure hashStructure = sQLSourcePreferences.hash;
        HashStructure hashStructure2 = hashStructure.copyTo(null);
        return new SQLSourcePreferences(hashStructure2);
    }

    public static SQLSourcePreferences createCascadingPreferences(SQLSourcePreferences sQLSourcePreferences) {
        HashStructure hashStructure = sQLSourcePreferences.hash;
        HashStructure hashStructure2 = HashStructure.newInstance();
        HashStructure[] hashStructureArray = new HashStructure[]{hashStructure2, hashStructure};
        HashStructure hashStructure3 = HashStructure.newChainForOverriding((HashStructure[])hashStructureArray);
        return new SQLSourcePreferences(hashStructure3);
    }

    public SQLSourcePreferences() {
        this.hash = HashStructure.newInstance();
    }

    public SQLSourcePreferences(HashStructure hashStructure) {
        this.hash = hashStructure;
    }

    public boolean getBoolean(int n) {
        String string = SQLSourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getBoolean(string);
        }
        Boolean bl = (Boolean)PREFERENCES_defaults[n - 0];
        return bl;
    }

    public void setBoolean(int n, boolean bl) {
        String string = SQLSourcePreferences.setting2key(n);
        Boolean bl2 = (Boolean)PREFERENCES_defaults[n - 0];
        this.hash.putBoolean(string, bl);
    }

    public String getString(int n) {
        String string = SQLSourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getString(string);
        }
        String string2 = (String)PREFERENCES_defaults[n - 0];
        return string2;
    }

    public void setString(int n, String string) {
        String string2 = SQLSourcePreferences.setting2key(n);
        String string3 = (String)PREFERENCES_defaults[n - 0];
        this.hash.putString(string2, string);
    }

    public int getInt(int n) {
        String string = SQLSourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getInt(string);
        }
        Integer n2 = (Integer)PREFERENCES_defaults[n - 0];
        return n2;
    }

    public void setInt(int n, int n2) {
        String string = SQLSourcePreferences.setting2key(n);
        Integer n3 = (Integer)PREFERENCES_defaults[n - 0];
        this.hash.putInt(string, n2);
    }

    private HashStructure getHashStructure(int n) {
        String string = SQLSourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getHashStructure(string);
        }
        return null;
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.getHashStructure(47);
    }

    public byte getMemberOrder(int n) {
        String string = SQLSourcePreferences.setting2key(47);
        HashStructure hashStructure = this.hash.getHashStructure(string);
        byte by = SQLPreferences.MemberOrder.MEMBER_default[n];
        if (hashStructure == null) {
            return by;
        }
        String string2 = SQLSourcePreferences.member2key(n);
        byte by2 = -1;
        if (hashStructure.containsKey(string2)) {
            by2 = (byte)hashStructure.getInt(string2);
        }
        if (by2 >= 0) {
            return by2;
        }
        return by;
    }

    public void setMemberOrder(int n, byte by) {
        String string = SQLSourcePreferences.setting2key(47);
        HashStructure hashStructure = this.hash.getOrCreateHashStructure(string);
        String string2 = SQLSourcePreferences.member2key(n);
        hashStructure.putInt(string2, (int)by);
    }

    public void reloadAll(Object[] objectArray) {
        for (int i = 0; i < 51; ++i) {
            int n;
            Comparable<Boolean> comparable;
            int n2 = i + 0;
            Object object = objectArray[i];
            if (object instanceof Boolean) {
                comparable = (Boolean)object;
                n = ((Boolean)comparable).booleanValue();
                this.setBoolean(n2, n != 0);
                continue;
            }
            if (!(object instanceof Integer)) continue;
            comparable = (Integer)object;
            n = (Integer)comparable;
            this.setInt(n2, n);
        }
    }

    private static String setting2key(int n) {
        if (0 <= n && n < 51) {
            return PREFERENCES_keys[n - 0];
        }
        throw new IllegalStateException(SQLFormatterArb.getString("SQLSourcePreferences_INVALID_SETTING") + n);
    }

    private static String member2key(int n) {
        if (0 <= n && n < 11) {
            return SQLPreferences.MemberOrder.MEMBER_keys[n];
        }
        throw new IllegalStateException(SQLFormatterArb.getString("SQLSourcePreferences_INVALID_NUMBER") + n);
    }
}

