/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.proformatter.Messages;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileRepository;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class SQLFormatCommand
extends Command {
    private UndoableEdit _undoableEdit;

    public SQLFormatCommand(int n, int n2, String string) {
        super(n, n2, string);
    }

    public SQLFormatCommand(Context context) {
        super(-1, 0, "Format SQL Command");
        this.setContext(context);
    }

    public SQLFormatCommand() {
        super(-1, 0, "Format SQL Command");
    }

    public void init() {
        SQLFormatter.getInstance();
    }

    public int doit() {
        if (this._undoableEdit == null) {
            View view = this.context.getView();
            if (view instanceof BasicEditorPaneContainer) {
                TextNode textNode = (TextNode)this.context.getNode();
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                textBuffer.beginEdit();
                BasicEditorPaneContainer basicEditorPaneContainer = (BasicEditorPaneContainer)view;
                BasicEditorPane basicEditorPane = basicEditorPaneContainer.getFocusedEditorPane();
                if (basicEditorPane != null) {
                    boolean bl;
                    boolean bl2 = bl = basicEditorPane.getSelectionEnd() - basicEditorPane.getSelectionStart() > 0;
                    if (bl) {
                        try {
                            int n = basicEditorPane.getSelectionStart();
                            int n2 = basicEditorPane.getSelectionEnd();
                            String string = basicEditorPane.getDocument().getText(n, n2 - n);
                            String string2 = this.formatScript(string);
                            if (!this.outputStringToClipboard(string2)) {
                                textBuffer.remove(n, n2 - n);
                                textBuffer.insert(n, string2.toCharArray());
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                        }
                    } else {
                        String string = this.formatScript(basicEditorPane.getText());
                        if (!this.outputStringToClipboard(string)) {
                            textBuffer.removeToEnd(0);
                            textBuffer.insert(0, string.toCharArray());
                        }
                    }
                }
                this._undoableEdit = textBuffer.endEdit();
                textNode.releaseTextBuffer();
            }
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    public boolean outputStringToClipboard(String string) {
        return false;
    }

    public CodingStyleSQLOptions alterOptions(CodingStyleSQLOptions codingStyleSQLOptions) {
        return codingStyleSQLOptions;
    }

    public int getPlatformInt(String string) {
        if (string.equals("DB2")) {
            return 2;
        }
        if (string.equals("ACCESS")) {
            return 4;
        }
        if (string.equals("Microsoft SQL Server")) {
            return 5;
        }
        if (string.equals("Sybase")) {
            return 3;
        }
        if (string.equals("MySQL")) {
            return 6;
        }
        if (string.equals("Oracle")) {
            return 1;
        }
        if (string.equals("TimesTen")) {
            return 1;
        }
        return -1;
    }

    public CodingStyleSQLOptions alterOptionsForPlatform(CodingStyleSQLOptions codingStyleSQLOptions) {
        if (this.getContext() == null) {
            return codingStyleSQLOptions;
        }
        String string = (String)this.getContext().getProperty("Connections.db_name");
        if (string == null) {
            return codingStyleSQLOptions;
        }
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return codingStyleSQLOptions;
        }
        String string2 = properties.getProperty("RaptorConnectionType");
        if (string2 == null) {
            return codingStyleSQLOptions;
        }
        int n = this.getPlatformInt(string2);
        if (n == -1) {
            return codingStyleSQLOptions;
        }
        if (codingStyleSQLOptions.getSourceSql() != n) {
            NameAndDatabase nameAndDatabase = new NameAndDatabase("SQL", n);
            return ProfileRepository.getProfileRepository().getProfile(nameAndDatabase);
        }
        return codingStyleSQLOptions;
    }

    public String reallyDoIt(String string) {
        this.init();
        CodingStyleSQLOptions codingStyleSQLOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
        if (this.getContext() != null) {
            codingStyleSQLOptions = this.alterOptionsForPlatform(codingStyleSQLOptions);
        }
        codingStyleSQLOptions = this.alterOptions(codingStyleSQLOptions);
        String string2 = codingStyleSQLOptions.format(string);
        if (!(codingStyleSQLOptions.getReplaceComment() || codingStyleSQLOptions.getSuppressComment() || codingStyleSQLOptions.getTargetSql() != 0 || codingStyleSQLOptions.getSqlsourceCopied() || codingStyleSQLOptions.getForceDifference() || this.verifyResult(string, string2))) {
            Ide.getStatusBar().setText(Messages.getString("SQLFormatCommand.8"));
            return string;
        }
        if (string2 == null || string2.trim().equals("") && string != null && !string.trim().equals("")) {
            Ide.getStatusBar().setText(Messages.getString("SQLFormatCommand.8"));
            return string;
        }
        Ide.getStatusBar().setText(Messages.getString("SQLFormatCommand.9"));
        return string2;
    }

    public boolean verifyResult(String string, String string2) {
        String string3;
        String string4 = this.removeWhiteSpace(string.toLowerCase());
        return string4.equals(string3 = this.removeWhiteSpace(string2.toLowerCase()));
    }

    public String removeWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuffer = stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String formatScript(String string) {
        String string2 = "";
        string2 = this.reallyDoIt(string);
        if (string.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if (string.endsWith(" ")) {
            string2 = string2 + " ";
        }
        return string2;
    }

    public int undo() {
        if (this._undoableEdit != null) {
            this._undoableEdit.undo();
        }
        return 0;
    }

    public String formatSQL(TextBuffer textBuffer) {
        int n = textBuffer.getLength();
        char[] cArray = textBuffer.getChars(0, n);
        String string = new String(cArray);
        if (string.trim().equals("")) {
            return string;
        }
        String string2 = this.reallyDoIt(string);
        return string2;
    }
}

