/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.proformatter.SQLFormatCommand;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManagerImpl;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.util.Util;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.PlatformUtils;

public class FormatCommandProcessor
implements HeadlessCommandProcessor {
    public static int CHUNKSIZE = 1000;
    public static String INPUT = "input=";
    public static String OUTPUT = "output=";
    public static String CWD = "currentDirectory=";
    public static String USAGE = MessageFormat.format("format {0}{1} {2}{3}", INPUT, SQLFormatterArb.getString("FULL_INPUT_FILE_PATH"), OUTPUT, SQLFormatterArb.getString("FULL_OUTPUT_FILE_PATH"));

    @Override
    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length > 0) {
            FormatCommandTask formatCommandTask = new FormatCommandTask("SQLFormat", stringArray);
            return formatCommandTask;
        }
        System.out.println(this.getUsageString());
        return null;
    }

    @Override
    public String getUsageString() {
        return USAGE;
    }

    public static class FormatCommandTask
    extends HeadlessTask<Void> {
        private String m_cwdin = null;
        private boolean m_errorMade = false;
        private String[] args = null;

        protected FormatCommandTask(String string, String[] stringArray) {
            super(string);
            this.args = stringArray;
        }

        protected Void doWork() throws TaskException {
            String string = null;
            String string2 = null;
            for (String string3 : this.args) {
                if (string3.startsWith(INPUT) && string3.length() > INPUT.length()) {
                    string = string3.substring(INPUT.length());
                    continue;
                }
                if (string3.startsWith(OUTPUT) && string3.length() > OUTPUT.length()) {
                    string2 = string3.substring(OUTPUT.length());
                    continue;
                }
                if (!string3.startsWith(CWD) || string3.length() <= CWD.length()) continue;
                this.m_cwdin = string3.substring(CWD.length());
                if (this.m_cwdin.startsWith("'") && this.m_cwdin.endsWith("'")) {
                    if (this.m_cwdin.length() > 2) {
                        this.m_cwdin = this.m_cwdin.substring(1, this.m_cwdin.length() - 1);
                    } else {
                        this.errorOnCwd(string3, this.m_cwdin);
                        return null;
                    }
                }
                if (new File(this.m_cwdin).exists()) continue;
                this.errorOnCwd(string3, this.m_cwdin);
                return null;
            }
            if (string != null && string2 != null) {
                string = this.putInDir(string);
                string2 = this.putInDir(string2);
            }
            if (string == null || string2 == null || !new File(string).exists()) {
                this.usage();
                return null;
            }
            if (new File(string).isDirectory() && (new File(string2).isDirectory() || !new File(string2).exists())) {
                this.doDirectory(string, string2);
            } else {
                this.inputFileToOutputFile(string, string2);
            }
            if (this.m_errorMade) {
                this.usage();
            }
            return null;
        }

        private void usage() {
            System.out.println(USAGE);
        }

        private void doDirectory(String string, String string2) {
            File[] fileArray;
            if (!new File(string2).isDirectory()) {
                new File(string2).delete();
                if (!new File(string2).mkdir()) {
                    this.errorOn(string, string2);
                    return;
                }
            }
            if ((fileArray = new File(string).listFiles()) != null) {
                for (File file : fileArray) {
                    int n = file.getPath().lastIndexOf(File.separator);
                    int n2 = file.getPath().lastIndexOf(":");
                    if (PlatformUtils.isWindows() && n2 > n && n2 > 0 && n2 < 4) {
                        n = n2;
                    }
                    if (n == -1 || file.getPath().endsWith(File.separator)) {
                        this.errorOn(string, string2);
                        continue;
                    }
                    String string3 = file.getPath();
                    if (n != -1) {
                        string3 = file.getPath().substring(n + 1);
                    }
                    if (file.isDirectory()) {
                        this.doDirectory(file.getPath(), string2 + File.separator + string3);
                        continue;
                    }
                    this.inputFileToOutputFile(file.getPath(), string2 + File.separator + string3);
                }
            }
        }

        private void errorOn(String string, String string2) {
            this.m_errorMade = true;
            System.out.println(SQLFormatterArb.format("ERRORON", INPUT + string, OUTPUT + string2));
        }

        private void errorOnCwd(String string, String string2) {
            this.m_errorMade = true;
            System.out.println(SQLFormatterArb.format("ERRORONCWD", string, string2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void inputFileToOutputFile(String string, String string2) {
            BufferedWriter bufferedWriter = null;
            BufferedReader bufferedReader = null;
            try {
                String string3;
                if (string == null || string2 == null || !new File(string).exists()) {
                    this.errorOn(string, string2);
                    return;
                }
                String string4 = IdeUtil.getIdeEncoding();
                bufferedReader = string4 == null || string4.equals("") ? new BufferedReader(new InputStreamReader(new FileInputStream(string))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string4));
                StringBuffer stringBuffer = new StringBuffer("");
                char[] cArray = new char[CHUNKSIZE];
                int n = 0;
                while ((n = bufferedReader.read(cArray, 0, CHUNKSIZE)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                if (CodingStyleManager.getCodingStyleManager() == null) {
                    CodingStyleManager.setCodingStyleManager(new CodingStyleManagerImpl());
                }
                if ((string3 = new SQLFormatCommand().reallyDoIt(stringBuffer.toString())) != null) {
                    string3 = string3.replaceAll("\r{0,1}\n", Util.getIdeNewLineChar());
                }
                new File(string2).delete();
                bufferedWriter = string4 == null || string4.equals("") ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string2))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), string4));
                bufferedWriter.write(string3);
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                this.errorOn(string, string2);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public String putInDir(String string) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf(":");
            if (PlatformUtils.isWindows() ? n > 0 && n < 4 : string.startsWith("/")) {
                return string;
            }
            String string2 = this.m_cwdin;
            if (string2 == null) {
                string2 = System.getProperty("ide.startingcwd");
                string2 = string2.replaceAll("\"", "");
            }
            if (string2.endsWith(File.separator)) {
                return string2 + string;
            }
            return string2 + File.separator + string;
        }
    }
}

