/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.svg.internal;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.text.DecimalFormat;

public class SVGShape {
    public static final int SHAPE_RECT = 0;
    public static final int SHAPE_RECT_FILL = 10;
    public static final int SHAPE_RECT_OUTLINED = 11;
    public static final int SHAPE_CIRC = 1;
    public static final int SHAPE_LINE = 2;
    public static final int SHAPE_ELLIPSE = 3;
    public static final int SHAPE_POLYGON = 4;
    public static final int SHAPE_POLYGON_FILL = 40;
    public static final int SHAPE_POLYLINE = 5;
    public static final int SHAPE_PATH = 100;
    public static final int SHAPE_PATH_FILL = 101;
    public static final int SHAPE_ROUND_RECT = 6;
    public static final int SHAPE_ROUND_RECT_FILL = 7;
    public static final int SHAPE_OVAL = 8;
    public static final int SHAPE_OVAL_FILL = 9;
    public static final int SHAPE_RECT_FILL_INVISIBLE = 998;
    public static final int SHAPE_RECT_INVISIBLE = 999;
    int shape = 0;
    int[] xCoords;
    int[] yCoords;
    double[] xCoordsDbl;
    double[] yCoordsDbl;
    int numPoints = -1;
    double[] transformMatrix = null;
    int x;
    int y;
    int arcWidth;
    int arcHeight;
    long width;
    long height;
    int x2;
    int y2;
    String color = null;
    String outlineColor = null;
    String opacity = null;
    String outlineOpacity = null;
    float strokeWidth = -1.0f;
    String id = null;
    String userScript = null;
    String dashArray = null;
    String dashPhase = null;
    String path = "";
    DecimalFormat df = new DecimalFormat();

    public SVGShape() {
        this.df.setMaximumFractionDigits(2);
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
    }

    public void setTransformMatrix(double[] matrix) {
        this.transformMatrix = matrix;
    }

    public void drawRect(int x, int y, int width, int height, String color, String opacity) {
        this.shape = 0;
        this.x = x;
        this.y = y;
        this.color = color;
        this.opacity = opacity;
        this.width = width;
        this.height = height;
    }

    public void drawRectInvisible(String id, int x, int y, long width, long height) {
        this.shape = 999;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.id = id;
    }

    public void fillRectInvisible(String userScript, String rectangleID, int x, int y, int width, int height, String color, String opacity) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 998;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.opacity = opacity;
    }

    public void drawOutlinedRect(int x, int y, int width, int height, String innerColor, String outlineColor, String innerOString, String outlineOString) {
        this.shape = 11;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = innerColor;
        this.opacity = this.opacity;
        this.outlineColor = outlineColor;
        this.outlineOpacity = this.outlineOpacity;
    }

    public void fillRect(String userScript, String rectangleID, int x, int y, int width, int height, String color, String opacity) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 10;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.opacity = opacity;
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, String color, String opacity) {
        this.shape = 6;
        this.x = x;
        this.y = y;
        this.color = color;
        this.opacity = opacity;
        this.width = width + 1;
        this.height = height + 1;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, String color, String opacity) {
        this.shape = 7;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.color = color;
        this.opacity = opacity;
    }

    public void drawOval(int x, int y, int width, int height, String color, String opacity, float strokeWidth) {
        this.shape = 8;
        this.width = width / 2;
        this.height = height / 2;
        this.x = x + (int)this.width;
        this.y = y + (int)this.height;
        this.color = color;
        this.opacity = opacity;
        this.strokeWidth = strokeWidth;
    }

    public void fillOval(int x, int y, int width, int height, String color, String opacity) {
        this.shape = 9;
        this.width = width / 2;
        this.height = height / 2;
        this.x = x + (int)this.width;
        this.y = y + (int)this.height;
        this.color = color;
        this.opacity = opacity;
    }

    public void drawLine(int x, int y, int x2, int y2, String color, String opacity, float strokeWidth) {
        this.drawLine(x, y, x2, y2, color, opacity, strokeWidth, null, 0.0f);
    }

    public void drawLineGroup(int x, int y, int x2, int y2) {
        this.shape = 2;
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void drawLine(int x, int y, int x2, int y2, String color, String opacity, float strokeWidth, float[] dashArray, float dashPhase) {
        this.shape = 2;
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
        this.opacity = opacity;
        this.strokeWidth = strokeWidth;
        this.setDash(dashArray, dashPhase);
    }

    public void setDash(float[] dashArray, float dashPhase) {
        if (dashArray != null) {
            this.dashArray = "";
            int i = 0;
            while (i < dashArray.length - 1) {
                this.dashArray = this.dashArray + dashArray[i];
                this.dashArray = this.dashArray + ",";
                ++i;
            }
            this.dashArray = this.dashArray + dashArray[dashArray.length - 1];
        }
        if (dashPhase != 0.0f) {
            this.dashPhase = Float.toString(dashPhase);
        }
    }

    public void drawPolyline(String userScript, String rectangleID, int[] x, int[] y, int numPoints, String color, String opacity, float strokeWidth) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 5;
        this.xCoords = x;
        this.yCoords = y;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
        this.drawPolyline(x, y, numPoints, color, opacity, strokeWidth, null, 0.0f);
    }

    public void drawPolyline(String userScript, String rectangleID, double[] xDbl, double[] yDbl, int[] x, int[] y, int numPoints, String color, String opacity, float strokeWidth) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 5;
        this.xCoords = x;
        this.yCoords = y;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
        this.drawPolyline(xDbl, yDbl, x, y, numPoints, color, opacity, strokeWidth, null, 0.0f);
    }

    public void drawPolyline(int[] x, int[] y, int numPoints, String color, String opacity, float strokeWidth, float[] dashArray, float dashPhase) {
        this.shape = 5;
        this.xCoords = x;
        this.yCoords = y;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
        this.strokeWidth = strokeWidth;
        this.setDash(dashArray, dashPhase);
    }

    public void drawPolyline(double[] xDbl, double[] yDbl, int[] x, int[] y, int numPoints, String color, String opacity, float strokeWidth, float[] dashArray, float dashPhase) {
        this.shape = 5;
        this.xCoords = x;
        this.yCoords = y;
        this.xCoordsDbl = xDbl;
        this.yCoordsDbl = yDbl;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
        this.strokeWidth = strokeWidth;
        this.setDash(dashArray, dashPhase);
    }

    public void fill(String userScript, String rectangleID, Shape s, String color, String opacity) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 101;
        this.color = color;
        this.opacity = opacity;
        this.path = SVGShape.getPath(s);
    }

    public void draw(String userScript, Shape s, String color, String opacity) {
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 100;
        this.color = color;
        this.opacity = opacity;
        this.path = SVGShape.getPath(s);
    }

    private static String getPath(Shape s) {
        PathIterator p = s.getPathIterator(null);
        return SVGShape.getPath(p);
    }

    private static String getPath(PathIterator p) {
        StringBuffer path = new StringBuffer();
        float[] coords = new float[6];
        while (!p.isDone()) {
            int segmentType = p.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    path.append(" M ").append(coords[0]).append(" ").append(coords[1]);
                    break;
                }
                case 1: {
                    path.append(" L ").append(coords[0]).append(" ").append(coords[1]);
                    break;
                }
                case 2: {
                    path.append(" Q ").append(coords[0]).append(" ").append(coords[1]).append(" ").append(coords[2]).append(" ").append(coords[3]);
                    break;
                }
                case 3: {
                    path.append(" C ").append(coords[0]).append(" ").append(coords[1]).append(" ").append(coords[2]).append(" ").append(coords[3]).append(" ").append(coords[4]).append(" ").append(coords[5]);
                    break;
                }
                case 4: {
                    path.append(" Z");
                }
            }
            p.next();
        }
        return path.toString();
    }

    public void fillPolygon(String userScript, String rectangleID, int[] x, int[] y, int numPoints, String color, String opacity) {
        if (rectangleID != null) {
            this.id = rectangleID;
        }
        if (userScript != null) {
            this.userScript = userScript;
        }
        this.shape = 40;
        this.xCoords = x;
        this.yCoords = y;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
    }

    public void drawPolygon(int[] x, int[] y, int numPoints, String color, String opacity) {
        this.shape = 4;
        this.xCoords = x;
        this.yCoords = y;
        this.numPoints = numPoints;
        this.color = color;
        this.opacity = opacity;
    }

    private String getStrokeI() {
        StringBuffer sbuf = new StringBuffer();
        if (this.color != null) {
            sbuf.append(" stroke=\"").append(this.color).append("\"");
        }
        if (this.strokeWidth != -1.0f) {
            sbuf.append(" stroke-width=\"").append(this.strokeWidth).append("\"");
        }
        if (this.dashArray != null) {
            sbuf.append(" stroke-dasharray=\"").append(this.dashArray).append("\"");
        }
        if (this.dashPhase != null) {
            sbuf.append(" stroke-dashoffset=\"").append(this.dashPhase).append("\"");
        }
        if (this.opacity != null) {
            sbuf.append(" stroke-opacity=\"").append(this.opacity).append("\"");
        }
        return sbuf.toString();
    }

    private String getStyleI() {
        StringBuffer sbuf = new StringBuffer();
        if (this.color != null || this.strokeWidth != -1.0f || this.dashArray != null || this.dashPhase != null || this.opacity != null) {
            sbuf.append(" style=\"");
        }
        if (this.color != null) {
            sbuf.append(" stroke: ").append(this.color).append(";");
        }
        if (this.strokeWidth != -1.0f) {
            sbuf.append(" stroke-width: ").append(this.strokeWidth).append(";");
        }
        if (this.dashArray != null) {
            sbuf.append(" stroke-dasharray: ").append(this.dashArray).append(";");
        }
        if (this.dashPhase != null) {
            sbuf.append(" stroke-dashoffset: ").append(this.dashPhase).append(";");
        }
        if (this.opacity != null) {
            sbuf.append(" stroke-opacity: ").append(this.opacity).append(";");
        }
        sbuf.append("\"/>");
        return sbuf.toString();
    }

    private String getPoints() {
        StringBuffer sbuf = new StringBuffer(" points=\"");
        int i = 0;
        while (i < this.numPoints) {
            sbuf.append(this.xCoords[i]).append(",");
            sbuf.append(this.yCoords[i]).append(" ");
            if (i != 0 && i % 8 == 0) {
                sbuf.append("\n");
            }
            ++i;
        }
        sbuf.append("\"");
        return sbuf.toString();
    }

    private String getPointsDouble() {
        StringBuffer sbuf = new StringBuffer(" points=\"");
        if (this.xCoordsDbl != null && this.yCoordsDbl != null) {
            int numPoints2 = Math.min(this.numPoints, this.xCoordsDbl.length);
            numPoints2 = Math.min(numPoints2, this.yCoordsDbl.length);
            int i = 0;
            while (i < numPoints2) {
                if (this.xCoordsDbl != null) {
                    sbuf.append(this.df.format(this.xCoordsDbl[i])).append(",");
                }
                if (this.yCoordsDbl != null) {
                    sbuf.append(this.df.format(this.yCoordsDbl[i])).append(" ");
                }
                if (i != 0 && i % 8 == 0) {
                    sbuf.append("\n");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numPoints) {
                sbuf.append(this.xCoords[i]).append(",");
                sbuf.append(this.yCoords[i]).append(" ");
                if (i != 0 && i % 8 == 0) {
                    sbuf.append("\n");
                }
                ++i;
            }
        }
        sbuf.append("\"");
        return sbuf.toString();
    }

    public String getSVG() {
        StringBuffer sbuf = new StringBuffer();
        switch (this.shape) {
            case 101: {
                sbuf.append("<path ");
                if (this.id != null) {
                    sbuf.append(" id=\"").append(this.id).append("\"");
                }
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                sbuf.append("d=\"");
                sbuf.append(this.path);
                sbuf.append("\"");
                if (this.color != null) {
                    sbuf.append(" fill=").append("\"").append(this.color).append("\"");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity=").append("\"").append(this.opacity).append("\"");
                }
                if (this.transformMatrix != null) {
                    sbuf.append(" transform=\"matrix( ");
                    sbuf.append(this.transformMatrix[0]).append(" ");
                    sbuf.append(this.transformMatrix[1]).append(" ");
                    sbuf.append(this.transformMatrix[2]).append(" ");
                    sbuf.append(this.transformMatrix[3]).append(" ");
                    sbuf.append(this.transformMatrix[4]).append(" ");
                    sbuf.append(this.transformMatrix[5]).append(" )\"");
                }
                sbuf.append(" stroke=").append("\"none\"");
                sbuf.append("/>");
                break;
            }
            case 100: {
                sbuf.append("<path ");
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                sbuf.append("d=\"");
                sbuf.append(this.path);
                sbuf.append("\"");
                if (this.color != null) {
                    sbuf.append(" stroke=").append("\"").append(this.color).append("\"");
                }
                if (this.opacity != null) {
                    sbuf.append(" stroke-opacity=").append("\"").append(this.opacity).append("\"");
                }
                sbuf.append(" fill=").append("\"none\"");
                sbuf.append("/>");
                break;
            }
            case 10: {
                sbuf.append("<rect");
                if (this.id != null) {
                    sbuf.append(" id=\"").append(this.id).append("\"");
                }
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"stroke:none;");
                if (this.color != null) {
                    sbuf.append(" fill: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 11: {
                sbuf.append("<rect");
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"stroke: ").append(this.outlineColor).append(";");
                if (this.outlineOpacity != null) {
                    sbuf.append(" stroke-opacity:").append(this.outlineOpacity).append(";");
                }
                if (this.color != null) {
                    sbuf.append(" fill: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 0: {
                sbuf.append("<rect");
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"fill-opacity:0.0;");
                if (this.color != null) {
                    sbuf.append(" stroke: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" stroke-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 999: {
                sbuf.append("<rect");
                sbuf.append(" id=\"").append(this.id).append("\"");
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"visibility:hidden");
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 998: {
                sbuf.append("<rect");
                if (this.id != null) {
                    sbuf.append(" id=\"").append(this.id).append("\"");
                }
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"stroke:none;");
                if (this.color != null) {
                    sbuf.append(" fill: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity:").append(this.opacity);
                }
                sbuf.append(" visibility:hidden");
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 7: {
                sbuf.append("<rect");
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" rx=\"").append(this.arcWidth).append("\"");
                sbuf.append(" ry=\"").append(this.arcHeight).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"stroke:none;");
                if (this.color != null) {
                    sbuf.append(" fill: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 6: {
                sbuf.append("<rect");
                sbuf.append(" x=\"").append(this.x).append("\"");
                sbuf.append(" y=\"").append(this.y).append("\"");
                sbuf.append(" rx=\"").append(this.arcWidth).append("\"");
                sbuf.append(" ry=\"").append(this.arcHeight).append("\"");
                sbuf.append(" width=\"").append(this.width).append("\"");
                sbuf.append(" height=\"").append(this.height).append("\"");
                sbuf.append(" style=\"fill-opacity:0.0;");
                if (this.color != null) {
                    sbuf.append(" stroke: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" stroke-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 9: {
                sbuf.append("<ellipse");
                sbuf.append(" cx=\"").append(this.x).append("\"");
                sbuf.append(" cy=\"").append(this.y).append("\"");
                sbuf.append(" rx=\"").append(this.width).append("\"");
                sbuf.append(" ry=\"").append(this.height).append("\"");
                sbuf.append(" style=\"stroke:none;");
                if (this.color != null) {
                    sbuf.append(" fill: ").append(this.color).append(";");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity:").append(this.opacity);
                }
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 8: {
                sbuf.append("<ellipse");
                sbuf.append(" cx=\"").append(this.x).append("\"");
                sbuf.append(" cy=\"").append(this.y).append("\"");
                sbuf.append(" rx=\"").append(this.width).append("\"");
                sbuf.append(" ry=\"").append(this.height).append("\"");
                sbuf.append(this.getStrokeI());
                sbuf.append(" style=\"fill-opacity:0.0;");
                sbuf.append("\"");
                sbuf.append("/>");
                break;
            }
            case 2: {
                sbuf.append("<line");
                sbuf.append(" x1=\"").append(this.x).append("\"");
                sbuf.append(" y1=\"").append(this.y).append("\"");
                sbuf.append(" x2=\"").append(this.x2).append("\"");
                sbuf.append(" y2=\"").append(this.y2).append("\"");
                sbuf.append(this.getStrokeI());
                sbuf.append(" />");
                break;
            }
            case 5: {
                sbuf.append("<polyline");
                if (this.id != null) {
                    sbuf.append(" id=\"").append(this.id).append("\"");
                }
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                sbuf.append(this.getStrokeI());
                sbuf.append(" fill=").append("\"none\"");
                sbuf.append(this.getPointsDouble());
                sbuf.append(" />");
                break;
            }
            case 4: {
                sbuf.append("<polygon");
                if (this.color != null) {
                    sbuf.append(" stroke=").append("\"").append(this.color).append("\"");
                }
                if (this.opacity != null) {
                    sbuf.append(" stroke-opacity=").append("\"").append(this.opacity).append("\"");
                }
                sbuf.append(" fill=").append("\"none\"");
                sbuf.append(this.getPoints());
                sbuf.append(" />");
                break;
            }
            case 40: {
                sbuf.append("<polygon");
                if (this.id != null) {
                    sbuf.append(" id=\"").append(this.id).append("\"");
                }
                if (this.userScript != null) {
                    sbuf.append(this.userScript);
                }
                if (this.color != null) {
                    sbuf.append(" fill=").append("\"").append(this.color).append("\"");
                }
                if (this.opacity != null) {
                    sbuf.append(" fill-opacity=").append("\"").append(this.opacity).append("\"");
                }
                sbuf.append(" stroke=").append("\"none\"");
                sbuf.append(this.getPoints());
                sbuf.append(" />");
                break;
            }
            default: {
                System.out.println("NO CASE!!");
            }
        }
        sbuf.append("\n");
        return sbuf.toString();
    }
}

