/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.codec;

class Cube {
    int rmin;
    int rmax;
    int gmin;
    int gmax;
    int bmin;
    int bmax;
    int generation = 0;
    int population = 0;

    Cube(int rn, int gn, int bn, int rm, int gm, int bm, int[][][] hist) {
        this.rmin = rn;
        this.rmax = rm;
        this.gmin = gn;
        this.gmax = gm;
        this.bmin = bn;
        this.bmax = bm;
        this.shrink(hist);
    }

    int color(int[][][] hist) {
        int factor = 256 / hist.length;
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        float sum = 0.0f;
        int r = this.rmin;
        while (r <= this.rmax) {
            int g = this.gmin;
            while (g <= this.gmax) {
                int b = this.bmin;
                while (b <= this.bmax) {
                    if (hist[r][g][b] != 0) {
                        rsum += (float)(factor * r) * (float)hist[r][g][b];
                        gsum += (float)(factor * g) * (float)hist[r][g][b];
                        bsum += (float)(factor * b) * (float)hist[r][g][b];
                        sum += (float)hist[r][g][b];
                    }
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        int red = (int)(rsum / sum);
        int green = (int)(gsum / sum);
        int blue = (int)(bsum / sum);
        return red << 16 | green << 8 | blue;
    }

    void shrink(int[][][] hist) {
        int newRmin = this.rmax;
        int newRmax = this.rmin;
        int newGmin = this.gmax;
        int newGmax = this.gmin;
        int newBmin = this.bmax;
        int newBmax = this.bmin;
        int r = this.rmin;
        while (r <= this.rmax) {
            int g = this.gmin;
            while (g <= this.gmax) {
                int b = this.bmin;
                while (b <= this.bmax) {
                    if (hist[r][g][b] != 0) {
                        if (r < newRmin) {
                            newRmin = r;
                        }
                        if (g < newGmin) {
                            newGmin = g;
                        }
                        if (b < newBmin) {
                            newBmin = b;
                        }
                        if (r > newRmax) {
                            newRmax = r;
                        }
                        if (g > newGmax) {
                            newGmax = g;
                        }
                        if (b > newBmax) {
                            newBmax = b;
                        }
                        this.population += hist[r][g][b];
                    }
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        this.rmin = newRmin;
        this.rmax = newRmax;
        this.gmin = newGmin;
        this.gmax = newGmax;
        this.bmin = newBmin;
        this.bmax = newBmax;
    }

    boolean canSplit() {
        if (this.rmax - this.rmin == 0 && this.gmax - this.gmin == 0 && this.bmax - this.bmin == 0) {
            return false;
        }
        return this.population >= 2;
    }

    int findSplit() {
        int rLen = this.rmax - this.rmin;
        int gLen = this.gmax - this.gmin;
        int bLen = this.bmax - this.bmin;
        if (!this.canSplit()) {
            return 0;
        }
        if (gLen >= rLen && gLen >= bLen) {
            return 2;
        }
        if (rLen >= bLen) {
            return 1;
        }
        return 3;
    }

    Cube splitRed(int[][][] hist) {
        int split;
        if (this.rmax - this.rmin == 1) {
            split = this.rmax;
        } else {
            int pop = 0;
            int half = this.population / 2;
            split = this.rmin;
            while (split < this.rmax && pop < half) {
                int g = this.gmin;
                while (g <= this.gmax && pop < half) {
                    int b = this.bmin;
                    while (b <= this.bmax && pop < half) {
                        pop += hist[split][g][b];
                        ++b;
                    }
                    ++g;
                }
                ++split;
            }
        }
        if (split == this.rmin) {
            ++split;
        }
        Cube cube = new Cube(split, this.gmin, this.bmin, this.rmax, this.gmax, this.bmax, hist);
        cube.generation = this.generation + 1;
        ++this.generation;
        this.population = 0;
        this.rmax = split - 1;
        this.shrink(hist);
        return cube;
    }

    Cube splitGreen(int[][][] hist) {
        int split;
        if (this.gmax - this.gmin == 1) {
            split = this.gmax;
        } else {
            int pop = 0;
            int half = this.population / 2;
            split = this.gmin;
            while (split < this.gmax && pop < half) {
                int r = this.rmin;
                while (r <= this.rmax && pop < half) {
                    int b = this.bmin;
                    while (b <= this.bmax && pop < half) {
                        pop += hist[r][split][b];
                        ++b;
                    }
                    ++r;
                }
                ++split;
            }
        }
        if (split == this.gmin) {
            ++split;
        }
        Cube cube = new Cube(this.rmin, split, this.bmin, this.rmax, this.gmax, this.bmax, hist);
        cube.generation = this.generation + 1;
        ++this.generation;
        this.population = 0;
        this.gmax = split - 1;
        this.shrink(hist);
        return cube;
    }

    Cube splitBlue(int[][][] hist) {
        int split;
        if (this.bmax - this.bmin == 1) {
            split = this.bmax;
        } else {
            int pop = 0;
            int half = this.population / 2;
            split = this.bmin;
            while (split < this.bmax && pop < half) {
                int r = this.rmin;
                while (r <= this.rmax && pop < half) {
                    int g = this.gmin;
                    while (g <= this.gmax && pop < half) {
                        pop += hist[r][g][split];
                        ++g;
                    }
                    ++r;
                }
                ++split;
            }
        }
        if (split == this.bmin) {
            ++split;
        }
        Cube cube = new Cube(this.rmin, this.gmin, split, this.rmax, this.gmax, this.bmax, hist);
        cube.generation = this.generation + 1;
        ++this.generation;
        this.population = 0;
        this.bmax = split - 1;
        this.shrink(hist);
        return cube;
    }

    public String toString() {
        String s = "(" + this.rmin + ", " + this.gmin + ", " + this.bmin + ") (" + this.rmax + ", " + this.gmax + ", " + this.bmax + "); gen = " + this.generation + "; pop = " + this.population;
        return s;
    }
}

